/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.enums.EocLevelEnum;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.EocInfoServiceUtil;
import com.digiwin.metadatacache.util.IntgInfoServiceUtil;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CloudMappingSettingGetService
extends AbstractApiService {
    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;

    public CloudMappingSettingGetService() {
        this.jsonSchemaFileName = "cloud_mapping_setting_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        String tenantId = tRequestJsonNode.get("tenant_id").asText();
        String prodName = tRequestJsonNode.get("prod_name").asText();
        String uid = tRequestJsonNode.get("uid").asText();
        String tEnterPriseId = null;
        if (tRequestJsonNode.get("enterprise_id") != null && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("enterprise_id").asText())) {
            tEnterPriseId = tRequestJsonNode.get("enterprise_id").asText();
        }
        return this.getOperationManageSettingV2(tenantId, prodName, uid, tEnterPriseId);
    }

    private Map<String, Object> getOperationManageSettingV2(String pTenantId, String pProdName, String pUid, String pEnterPriseId) throws Exception {
        ArrayList<EocIntgMapping> tEnterpriseIdMappings = new ArrayList<EocIntgMapping>();
        ArrayList<EocIntgMapping> tRegionIdMappings = new ArrayList<EocIntgMapping>();
        HashMap<String, String> pCondition = new HashMap<String, String>();
        pCondition.put("tenant_id", pTenantId);
        pCondition.put("prod_name", pProdName);
        pCondition.put("eoc_level", "cloud_mapping_id");
        if (pUid != null) {
            pCondition.put("uid", pUid);
        }
        List<EocIntgMapping> tEocIntgMappings = this.eocIntgMappingDao.fetch(pCondition);
        Map<String, String> eocIdMapping = EocInfoServiceUtil.getEocInfoV2MapByUserToken(DWServiceContext.getContext().getRequestHeader().get("token").toString());
        ArrayNode companySiteIdMappings = this.mapper.createArrayNode();
        HashMap<String, String> omIdMap = new HashMap<String, String>();
        for (EocIntgMapping eocIntgMapping : tEocIntgMappings) {
            if (!eocIntgMapping.getCloudMappingType().equals(EocLevelEnum.enterprise_id.toString())) continue;
            tEnterpriseIdMappings.add(eocIntgMapping);
        }
        JsonNode tOmInfoNode = StringUtil.isEmpty(pEnterPriseId) ? (!tEnterpriseIdMappings.isEmpty() ? IntgInfoServiceUtil.getIntgInfo(((EocIntgMapping)tEnterpriseIdMappings.get(0)).getEocId(), pTenantId, pProdName, pUid) : IntgInfoServiceUtil.getIntgInfo(null, pTenantId, pProdName, pUid)) : IntgInfoServiceUtil.getIntgInfo(pEnterPriseId, pTenantId, pProdName, pUid);
        ArrayNode tIntgCompanyAryNode = (ArrayNode)tOmInfoNode.get("org_type_company");
        HashMap omIdNameMap = new HashMap();
        tIntgCompanyAryNode.forEach(x -> {
            omIdNameMap.put(x.get("company_no").asText(), x.get("company_name").asText());
            if (x.get("org_type_site") != null) {
                ArrayNode tOrgTypeSiteAryNodeUnderCompany = (ArrayNode)x.get("org_type_site");
                tOrgTypeSiteAryNodeUnderCompany.forEach(y -> omIdNameMap.put(y.get("site_no").asText(), y.get("site_name").asText()));
            }
        });
        for (EocIntgMapping eocIntgMapping : tEocIntgMappings) {
            omIdMap.put(eocIntgMapping.getIntgId(), eocIntgMapping.getIntgId());
            if (eocIntgMapping.getCloudMappingType().equals(EocLevelEnum.company_id.toString())) {
                ObjectNode tCompanyLevelMappingNode = this.mapper.createObjectNode();
                tCompanyLevelMappingNode.put("eoc_mapping_id", eocIntgMapping.getEocId());
                tCompanyLevelMappingNode.put("om_mapping_id", eocIntgMapping.getIntgId());
                if (eocIdMapping.get(eocIntgMapping.getEocId()) != null) {
                    tCompanyLevelMappingNode.put("eoc_mapping_name", eocIdMapping.get(eocIntgMapping.getEocId()));
                }
                if (omIdNameMap.get(eocIntgMapping.getIntgId()) != null) {
                    tCompanyLevelMappingNode.put("om_mapping_name", (String)omIdNameMap.get(eocIntgMapping.getIntgId()));
                }
                if (eocIntgMapping.getDatakey() != null && !eocIntgMapping.getDatakey().isEmpty()) {
                    tCompanyLevelMappingNode.put("datakey", eocIntgMapping.getDatakey());
                }
                companySiteIdMappings.add((JsonNode)tCompanyLevelMappingNode);
                tCompanyLevelMappingNode.put("enable", true);
                tCompanyLevelMappingNode.put("type", "company_id");
                continue;
            }
            if (eocIntgMapping.getCloudMappingType().equals(EocLevelEnum.site_id.toString())) {
                Iterator tSiteLevelMappingNode = this.mapper.createObjectNode();
                tSiteLevelMappingNode.put("eoc_mapping_id", eocIntgMapping.getEocId());
                tSiteLevelMappingNode.put("om_mapping_id", eocIntgMapping.getIntgId());
                if (eocIdMapping.get(eocIntgMapping.getEocId()) != null) {
                    tSiteLevelMappingNode.put("eoc_mapping_name", eocIdMapping.get(eocIntgMapping.getEocId()));
                }
                if (omIdNameMap.get(eocIntgMapping.getIntgId()) != null) {
                    tSiteLevelMappingNode.put("om_mapping_name", (String)omIdNameMap.get(eocIntgMapping.getIntgId()));
                }
                if (eocIntgMapping.getDatakey() != null && !eocIntgMapping.getDatakey().isEmpty()) {
                    tSiteLevelMappingNode.put("datakey", eocIntgMapping.getDatakey());
                }
                tSiteLevelMappingNode.put("enable", true);
                tSiteLevelMappingNode.put("type", "site_id");
                companySiteIdMappings.add((JsonNode)tSiteLevelMappingNode);
                continue;
            }
            if (!eocIntgMapping.getCloudMappingType().equals(EocLevelEnum.region_id.toString())) continue;
            tRegionIdMappings.add(eocIntgMapping);
        }
        ObjectNode tEnterpriseLevelMappingNode = this.mapper.createObjectNode();
        if (!tEnterpriseIdMappings.isEmpty()) {
            EocIntgMapping mapping = (EocIntgMapping)tEnterpriseIdMappings.get(0);
            tEnterpriseLevelMappingNode.put("eoc_enterprise_id", mapping.getEocId());
            tEnterpriseLevelMappingNode.put("om_enterprise_id", mapping.getIntgId());
            if (mapping.getDatakey() != null && !mapping.getDatakey().isEmpty()) {
                tEnterpriseLevelMappingNode.put("datakey", mapping.getDatakey());
            }
        }
        ArrayNode tOrgTypeRegionArrayNode = this.mapper.createArrayNode();
        for (EocIntgMapping tRegionIdMapping : tRegionIdMappings) {
            ObjectNode tRegionLevelMappingNode = this.mapper.createObjectNode();
            tRegionLevelMappingNode.put("eoc_region_id", tRegionIdMapping.getEocId());
            tRegionLevelMappingNode.put("om_region_id", tRegionIdMapping.getIntgId());
            if (tRegionIdMapping.getDatakey() != null && !tRegionIdMapping.getDatakey().isEmpty()) {
                tRegionLevelMappingNode.put("datakey", tRegionIdMapping.getDatakey());
            }
            tRegionLevelMappingNode.put("enable", true);
            tOrgTypeRegionArrayNode.add((JsonNode)tRegionLevelMappingNode);
        }
        for (JsonNode tIntgCompanyObject : tIntgCompanyAryNode) {
            ObjectNode tAddCompanyMappingNode = this.mapper.createObjectNode();
            if (omIdMap.get(tIntgCompanyObject.get("company_no").asText()) == null) {
                tAddCompanyMappingNode.put("eoc_mapping_id", tIntgCompanyObject.get("company_no").asText());
                tAddCompanyMappingNode.put("om_mapping_id", tIntgCompanyObject.get("company_no").asText());
                tAddCompanyMappingNode.put("om_mapping_name", tIntgCompanyObject.get("company_name").asText());
                if (eocIdMapping.get(tIntgCompanyObject.get("company_no").asText()) != null) {
                    tAddCompanyMappingNode.put("eoc_mapping_name", eocIdMapping.get(tIntgCompanyObject.get("company_no").asText()));
                }
                tAddCompanyMappingNode.put("enable", false);
                tAddCompanyMappingNode.put("type", "company_id");
                companySiteIdMappings.add((JsonNode)tAddCompanyMappingNode);
            }
            if (tIntgCompanyObject.get("org_type_site") == null) continue;
            ArrayNode tOrgTypeSiteAryNodeUnderCompany = (ArrayNode)tIntgCompanyObject.get("org_type_site");
            for (JsonNode tSiteNode : tOrgTypeSiteAryNodeUnderCompany) {
                if (omIdMap.get(tSiteNode.get("site_no").asText()) != null) continue;
                ObjectNode tAddSiteMappingNode = this.mapper.createObjectNode();
                tAddSiteMappingNode.put("eoc_mapping_id", tSiteNode.get("site_no").asText());
                tAddSiteMappingNode.put("om_mapping_id", tSiteNode.get("site_no").asText());
                if (eocIdMapping.get(tSiteNode.get("site_no").asText()) != null) {
                    tAddSiteMappingNode.put("eoc_mapping_name", eocIdMapping.get(tSiteNode.get("site_no").asText()));
                }
                tAddSiteMappingNode.put("om_mapping_name", tSiteNode.get("site_name").asText());
                tAddSiteMappingNode.put("enable", false);
                tAddSiteMappingNode.put("type", "site_id");
                companySiteIdMappings.add((JsonNode)tAddSiteMappingNode);
            }
        }
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        tResponseJsonNode.set("org_type_enterprise", (JsonNode)tEnterpriseLevelMappingNode);
        tResponseJsonNode.set("org_type_mapping", (JsonNode)companySiteIdMappings);
        tResponseJsonNode.set("org_type_region", (JsonNode)tOrgTypeRegionArrayNode);
        tResponseJsonNode.put("tenant_id", pTenantId);
        tResponseJsonNode.put("prod_name", pProdName);
        tResponseJsonNode.put("uid", pUid);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

