/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.TenantEocSetInfoDao;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.TenantEocSetInfo;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IgnoreEocSetService
extends AbstractApiService {
    @Autowired
    private TenantEocSetInfoDao tenantEocSetInfoDao;

    public IgnoreEocSetService() {
        this.jsonSchemaFileName = "ignore_eoc_set_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        return this.ignoreEocSet(tRequestJsonNode);
    }

    private Map<String, Object> ignoreEocSet(JsonNode pMessageNode) {
        String tenantId = pMessageNode.get("tenant_id").asText();
        String userId = pMessageNode.get("user_id").asText();
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("tenant_id", tenantId);
        condition.put("user_id", userId);
        List<TenantEocSetInfo> tenantEocSetInfos = this.tenantEocSetInfoDao.fetch(condition);
        TenantEocSetInfo tenantEocSetInfo = new TenantEocSetInfo();
        if (CollectionUtils.isNotEmpty(tenantEocSetInfos)) {
            tenantEocSetInfo = tenantEocSetInfos.get(0);
            tenantEocSetInfo.setRequireSetting(false);
            tenantEocSetInfo.setLastUpdateTime(Calendar.getInstance());
        } else {
            tenantEocSetInfo.setTenantId(tenantId);
            tenantEocSetInfo.setUserId(userId);
            tenantEocSetInfo.setBuildTime(Calendar.getInstance());
            tenantEocSetInfo.setRequireSetting(false);
        }
        this.tenantEocSetInfoDao.saveOrupdate(tenantEocSetInfo);
        HashMap<String, Object> tReturn = new HashMap<String, Object>();
        tReturn.put("result", "success");
        return tReturn;
    }
}

