/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.EaiTenantMappingDao;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.dao.PrdDatakeyMappingDao;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.dao.ServiceDao;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.exception.TenantIdRelationAlreadyExistsException;
import com.digiwin.metadatacache.model.EaiTenantMapping;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.PrdDatakeyMapping;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.EocInfoServiceUtil;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperationManageSettingUpdateService
extends AbstractApiService {
    @Autowired
    private ProductDao productDao;
    @Autowired
    private ServiceDao serviceDao;
    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;
    @Autowired
    private EaiTenantMappingDao eaiTenantMappingDao;
    @Autowired
    private PrdDatakeyMappingDao prdDatakeyMappingDao;

    public OperationManageSettingUpdateService() {
        this.jsonSchemaFileName = "operation_manage_setting_update_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        this.updateOperationManageSetting(tRequestJsonNode);
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJson = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        return this.converJsonNodeToMap((JsonNode)tResponseJson);
    }

    private List<EocIntgMapping> updateOperationManageSetting(JsonNode pRequestJson) throws Exception {
        ArrayList<EocIntgMapping> tListToUpdate;
        block50: {
            ArrayNode tEocFactoriesAry;
            ArrayNode tEocCompanyAry;
            ArrayList<JsonNode> tSubmitSiteList;
            ArrayList<JsonNode> tSubmitCompanyList;
            String eaiUid;
            String tRegionEocSettingType;
            String tEocSettingType;
            String tTenantId;
            String tAction;
            String tToken;
            ArrayNode tMappingArray;
            block49: {
                tListToUpdate = new ArrayList<EocIntgMapping>();
                tMappingArray = (ArrayNode)pRequestJson.get("mapping_info");
                tToken = DWServiceContext.getContext().getRequestHeader().get("token").toString();
                tAction = pRequestJson.get("action").asText();
                tTenantId = pRequestJson.get("tenant_id").asText();
                String tUid = null;
                tEocSettingType = null;
                tRegionEocSettingType = null;
                eaiUid = null;
                tSubmitCompanyList = new ArrayList<JsonNode>();
                tSubmitSiteList = new ArrayList<JsonNode>();
                tEocCompanyAry = this.mapper.createArrayNode();
                tEocFactoriesAry = this.mapper.createArrayNode();
                if (tMappingArray != null && tMappingArray.size() != 0) {
                    ObjectNode tEocList = EocInfoServiceUtil.getEocInfoByUserToken(tToken);
                    ObjectNode tEocData = (ObjectNode)tEocList.get("data");
                    tEocCompanyAry = (ArrayNode)tEocData.get("companies");
                    tEocFactoriesAry = (ArrayNode)tEocData.get("factories");
                    for (JsonNode tMappingNode : tMappingArray) {
                        if (tMappingNode.get("level").asText().equals("company_id")) {
                            tSubmitCompanyList.add(tMappingNode);
                            continue;
                        }
                        if (!tMappingNode.get("level").asText().equals("site_id")) continue;
                        tSubmitSiteList.add(tMappingNode);
                    }
                }
                if (pRequestJson.get("eoc_setting") != null && pRequestJson.get("eoc_setting").asText().length() != 0) {
                    tEocSettingType = pRequestJson.get("eoc_setting").asText();
                }
                if (pRequestJson.get("eoc_setting_region") != null && pRequestJson.get("eoc_setting_region").asText().length() != 0) {
                    tRegionEocSettingType = pRequestJson.get("eoc_setting_region").asText();
                }
                if (pRequestJson.get("eai_uid") != null && pRequestJson.get("eai_uid").asText().length() != 0) {
                    eaiUid = pRequestJson.get("eai_uid").asText();
                }
                if (!tAction.equals("disable")) break block49;
                for (JsonNode tMappingNode : tMappingArray) {
                    List<EocIntgMapping> childMappings;
                    List<EocIntgMapping> eocIntgMappings;
                    HashMap<String, String> tCondition;
                    String tLevel = tMappingNode.get("level").asText();
                    tUid = tMappingNode.get("uid").asText();
                    String tProdName = tMappingNode.get("prod_name").asText();
                    String tEocId = tMappingNode.get("eoc_id").asText();
                    String tOmId = tMappingNode.get("intg_id").asText();
                    if (tLevel.equals("company_id")) {
                        tCondition = new HashMap<String, String>();
                        tCondition.put("tenant_id", tTenantId);
                        tCondition.put("eoc_level", tLevel);
                        tCondition.put("uid", tUid);
                        tCondition.put("prod_name", tProdName);
                        tCondition.put("eoc_id", tEocId);
                        tCondition.put("intg_id", tOmId);
                        eocIntgMappings = this.eocIntgMappingDao.fetch(tCondition);
                        boolean deleteEoc = false;
                        if (eocIntgMappings == null || eocIntgMappings.isEmpty()) continue;
                        for (JsonNode tEocCompanyNode : tEocCompanyAry) {
                            if (!tEocCompanyNode.get("id").asText().equals(eocIntgMappings.get(0).getEocId())) continue;
                            deleteEoc = true;
                            HashMap<String, String> tEocMappingCondition = new HashMap<String, String>();
                            tEocMappingCondition.put("eoc_level", tLevel);
                            tEocMappingCondition.put("tenant_id", tTenantId);
                            tEocMappingCondition.put("eoc_id", tEocId);
                            List<EocIntgMapping> tEocCompanyAlreadySetList = this.eocIntgMappingDao.fetch(tEocMappingCondition);
                            ArrayList<EocIntgMapping> tTargetEocIntgMapping = new ArrayList<EocIntgMapping>();
                            for (EocIntgMapping mapping : tEocCompanyAlreadySetList) {
                                if (!mapping.getProductName().equals(tProdName) || !mapping.getProductUid().equals(tUid)) continue;
                                tTargetEocIntgMapping.add(mapping);
                            }
                            tEocCompanyAlreadySetList.removeAll(tTargetEocIntgMapping);
                            this.eocIntgMappingDao.deleteChildMapping(eocIntgMappings.get(0).getId());
                            this.eocIntgMappingDao.remove(eocIntgMappings.get(0).getId());
                            break;
                        }
                        if (!deleteEoc) {
                            this.eocIntgMappingDao.deleteChildMapping(eocIntgMappings.get(0).getId());
                            this.eocIntgMappingDao.remove(eocIntgMappings.get(0).getId());
                        }
                        this.clearEnterPriseSetting(tTenantId, tProdName, tUid);
                        this.clearRegionSetting(tTenantId, tProdName, tUid);
                        continue;
                    }
                    if (!tLevel.equals("site_id")) continue;
                    for (JsonNode tEocSiteNode : tEocFactoriesAry) {
                        if (!tEocSiteNode.get("id").asText().equals(tEocId) || tEocSiteNode.get("companyId") == null || !tEocSiteNode.get("companyId").asText().equals(tMappingNode.get("parent_eoc_id").asText())) continue;
                        HashMap<String, String> tEocMappingCondition = new HashMap<String, String>();
                        tEocMappingCondition.put("eoc_level", tLevel);
                        tEocMappingCondition.put("tenant_id", tTenantId);
                        tEocMappingCondition.put("eoc_id", tEocId);
                        List<EocIntgMapping> tEocAlreadySetList = this.eocIntgMappingDao.fetch(tEocMappingCondition);
                        ArrayList<EocIntgMapping> tTargetEocIntgMapping = new ArrayList<EocIntgMapping>();
                        for (EocIntgMapping mapping : tEocAlreadySetList) {
                            if (!mapping.getProductName().equals(tProdName) || !mapping.getProductUid().equals(tUid)) continue;
                            tTargetEocIntgMapping.add(mapping);
                        }
                        tEocAlreadySetList.removeAll(tTargetEocIntgMapping);
                    }
                    this.eocIntgMappingDao.deleteMapping(tTenantId, tLevel, tUid, tProdName, tEocId, tOmId);
                    tCondition = new HashMap<String, String>();
                    tCondition.put("tenant_id", tTenantId);
                    tCondition.put("eoc_level", tMappingNode.get("parent_level").asText());
                    tCondition.put("uid", tUid);
                    tCondition.put("prod_name", tProdName);
                    tCondition.put("eoc_id", tMappingNode.get("parent_eoc_id").asText());
                    eocIntgMappings = this.eocIntgMappingDao.fetch(tCondition);
                    if (eocIntgMappings != null && eocIntgMappings.size() != 0 && ((childMappings = this.eocIntgMappingDao.getChildMapping(eocIntgMappings.get(0).getId())) == null || childMappings.size() == 0)) {
                        this.eocIntgMappingDao.remove(eocIntgMappings.get(0).getId());
                    }
                    this.clearEnterPriseSetting(tTenantId, tProdName, tUid);
                }
                HashMap<String, String> tCondition = new HashMap<String, String>();
                tCondition.put("tenant", tTenantId);
                if (tUid != null && !StringUtil.isEmptyOrSpace(tUid)) {
                    tCondition.put("uid", tUid);
                }
                List<Product> tProducts = this.productDao.fetch(tCondition);
                HashMap<String, String> tMappingCondition = new HashMap<String, String>();
                tMappingCondition.put("product_uid", tUid);
                tMappingCondition.put("tenant_id", tTenantId);
                List<EocIntgMapping> tEocIntgMappings = this.eocIntgMappingDao.fetch(tMappingCondition);
                if (CollectionUtils.isNotEmpty(tProducts) && tEocIntgMappings.size() == 0) {
                    tProducts.get(0).setTenantId("");
                    this.productDao.save(tProducts.get(0));
                }
                if (StringUtil.isEmpty(tTenantId)) break block50;
                this.cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_dispatch_cachemap.getCode() + ":" + tTenantId + "*");
                this.cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_operation_cachemap.getCode() + ":" + tTenantId + "*");
                this.cacheService.removeByPattern(CacheMapTypeEnum.om_tenant_cachemap.getCode() + "*");
                String tenantProductMappingKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + tTenantId;
                Map tProductServiceMapFromCache = (Map)this.cacheService.get(tenantProductMappingKey);
                if (!CollectionUtils.isNotEmpty(tProducts)) break block50;
                String tProductKey = tProducts.get(0).getName() + ":" + tProducts.get(0).getUid() + ":" + tProducts.get(0).getEaiUid();
                if (tProductServiceMapFromCache == null) break block50;
                tProductServiceMapFromCache.remove(tProductKey);
                this.cacheService.set(tenantProductMappingKey, tProductServiceMapFromCache);
                this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u6e05\u9664\u7522\u54c1)\uff1akey = " + tenantProductMappingKey));
                this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u6e05\u9664\u7522\u54c1)\uff1atenant = " + tTenantId + ", product = " + tProductKey));
                break block50;
            }
            if (tAction.equals("enable")) {
                List<EocIntgMapping> eocIntgMappings;
                HashMap<String, String> tCondition;
                if (null != eaiUid) {
                    HashMap<String, String> pCondition = new HashMap<String, String>();
                    pCondition.put("tenant", tTenantId);
                    List<Product> products = this.productDao.fetch((Map<String, String>)pCondition);
                    if (CollectionUtils.isNotEmpty(products)) {
                        String finalEaiUid = eaiUid;
                        if (CollectionUtils.isNotEmpty(products = products.stream().filter(x -> !finalEaiUid.equals(x.getEaiUid())).collect(Collectors.toList()))) {
                            throw new TenantIdRelationAlreadyExistsException(this.getClass());
                        }
                    }
                }
                if (null != tMappingArray && tMappingArray.isArray()) {
                    for (Object tMappingInfoNode : tMappingArray) {
                        if (tMappingInfoNode.get("parent_eoc_id") != null && tMappingInfoNode.get("parent_eoc_id").asText().length() != 0) continue;
                        EocIntgMapping tMapping = new EocIntgMapping();
                        if (tMappingInfoNode.get("eoc_id") == null) continue;
                        tMapping.setEocId(tMappingInfoNode.get("eoc_id").asText());
                        tMapping.setIntgId(tMappingInfoNode.get("intg_id").asText());
                        tMapping.setEocName(tMappingInfoNode.get("eoc_name").asText());
                        tMapping.setIntgName(tMappingInfoNode.get("intg_name").asText());
                        tMapping.setEocLevel(tMappingInfoNode.get("level").asText());
                        tMapping.setProducName(tMappingInfoNode.get("prod_name").asText());
                        tMapping.setProductUid(tMappingInfoNode.get("uid").asText());
                        tMapping.setTenantId(tTenantId);
                        if (tMappingInfoNode.get("region_type") != null) {
                            tMapping.setRegionType(tMappingInfoNode.get("region_type").asText());
                        }
                        HashMap<String, String> tPrdDatakeyMappingCondition = new HashMap<String, String>();
                        tPrdDatakeyMappingCondition.put("prod_name", tMappingInfoNode.get("prod_name").asText());
                        tPrdDatakeyMappingCondition.put("eoc_level", tMappingInfoNode.get("level").asText());
                        List<PrdDatakeyMapping> tDatakeyMappings = this.prdDatakeyMappingDao.fetch(tPrdDatakeyMappingCondition);
                        if (tDatakeyMappings != null && !tDatakeyMappings.isEmpty()) {
                            tMapping.setDatakey(tDatakeyMappings.get(0).getFieldName());
                        }
                        tMapping.setBuildTime(Calendar.getInstance());
                        tListToUpdate.add(tMapping);
                    }
                }
                ArrayList<EocIntgMapping> tRemoveList = new ArrayList<EocIntgMapping>();
                for (EocIntgMapping eocIntgMapping : tListToUpdate) {
                    tCondition = new HashMap<String, String>();
                    tCondition.put("tenant_id", tTenantId);
                    tCondition.put("eoc_level", eocIntgMapping.getEocLevel());
                    tCondition.put("uid", eocIntgMapping.getProductUid());
                    tCondition.put("prod_name", eocIntgMapping.getProducName());
                    tCondition.put("eoc_id", eocIntgMapping.getEocId());
                    tCondition.put("intg_id", eocIntgMapping.getIntgId());
                    eocIntgMappings = this.eocIntgMappingDao.fetch(tCondition);
                    if (eocIntgMappings == null || eocIntgMappings.isEmpty()) continue;
                    tRemoveList.add(eocIntgMapping);
                }
                tListToUpdate.removeAll(tRemoveList);
                this.eocIntgMappingDao.updateList(tListToUpdate);
                tListToUpdate.clear();
                for (JsonNode tNode : tMappingArray) {
                    if (tNode.get("parent_eoc_id") == null || tNode.get("parent_eoc_id").asText().length() == 0 || tNode.get("parent_level") == null || tNode.get("parent_level").asText().length() == 0) continue;
                    HashMap<String, String> tEocIntgMappingCondition = new HashMap<String, String>();
                    tEocIntgMappingCondition.put("eoc_id", tNode.get("parent_eoc_id").asText());
                    tEocIntgMappingCondition.put("eoc_level", tNode.get("parent_level").asText());
                    tEocIntgMappingCondition.put("prod_name", tNode.get("prod_name").asText());
                    tEocIntgMappingCondition.put("tenant_id", tTenantId);
                    List<EocIntgMapping> tEocIntgMappings = this.eocIntgMappingDao.fetch(tEocIntgMappingCondition);
                    EocIntgMapping tMapping = new EocIntgMapping();
                    tMapping.setEocId(tNode.get("eoc_id").asText());
                    tMapping.setEocName(tNode.get("eoc_name").asText());
                    tMapping.setIntgId(tNode.get("intg_id").asText());
                    tMapping.setIntgName(tNode.get("intg_name").asText());
                    tMapping.setEocLevel(tNode.get("level").asText());
                    tMapping.setProducName(tNode.get("prod_name").asText());
                    tMapping.setProductUid(tNode.get("uid").asText());
                    tMapping.setTenantId(tTenantId);
                    if (tEocIntgMappings != null && !tEocIntgMappings.isEmpty()) {
                        tMapping.setEocIntgMapping(tEocIntgMappings.get(0));
                    }
                    HashMap<String, String> tPrdDatakeyMappingCondition = new HashMap<String, String>();
                    tPrdDatakeyMappingCondition.put("prod_name", tNode.get("prod_name").asText());
                    tPrdDatakeyMappingCondition.put("eoc_level", tNode.get("level").asText());
                    List<PrdDatakeyMapping> tDatakeyMappings = this.prdDatakeyMappingDao.fetch(tPrdDatakeyMappingCondition);
                    if (tDatakeyMappings != null && !tDatakeyMappings.isEmpty()) {
                        tMapping.setDatakey(tDatakeyMappings.get(0).getFieldName());
                    }
                    tMapping.setBuildTime(Calendar.getInstance());
                    tListToUpdate.add(tMapping);
                }
                tRemoveList.clear();
                for (EocIntgMapping eocIntgMapping : tListToUpdate) {
                    tCondition = new HashMap();
                    tCondition.put("tenant_id", tTenantId);
                    tCondition.put("eoc_level", eocIntgMapping.getEocLevel());
                    tCondition.put("uid", eocIntgMapping.getProductUid());
                    tCondition.put("prod_name", eocIntgMapping.getProducName());
                    tCondition.put("eoc_id", eocIntgMapping.getEocId());
                    tCondition.put("intg_id", eocIntgMapping.getIntgId());
                    eocIntgMappings = this.eocIntgMappingDao.fetch(tCondition);
                    if (eocIntgMappings == null || eocIntgMappings.isEmpty()) continue;
                    for (EocIntgMapping mapping : eocIntgMappings) {
                        if (!mapping.getEocIntgMapping().getEocId().equals(eocIntgMapping.getEocIntgMapping().getEocId())) continue;
                        tRemoveList.add(eocIntgMapping);
                    }
                }
                tListToUpdate.removeAll(tRemoveList);
                this.eocIntgMappingDao.updateList(tListToUpdate);
                HashMap<String, String> tProductCondition = new HashMap<String, String>();
                tProductCondition.put("uid", tMappingArray.get(0).get("uid").asText());
                List<Product> tProducts = this.productDao.fetch(tProductCondition);
                boolean tProductWithSameTenantIdExist = false;
                boolean tProductWithNoTenantIdExist = false;
                for (Product tProduct : tProducts) {
                    if (!tTenantId.equals(tProduct.getTenantId())) continue;
                    if (tEocSettingType != null) {
                        tProduct.setEocSetting(tEocSettingType);
                    }
                    if (tRegionEocSettingType != null) {
                        tProduct.setEocSettingRegion(tRegionEocSettingType);
                    }
                    tProduct.setLastUpdateTime(Calendar.getInstance());
                    this.productDao.save(tProduct);
                    tProductWithSameTenantIdExist = true;
                }
                if (!tProductWithSameTenantIdExist) {
                    List<EaiTenantMapping> eaiTenantMappings;
                    HashMap<String, String> tCondition2;
                    for (Product tProduct : tProducts) {
                        if (tProduct.getTenantId() != null && tProduct.getTenantId().length() != 0) continue;
                        tCondition2 = new HashMap<String, String>();
                        tCondition2.put("tenant", tTenantId);
                        eaiTenantMappings = this.eaiTenantMappingDao.fetch(tCondition2);
                        if (eaiTenantMappings == null || eaiTenantMappings.size() == 0 || !tProduct.getEaiUid().equals(eaiTenantMappings.get(0).getEaUid())) continue;
                        if (tEocSettingType != null) {
                            tProduct.setEocSetting(tEocSettingType);
                        }
                        if (tRegionEocSettingType != null) {
                            tProduct.setEocSettingRegion(tRegionEocSettingType);
                        }
                        tProduct.setTenantId(tTenantId);
                        tProduct.setLastUpdateTime(Calendar.getInstance());
                        this.productDao.save(tProduct);
                        tProductWithNoTenantIdExist = true;
                        break;
                    }
                    if (!tProductWithNoTenantIdExist) {
                        for (Product tProduct : tProducts) {
                            tCondition2 = new HashMap();
                            tCondition2.put("tenant", tTenantId);
                            eaiTenantMappings = this.eaiTenantMappingDao.fetch(tCondition2);
                            if (eaiTenantMappings == null || eaiTenantMappings.size() == 0 || !tProduct.getEaiUid().equals(eaiTenantMappings.get(0).getEaUid())) continue;
                            List<com.digiwin.metadatacache.model.Service> tServices = this.serviceDao.getByPrdId(tProduct.getId());
                            if (tEocSettingType != null) {
                                tProduct.setEocSetting(tEocSettingType);
                            }
                            if (tRegionEocSettingType != null) {
                                tProduct.setEocSettingRegion(tRegionEocSettingType);
                            }
                            tProduct.setBuildTime(Calendar.getInstance());
                            tProduct.setTenantId(tTenantId);
                            tProduct.setId(null);
                            Product tReturnedProduct = this.productDao.save(tProduct);
                            for (com.digiwin.metadatacache.model.Service service : tServices) {
                                service.setProduct(tReturnedProduct);
                                service.setId(null);
                                this.serviceDao.save(service);
                            }
                        }
                    }
                }
                if (!StringUtil.isEmpty(tTenantId)) {
                    this.cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_dispatch_cachemap.getCode() + ":" + tTenantId + "*");
                    this.cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_operation_cachemap.getCode() + ":" + tTenantId + "*");
                    this.cacheService.removeByPattern(CacheMapTypeEnum.om_tenant_cachemap.getCode() + "*");
                    String tenantProductMappingKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + tTenantId;
                    Map tProductServiceMapFromCache = (Map)this.cacheService.get(tenantProductMappingKey);
                    String tProductKey = tProducts.get(0).getName() + ":" + tProducts.get(0).getUid() + ":" + tProducts.get(0).getEaiUid();
                    if (tProductServiceMapFromCache != null) {
                        tProductServiceMapFromCache.remove(tProductKey);
                        this.cacheService.set(tenantProductMappingKey, tProductServiceMapFromCache);
                        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u6e05\u9664\u7522\u54c1)\uff1akey = " + tenantProductMappingKey));
                        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u6e05\u9664\u7522\u54c1)\uff1atenant = " + tTenantId + ", product = " + tProductKey));
                    }
                }
                if (tMappingArray.size() != 0) {
                    for (JsonNode tNode : tSubmitCompanyList) {
                        boolean companyExist = false;
                        for (JsonNode tEocCompanyNode : tEocCompanyAry) {
                            if (!tEocCompanyNode.get("id").asText().equals(tNode.get("eoc_id").asText())) continue;
                            companyExist = true;
                            break;
                        }
                        if (companyExist) continue;
                        String tParentEnterpriseSid = EocInfoServiceUtil.getEnterPriseSid(tToken);
                        EocInfoServiceUtil.updateEocEntry("", tNode.get("eoc_id").asText(), tToken, 2, 2, tParentEnterpriseSid, 0);
                    }
                    for (JsonNode tSiteNode : tSubmitSiteList) {
                        boolean siteExist = false;
                        for (JsonNode tEocSiteNode : tEocFactoriesAry) {
                            if (!tEocSiteNode.get("id").asText().equals(tSiteNode.get("eoc_id").asText()) || tEocSiteNode.get("companyId") == null || !tEocSiteNode.get("companyId").asText().equals(tSiteNode.get("parent_eoc_id").asText())) continue;
                            siteExist = true;
                            break;
                        }
                        if (siteExist) continue;
                        String tCompanySid = EocInfoServiceUtil.getCompanySid(tToken, tSiteNode.get("parent_eoc_id").asText());
                        EocInfoServiceUtil.updateEocEntry("", tSiteNode.get("eoc_id").asText(), tToken, 3, 3, tCompanySid, 0);
                    }
                }
            }
        }
        return tListToUpdate;
    }

    private void clearEnterPriseSetting(String pTenantId, String pProdName, String pUid) {
        HashMap<String, String> tCondition = new HashMap<String, String>();
        tCondition.put("tenant_id", pTenantId);
        tCondition.put("prod_name", pProdName);
        tCondition.put("uid", pUid);
        boolean tRestCompanyOrSite = false;
        List<EocIntgMapping> eocIntgRestMappings = this.eocIntgMappingDao.fetch(tCondition);
        if (eocIntgRestMappings != null && !eocIntgRestMappings.isEmpty()) {
            for (EocIntgMapping eocIntgMapping : eocIntgRestMappings) {
                if (!eocIntgMapping.getEocLevel().equals("company_id") && !eocIntgMapping.getEocLevel().equals("site_id")) continue;
                tRestCompanyOrSite = true;
                break;
            }
            if (!tRestCompanyOrSite) {
                for (EocIntgMapping eocIntgMapping : eocIntgRestMappings) {
                    if (!eocIntgMapping.getEocLevel().equals("enterprise_id")) continue;
                    this.eocIntgMappingDao.remove(eocIntgMapping.getId());
                }
            }
        }
    }

    private void clearRegionSetting(String pTenantId, String pProdName, String pUid) {
        HashMap<String, String> tCondition = new HashMap<String, String>();
        tCondition.put("tenant_id", pTenantId);
        tCondition.put("prod_name", pProdName);
        tCondition.put("uid", pUid);
        boolean tRestCompanyOrSite = false;
        List<EocIntgMapping> eocIntgRestMappings = this.eocIntgMappingDao.fetch(tCondition);
        if (eocIntgRestMappings != null && !eocIntgRestMappings.isEmpty()) {
            for (EocIntgMapping eocIntgMapping : eocIntgRestMappings) {
                if (!eocIntgMapping.getEocLevel().equals("company_id") && !eocIntgMapping.getEocLevel().equals("site_id")) continue;
                tRestCompanyOrSite = true;
                break;
            }
            if (!tRestCompanyOrSite) {
                for (EocIntgMapping eocIntgMapping : eocIntgRestMappings) {
                    if (!eocIntgMapping.getEocLevel().equals("region_id")) continue;
                    this.eocIntgMappingDao.remove(eocIntgMapping.getId());
                }
            }
        }
    }
}

