/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.services.LoadCacheService;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShowCacheService
extends AbstractApiService {
    @Autowired
    private LoadCacheService loadCacheService;

    public ShowCacheService() {
        this.jsonSchemaFileName = "clean_cache_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        String tType = tRequestJsonNode.get("type").asText();
        Set<String> tKeys = new HashSet<String>();
        switch (tType) {
            case "tenantProductMappingList": {
                tKeys = this.cacheService.getKeysByPattern(CacheMapTypeEnum.tenant_product_mapping_list.getCode() + "*");
                break;
            }
            case "apiVersionList": {
                tKeys = this.cacheService.getKeysByPattern(CacheMapTypeEnum.api_version_list.getCode() + "*");
                break;
            }
            case "dispatch": {
                tKeys = this.cacheService.getKeysByPattern(CacheMapTypeEnum.tenant_product_dispatch_cachemap.getCode() + "*");
                break;
            }
            case "organizationList": {
                tKeys = this.cacheService.getKeysByPattern(CacheMapTypeEnum.tenant_product_operation_cachemap.getCode() + "*");
                break;
            }
            case "apiBaseInfo": {
                return this.loadCacheService.showData();
            }
            case "apiMetadata": {
                tKeys.add(tRequestJsonNode.get("name").asText());
                break;
            }
            case "omTenant": {
                tKeys = this.cacheService.getKeysByPattern(CacheMapTypeEnum.om_tenant_cachemap.getCode() + "*");
                break;
            }
            case "globalParam": {
                tKeys = this.cacheService.getKeysByPattern(CacheMapTypeEnum.global_param_cachemap.getCode() + "*");
                break;
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String tKey : tKeys) {
            Object cacheValue = this.cacheService.get(tKey);
            if (cacheValue == null) continue;
            map.put(tKey, cacheValue);
        }
        return map;
    }
}

