/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.apiservice.ApiRelationSaveService;
import com.digiwin.metadatacache.apiservice.AssetRegisterService;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.dao.ApiDao;
import com.digiwin.metadatacache.dao.ApiMetadataDao;
import com.digiwin.metadatacache.dao.ApiVersionDao;
import com.digiwin.metadatacache.enums.ApiTypeEnum;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.Api;
import com.digiwin.metadatacache.model.ApiMetadata;
import com.digiwin.metadatacache.model.ApiVersion;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.services.LoadCacheService;
import com.digiwin.metadatacache.services.LocalCacheService;
import com.digiwin.metadatacache.util.DateUtil;
import com.digiwin.metadatacache.util.MQUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StdApiMetadataUpdateService
extends AbstractApiService {
    @Autowired
    private ApiDao apiDao;
    @Autowired
    private ApiVersionDao apiVersionDao;
    @Autowired
    private ApiMetadataDao apiMetadataDao;
    @Autowired
    private ApiRelationSaveService apiRelationSaveService;
    @Autowired
    private LoadCacheService loadCacheService;
    @Autowired
    private LocalCacheService localCacheService;
    @Autowired
    private AssetRegisterService assetRegisterService;

    public StdApiMetadataUpdateService() {
        this.jsonSchemaFileName = "standard_api_update_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        String tUserId = (String)DWServiceContext.getContext().getRequestHeader().get("userId");
        ArrayNode tApiArrayNode = (ArrayNode)tRequestJsonNode.get("api_data");
        if (tApiArrayNode.isArray()) {
            for (JsonNode tApi : tApiArrayNode) {
                this.update(tApi, tUserId);
            }
        }
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    private void update(JsonNode tApiData, String tUserId) throws Exception {
        HashMap<String, Object> tDataMap = new HashMap<String, Object>();
        ArrayList<String> versionList = new ArrayList<String>();
        block21: for (String tApiInfoKey : MdcConstant.API_INFO_SPEC_KEY) {
            JsonNode tData = tApiData.get(tApiInfoKey);
            switch (tApiInfoKey) {
                case "api_name": 
                case "type": 
                case "category": 
                case "provider": {
                    tDataMap.put(tApiInfoKey, tData.asText());
                    continue block21;
                }
                case "app_name": 
                case "tenant_id": 
                case "package_name": 
                case "parent_api_name": 
                case "api_extend": {
                    if (tData == null) continue block21;
                    tDataMap.put(tApiInfoKey, tData.asText());
                    continue block21;
                }
                case "api_version_info": {
                    ObjectNode tVersionDataNode = this.mapper.createObjectNode();
                    ArrayNode tArrayNode = (ArrayNode)tData;
                    if (tArrayNode.isArray()) {
                        for (JsonNode tArrayElement : tArrayNode) {
                            tDataMap.put("approved_status", tArrayElement.get("approved_status").asText());
                            if (tArrayElement.get("idempotency") != null) {
                                tDataMap.put("idempotency", tArrayElement.get("idempotency").asText());
                            }
                            tVersionDataNode.set(tArrayElement.get("api_version").asText(), tArrayElement.get("data_metadata"));
                            versionList.add(tArrayElement.get("api_version").asText());
                        }
                    }
                    tDataMap.put("api_version_info", tVersionDataNode);
                    continue block21;
                }
                case "description": {
                    if (!tData.isObject()) continue block21;
                    tDataMap.put("description_zh_tw", tData.get("zh_TW").asText());
                    tDataMap.put("description_zh_cn", tData.get("zh_CN").asText());
                    tDataMap.put("description_en", tData.get("en").asText());
                    continue block21;
                }
                case "remark": {
                    if (tData == null || !tData.isObject()) continue block21;
                    tDataMap.put("remark_zh_tw", tData.get("zh_TW").asText());
                    tDataMap.put("remark_zh_cn", tData.get("zh_CN").asText());
                    tDataMap.put("remark_en", tData.get("en").asText());
                    continue block21;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(versionList)) {
            String tTenantId = null;
            if (null != tDataMap.get("tenant_id")) {
                tTenantId = String.valueOf(tDataMap.get("tenant_id"));
            }
            for (String version : versionList) {
                this.deleteApi(String.valueOf(tDataMap.get("api_name")), version, tTenantId);
            }
        }
        if (tDataMap.get("app_name") != null && tDataMap.get("app_name").toString().length() != 0) {
            this.addApi(tDataMap, ApiTypeEnum.agile.toString(), tUserId);
        } else {
            this.addApi(tDataMap, ApiTypeEnum.standard.toString(), tUserId);
        }
        this.log.info((Object)("Append Send MQ: apiName=" + tDataMap.get("api_name") + ",action=add"));
        String tApiMetadataStr = this.sendMqMessage(tDataMap);
        MQUtil.sendApiMetadata(tApiMetadataStr);
        this.log.info((Object)"Send AddApi MQ Success.");
        this.log.info((Object)"\u521b\u5efaAPI\u5173\u8054\u5173\u7cfb\u5f00\u59cb");
        if (null != tDataMap.get("parent_api_name")) {
            this.apiRelationSaveService.saveApiRelation(tDataMap.get("parent_api_name").toString(), tDataMap.get("api_name").toString(), null != tDataMap.get("tenant_id") ? tDataMap.get("tenant_id").toString() : null, tUserId);
        }
        this.log.info((Object)"\u521b\u5efaAPI\u5173\u8054\u5173\u7cfb\u7ed3\u675f");
    }

    private void deleteApi(String apiName, String apiVersion, String tenantId) throws Exception {
        this.apiDao.removeByNameAndVersionTenantId(apiName, apiVersion, tenantId);
        this.cacheService.remove(CacheMapTypeEnum.api_version_list.getCode() + ":" + apiName);
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u6e05\u9664\u670d\u52d9\u7248\u672c\u865f)\uff1akey = " + CacheMapTypeEnum.api_version_list.getCode() + ":" + apiName));
        this.loadCacheService.removeData(CacheMapTypeEnum.api_base_info_cachemap.getCode() + ":" + apiName);
        this.localCacheService.remove(CacheMapTypeEnum.api_relation_idempotency_cachemap, apiName);
        this.log.info((Object)("\u5220\u9664\u672c\u5730\u7f13\u5b58: " + CacheMapTypeEnum.api_base_info_cachemap.getCode() + ":" + apiName));
        ObjectNode tApiMetadataNode = this.mapper.createObjectNode();
        tApiMetadataNode.put("api_name", apiName);
        tApiMetadataNode.put("api_version", apiVersion);
        if (tenantId != null) {
            tApiMetadataNode.put("tenant_id", tenantId);
        }
        tApiMetadataNode.put("timestamp", DateUtil.formatToDate(new Date()));
        tApiMetadataNode.put("action", "delete");
        this.log.info((Object)("\u540c\u6b65\u5220\u9664\u4fe1\u606f\u81f3MQ\u5f00\u59cb_API\u540d\u79f0:" + apiName + ",API\u7248\u672c:" + apiVersion + ",API\u79df\u6237:" + tenantId));
        MQUtil.sendApiMetadata(tApiMetadataNode.toString());
        this.log.info((Object)"Send DeleteApi MQ Success.");
    }

    private void addApi(Map<String, Object> tDataMap, String pApiType, String userName) throws Exception {
        Api tApi = new Api();
        ArrayList<ApiVersion> apiVersionList = new ArrayList<ApiVersion>();
        ApiVersion tApiVersion = new ApiVersion();
        ApiMetadata tApiMetadata = new ApiMetadata();
        String tVersionMapString = tDataMap.get("api_version_info").toString();
        Map tVersionMap = (Map)this.mapper.readValue(tVersionMapString, Map.class);
        for (String tVersion : tVersionMap.keySet()) {
            tApiVersion.setVersion(tVersion);
            tApiVersion.setApprovedStatus(Long.valueOf(tDataMap.get("approved_status").toString()));
            if (tDataMap.get("idempotency") != null) {
                tApiVersion.setIdempotency(Boolean.parseBoolean(tDataMap.get("idempotency").toString()));
            }
            tApiVersion.setBuildTime(Calendar.getInstance());
            tApiVersion.setApi(tApi);
            tApi.addApiVersion(tApiVersion);
            tApiMetadata.setBuildTime(Calendar.getInstance());
            tApiMetadata.setMetadata(this.mapper.writeValueAsString(tVersionMap.get(tVersion)));
            tApiVersion.setApiMetadata(tApiMetadata);
            apiVersionList.add(tApiVersion);
            tApi.setApiVersions(apiVersionList);
            tApi.setName(tDataMap.get("api_name").toString().trim());
            if (null != tDataMap.get("api_extend")) {
                tApi.setApiExtend(tDataMap.get("api_extend").toString());
            }
            if (tDataMap.get("type") == null) {
                tApi.setInvokedType("sync");
            } else {
                tApi.setInvokedType(tDataMap.get("type").toString().trim());
            }
            tApi.setProvider(tDataMap.get("provider").toString().trim());
            tApi.setDescriptionZhTw(tDataMap.get("description_zh_tw").toString().trim());
            tApi.setDescriptionZhCn(tDataMap.get("description_zh_cn").toString().trim());
            tApi.setDescriptionEn(tDataMap.get("description_en").toString().trim());
            if (tDataMap.containsKey("remark_zh_tw")) {
                tApi.setRemarkZhTw(tDataMap.get("remark_zh_tw").toString().trim());
            }
            if (tDataMap.containsKey("remark_zh_cn")) {
                tApi.setRemarkZhCn(tDataMap.get("remark_zh_cn").toString().trim());
            }
            if (tDataMap.containsKey("remark_en")) {
                tApi.setRemarkEn(tDataMap.get("remark_en").toString().trim());
            }
            tApi.setCategory(tDataMap.get("category").toString().trim());
            tApi.setApi_type(pApiType);
            String tTenantId = null;
            if (tDataMap.get("tenant_id") != null && tDataMap.get("tenant_id").toString().length() != 0) {
                tTenantId = tDataMap.get("tenant_id").toString().trim();
                tApi.setTenantId(tTenantId);
            }
            if (tDataMap.get("package_name") != null && tDataMap.get("package_name").toString().length() != 0) {
                tApi.setPackageName(tDataMap.get("package_name").toString().trim());
            }
            tApi.setBuildTime(Calendar.getInstance());
            this.apiDao.save(tApi);
            this.cacheService.remove(CacheMapTypeEnum.api_version_list.getCode() + ":" + tApi.getName());
            this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u6e05\u9664\u670d\u52d9\u7248\u672c\u865f)\uff1akey = " + CacheMapTypeEnum.api_version_list.getCode() + ":" + tApi.getName()));
            this.loadCacheService.removeData(CacheMapTypeEnum.api_base_info_cachemap.getCode() + ":" + tApi.getName());
            this.localCacheService.remove(CacheMapTypeEnum.api_relation_idempotency_cachemap, tApi.getName());
            this.log.info((Object)("\u5220\u9664\u672c\u5730\u7f13\u5b58: " + CacheMapTypeEnum.api_base_info_cachemap.getCode() + ":" + tApi.getName()));
        }
    }
}

