/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.MdcApplicationParameter;
import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.EaiTenantMappingDao;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EaiTenantMapping;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantBindProductListGetService
extends AbstractApiService {
    @Autowired
    private ProductDao productDao;
    @Autowired
    private EaiTenantMappingDao eaiTenantMappingDao;

    public TenantBindProductListGetService() {
        this.jsonSchemaFileName = "tenant_bind_prd_list_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        String tTenantId = tRequestJsonNode.get("tenant_id").asText();
        return this.processBindProductGet(tTenantId);
    }

    private Map<String, Object> processBindProductGet(String pTenantId) {
        ObjectNode tDataNode = this.mapper.createObjectNode();
        tDataNode.put("tenant_id", pTenantId);
        ArrayNode tGatewayArrayNode = this.mapper.createArrayNode();
        tDataNode.set("gateway", (JsonNode)tGatewayArrayNode);
        HashMap<String, String> tEaiTenantMappingCondition = new HashMap<String, String>();
        tEaiTenantMappingCondition.put("tenant", pTenantId);
        List<EaiTenantMapping> tEaiTenantMappings = this.eaiTenantMappingDao.fetch(tEaiTenantMappingCondition);
        if (!tEaiTenantMappings.isEmpty()) {
            String tEaiUid = tEaiTenantMappings.get(0).getEaUid();
            HashMap<String, String> tEaiTenantMappingConditionForAllTenant = new HashMap<String, String>();
            tEaiTenantMappingConditionForAllTenant.put("eai_uid", tEaiUid);
            List<EaiTenantMapping> tEaiTenantMappingsForAllTenant = this.eaiTenantMappingDao.fetch(tEaiTenantMappingConditionForAllTenant);
            ArrayList<String> tTenantList = new ArrayList<String>();
            for (EaiTenantMapping tTenantMapping : tEaiTenantMappingsForAllTenant) {
                tTenantList.add(tTenantMapping.getTenantId());
            }
            HashMap<String, String> pProductCondition = new HashMap<String, String>();
            pProductCondition.put("eai_uid", tEaiTenantMappings.get(0).getEaUid());
            List<Product> tEaiAllProductList = this.productDao.fetch(pProductCondition);
            HashMap<String, ArrayList<Product>> tProductMapGroupByProdName = new HashMap<String, ArrayList<Product>>();
            for (Product tProduct : tEaiAllProductList) {
                List<Product> tProducts = (List)tProductMapGroupByProdName.get(tProduct.getName());
                if (CollectionUtils.isEmpty((Collection)tProducts)) {
                    tProducts = new ArrayList<Product>();
                    tProductMapGroupByProdName.put(tProduct.getName(), (ArrayList<Product>)tProducts);
                }
                tProducts.add(tProduct);
            }
            ArrayList<Product> tReturnProductList = new ArrayList<Product>();
            ArrayList<String> tExistUidList = new ArrayList<String>();
            for (String tProductType : tProductMapGroupByProdName.keySet()) {
                for (Product tProduct : (List)tProductMapGroupByProdName.get(tProductType)) {
                    if (tProduct.getTenantId() != null && !tExistUidList.contains(tProduct.getUid()) && tTenantList.contains(tProduct.getTenantId())) {
                        tReturnProductList.add(tProduct);
                    }
                    if (StringUtil.isEmptyOrSpace(tProduct.getUid())) continue;
                    tExistUidList.add(tProduct.getUid());
                }
            }
            if (!tReturnProductList.isEmpty()) {
                Map tProductsMap = this.transformListToGroupMap(tReturnProductList, pTenantId);
                for (String tGatewayId : tProductsMap.get(pTenantId).keySet()) {
                    ObjectNode tGatewayItemNode = this.mapper.createObjectNode();
                    tGatewayItemNode.put("gateway_id", tGatewayId);
                    tGatewayArrayNode.add((JsonNode)tGatewayItemNode);
                    ArrayNode tProductArrayNode = this.mapper.createArrayNode();
                    for (String tProductName : tProductsMap.get(pTenantId).get(tGatewayId).keySet()) {
                        for (Product tProduct : tProductsMap.get(pTenantId).get(tGatewayId).get(tProductName)) {
                            ObjectNode tProductItemNode = this.mapper.createObjectNode();
                            tProductItemNode.put("name", tProduct.getName());
                            tProductItemNode.put("version", tProduct.getVersion());
                            tProductItemNode.put("ip", tProduct.getIp());
                            tProductItemNode.put("id", tProduct.getApid());
                            tProductItemNode.put("uid", tProduct.getUid());
                            if (MdcApplicationParameter._ERP_LIST.contains(tProduct.getName())) {
                                tProductItemNode.put("type", "ERP");
                            }
                            tProductArrayNode.add((JsonNode)tProductItemNode);
                        }
                    }
                    tGatewayItemNode.set("product", (JsonNode)this.sortProductArray(tProductArrayNode));
                }
            }
        }
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, (JsonNode)tDataNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    private <T> Map<String, Map<String, Map<String, List<T>>>> transformListToGroupMap(List<T> pList, String pTenant) {
        HashMap<String, Map<String, Map<String, List<T>>>> tTenantMap = new HashMap<String, Map<String, Map<String, List<T>>>>();
        for (T tObject : pList) {
            ArrayList<T> tServiceList;
            HashMap<String, ArrayList<T>> tProductNameMap;
            Product tProduct = null;
            if (tObject instanceof Product) {
                tProduct = (Product)tObject;
            } else if (tObject instanceof com.digiwin.metadatacache.model.Service) {
                tProduct = ((com.digiwin.metadatacache.model.Service)tObject).getProduct();
            }
            if (tProduct == null) continue;
            HashMap tGatewayMap = (HashMap)tTenantMap.get(pTenant);
            if (tGatewayMap == null) {
                tGatewayMap = new HashMap();
                tTenantMap.put(pTenant, tGatewayMap);
            }
            if ((tProductNameMap = (HashMap<String, ArrayList<T>>)tGatewayMap.get(tProduct.getGatewayId())) == null) {
                tProductNameMap = new HashMap<String, ArrayList<T>>();
                tGatewayMap.put(tProduct.getGatewayId(), tProductNameMap);
            }
            if ((tServiceList = (ArrayList<T>)tProductNameMap.get(tProduct.getName())) == null) {
                tServiceList = new ArrayList<T>();
                tProductNameMap.put(tProduct.getName(), tServiceList);
            }
            tServiceList.add(tObject);
        }
        return tTenantMap;
    }

    public ArrayNode sortProductArray(ArrayNode pArrayNode) {
        ArrayList<JsonNode> prdList = new ArrayList<JsonNode>();
        for (JsonNode node : pArrayNode) {
            prdList.add(node);
        }
        Collections.sort(prdList, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = ((ObjectNode)o1).get("name").asText();
                String name2 = ((ObjectNode)o2).get("name").asText();
                return name1.compareTo(name2);
            }
        });
        ArrayNode sortedJsonArray = this.mapper.createArrayNode();
        for (JsonNode jsonNode : prdList) {
            sortedJsonArray.add(jsonNode);
        }
        return sortedJsonArray;
    }
}

