/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.EaiTenantMappingDao;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EaiTenantMapping;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantEaiInfoGetService
extends AbstractApiService {
    @Autowired
    private ProductDao productDao;
    @Autowired
    private EaiTenantMappingDao eaiTenantMappingDao;

    @Autowired
    public TenantEaiInfoGetService() {
        this.jsonSchemaFileName = "tenant_eai_info_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode tDataNode = mapper.createArrayNode();
        ArrayNode tTenantList = (ArrayNode)tRequestJsonNode.get("tenant");
        ArrayList<String> tEaiList = new ArrayList<String>();
        for (JsonNode tTenant : tTenantList) {
            String tEaiUid;
            HashMap<String, String> tEaiTenantMappingCondition = new HashMap<String, String>();
            tEaiTenantMappingCondition.put("tenant", tTenant.asText());
            List<EaiTenantMapping> tEaiTenantMappings = this.eaiTenantMappingDao.fetch(tEaiTenantMappingCondition);
            if (!CollectionUtils.isNotEmpty(tEaiTenantMappings) || tEaiList.contains(tEaiUid = tEaiTenantMappings.get(0).getEaUid())) continue;
            tEaiList.add(tEaiUid);
            ObjectNode tTenantEaiInfoNode = mapper.createObjectNode();
            tTenantEaiInfoNode.put("tenant_id", tTenant.asText());
            tTenantEaiInfoNode.put("eai_uid", tEaiUid);
            ArrayNode tProductInfoNode = mapper.createArrayNode();
            HashMap<String, String> tProductCondition = new HashMap<String, String>();
            tProductCondition.put("eai_uid", tEaiUid);
            List<Product> tProducts = this.productDao.fetch(tProductCondition);
            if (CollectionUtils.isNotEmpty(tProducts)) {
                ArrayList<String> tProdNameList = new ArrayList<String>();
                for (Product tProduct : tProducts) {
                    if (tProdNameList.contains(tProduct.getName())) continue;
                    tProdNameList.add(tProduct.getName());
                    tProductInfoNode.add(tProduct.getName());
                }
            }
            tTenantEaiInfoNode.set("product", (JsonNode)tProductInfoNode);
            tDataNode.add((JsonNode)tTenantEaiInfoNode);
        }
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        tResponseJsonNode.set("data", (JsonNode)tDataNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

