/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantProductCloudMappingGetService
extends AbstractApiService {
    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;

    public TenantProductCloudMappingGetService() {
        this.jsonSchemaFileName = "tenant_prd_cloud_mapping_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        String tTenantId = tRequestJsonNode.get("tenant_id").asText();
        Boolean tNameInclude = tRequestJsonNode.get("name_include").asBoolean();
        return this.processTenantCloudMappingGet(tTenantId, tNameInclude);
    }

    private Map<String, Object> processTenantCloudMappingGet(String pTenantId, Boolean pNameInclude) {
        HashMap<String, String> pCondition = new HashMap<String, String>();
        pCondition.put("tenant_id", pTenantId);
        pCondition.put("eoc_level", "cloud_mapping_id");
        List<EocIntgMapping> tMappings = this.eocIntgMappingDao.fetch(pCondition);
        Object tEocNode = null;
        Map<String, List<EocIntgMapping>> tMappingsGroupByProductUid = tMappings.stream().collect(Collectors.groupingBy(EocIntgMapping::getProductUid));
        ArrayNode prodCloudMappings = this.mapper.createArrayNode();
        tMappingsGroupByProductUid.forEach((uid, eocIntgMappings) -> {
            String productName = ((EocIntgMapping)eocIntgMappings.get(0)).getProductName();
            String productUid = uid;
            ObjectNode prodCloudMapping = this.mapper.createObjectNode();
            prodCloudMapping.put("prod_name", productName);
            prodCloudMapping.put("uid", productUid);
            ArrayNode mappings = this.mapper.createArrayNode();
            eocIntgMappings.forEach(eocIntgMapping -> {
                ObjectNode mapping = this.mapper.createObjectNode();
                mapping.put("eoc_mapping_id", eocIntgMapping.getEocId());
                mapping.put("om_mapping_id", eocIntgMapping.getIntgId());
                mapping.put("type", eocIntgMapping.getCloudMappingType());
                mappings.add((JsonNode)mapping);
            });
            prodCloudMapping.set("org_type_mapping", (JsonNode)mappings);
            prodCloudMappings.add((JsonNode)prodCloudMapping);
        });
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        tResponseJsonNode.set("prod_cloud_mapping", (JsonNode)prodCloudMappings);
        tResponseJsonNode.put("tenant_id", pTenantId);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

