/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.MdcApplicationParameter;
import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.ApiDao;
import com.digiwin.metadatacache.dao.ApiVersionDao;
import com.digiwin.metadatacache.dao.EaiTenantMappingDao;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.dao.ServiceDao;
import com.digiwin.metadatacache.enums.ApiTypeEnum;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.Api;
import com.digiwin.metadatacache.model.ApiVersion;
import com.digiwin.metadatacache.model.EaiTenantMapping;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.IamVerifyServiceUtil;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantProductListGetService
extends AbstractApiService {
    @Autowired
    private ApiDao apiDao;
    @Autowired
    private ProductDao productDao;
    @Autowired
    private ApiVersionDao apiVersionDao;
    @Autowired
    private ServiceDao serviceDao;
    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;
    @Autowired
    private EaiTenantMappingDao eaiTenantMappingDao;

    public TenantProductListGetService() {
        this.jsonSchemaFileName = "tenant_prd_list_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        String tTenantId = tRequestJsonNode.get("tenant_id").asText();
        if (tRequestJsonNode.get("api_name") != null && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("api_name").asText())) {
            String tApiName = tRequestJsonNode.get("api_name").asText();
            String parentApiName = this.getParentName(tApiName, tTenantId);
            return this.processApiImplementProductListGet(tTenantId, null == parentApiName ? tApiName : parentApiName);
        }
        String version = IamVerifyServiceUtil.getCurrentTenantVersion(tTenantId);
        return this.processProductListGet(tTenantId, version);
    }

    private Map<String, Object> processProductListGet(String pTenantId, String version) {
        ObjectNode tDataNode = this.mapper.createObjectNode();
        tDataNode.put("tenant_id", pTenantId);
        ArrayNode tGatewayArrayNode = this.mapper.createArrayNode();
        tDataNode.set("gateway", (JsonNode)tGatewayArrayNode);
        HashMap<String, String> tEaiTenantMappingCondition = new HashMap<String, String>();
        tEaiTenantMappingCondition.put("tenant", pTenantId);
        List<EaiTenantMapping> tEaiTenantMappings = this.eaiTenantMappingDao.fetch(tEaiTenantMappingCondition);
        if (!tEaiTenantMappings.isEmpty()) {
            String eaiUid = tEaiTenantMappings.get(0).getEaUid();
            HashMap<String, String> pProductCondition = new HashMap<String, String>();
            pProductCondition.put("eai_uid", eaiUid);
            List<Product> tEaiAllProductList = this.productDao.fetch(pProductCondition);
            HashMap<String, List> tProductMapGroupByProdName = new HashMap<String, List>();
            for (Product product : tEaiAllProductList) {
                List tProducts = tProductMapGroupByProdName.computeIfAbsent(product.getName(), k -> new ArrayList());
                tProducts.add(product);
            }
            ArrayList<Product> tReturnProductList = new ArrayList<Product>();
            for (String tProductType : tProductMapGroupByProdName.keySet()) {
                ArrayList<String> tExistUidList = new ArrayList<String>();
                for (Product product : (List)tProductMapGroupByProdName.get(tProductType)) {
                    if (!tExistUidList.contains(product.getUid())) {
                        tReturnProductList.add(product);
                    }
                    if (StringUtil.isEmptyOrSpace(product.getUid())) continue;
                    tExistUidList.add(product.getUid());
                }
            }
            if (!tReturnProductList.isEmpty()) {
                Map map = this.transformListToGroupMap(tReturnProductList, pTenantId);
                for (String tGatewayId : map.get(pTenantId).keySet()) {
                    ObjectNode tGatewayItemNode = this.mapper.createObjectNode();
                    tGatewayItemNode.put("gateway_id", tGatewayId);
                    tGatewayItemNode.put("eai_uid", eaiUid);
                    tGatewayArrayNode.add((JsonNode)tGatewayItemNode);
                    ArrayNode tProductArrayNode = this.mapper.createArrayNode();
                    for (String tProductName : map.get(pTenantId).get(tGatewayId).keySet()) {
                        for (Product tProduct : map.get(pTenantId).get(tGatewayId).get(tProductName)) {
                            List<EocIntgMapping> tEocIntgMappings;
                            HashMap<String, String> tEocIntgMappingCondition;
                            ObjectNode tProductItemNode = this.mapper.createObjectNode();
                            tProductItemNode.put("name", tProduct.getName());
                            tProductItemNode.put("version", tProduct.getVersion());
                            tProductItemNode.put("ip", tProduct.getIp());
                            tProductItemNode.put("id", tProduct.getApid());
                            tProductItemNode.put("uid", tProduct.getUid());
                            boolean tOmEnable = false;
                            if ("v1".equalsIgnoreCase(version)) {
                                tEocIntgMappingCondition = new HashMap<String, String>();
                                tEocIntgMappingCondition.put("prod_name", tProduct.getName());
                                tEocIntgMappingCondition.put("product_uid", tProduct.getUid());
                                tEocIntgMappingCondition.put("tenant_id", pTenantId);
                                tEocIntgMappings = this.eocIntgMappingDao.fetch(tEocIntgMappingCondition);
                                if (tEocIntgMappings != null && !tEocIntgMappings.isEmpty()) {
                                    for (EocIntgMapping mapping2 : tEocIntgMappings) {
                                        if (!mapping2.getEocLevel().equals("company_id") && !mapping2.getEocLevel().equals("site_id")) continue;
                                        tOmEnable = true;
                                        break;
                                    }
                                }
                            } else {
                                tEocIntgMappingCondition = new HashMap();
                                tEocIntgMappingCondition.put("prod_name", tProduct.getName());
                                tEocIntgMappingCondition.put("product_uid", tProduct.getUid());
                                tEocIntgMappingCondition.put("tenant_id", pTenantId);
                                tEocIntgMappingCondition.put("eoc_level", "cloud_mapping_id");
                                tEocIntgMappings = this.eocIntgMappingDao.fetch(tEocIntgMappingCondition);
                                if (tEocIntgMappings != null && !tEocIntgMappings.isEmpty()) {
                                    tOmEnable = tEocIntgMappings.stream().anyMatch(mapping -> mapping.getCloudMappingType().equals("company_id") || mapping.getCloudMappingType().equals("site_id"));
                                }
                            }
                            tProductItemNode.put("operation_manage_enable", tOmEnable);
                            if (MdcApplicationParameter._ERP_LIST.contains(tProduct.getName())) {
                                tProductItemNode.put("type", "ERP");
                            } else {
                                tProductItemNode.put("type", "ERPII");
                            }
                            tProductArrayNode.add((JsonNode)tProductItemNode);
                        }
                    }
                    tGatewayItemNode.set("product", (JsonNode)this.sortProductArray(tProductArrayNode));
                }
            }
        }
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, (JsonNode)tDataNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    private Map<String, Object> processApiImplementProductListGet(String pTenantId, String pApiName) {
        ApiVersion tApiLatestVersion;
        boolean judgeAgile = false;
        String tStandardKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + pTenantId;
        Map<String, String> tImplementProductMap = this.getStandardProductCatch(tStandardKey, pApiName);
        String tAgileKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + "agile" + ":" + pApiName;
        if (tImplementProductMap.isEmpty()) {
            judgeAgile = true;
            tImplementProductMap = this.getAgileProductCache(tAgileKey);
        }
        ObjectNode tDataNode = this.mapper.createObjectNode();
        tDataNode.put("tenant_id", pTenantId);
        ArrayNode tGatewayArrayNode = this.mapper.createArrayNode();
        tDataNode.set("gateway", (JsonNode)tGatewayArrayNode);
        if (!tImplementProductMap.isEmpty()) {
            this.log.info((Object)("\u547d\u4e2d\u5feb\u53d6: " + (judgeAgile ? tAgileKey : tStandardKey)));
            ArrayList<String> list = new ArrayList<String>();
            for (String tProductInfoString : tImplementProductMap.keySet()) {
                ObjectNode tGatewayItemNode = this.mapper.createObjectNode();
                tGatewayArrayNode.add((JsonNode)tGatewayItemNode);
                ArrayNode tProductArrayNode = this.mapper.createArrayNode();
                tGatewayItemNode.set("product", (JsonNode)tProductArrayNode);
                String[] tProductInfoSplitAry = tProductInfoString.split("/");
                String tProductName = tProductInfoSplitAry[0];
                String tProductUid = tProductInfoSplitAry[1];
                String tProductVersion = tProductInfoSplitAry[3];
                String tProductIp = tProductInfoSplitAry[4];
                String tProductId = tProductInfoSplitAry[5];
                String tProductGatewayId = tProductInfoSplitAry[6];
                String title = tProductName + tProductUid + tProductVersion + tProductIp + tProductId + tProductGatewayId;
                if (list.contains(title)) {
                    this.log.info((Object)("\u91cd\u590d\u6570\u636e\u5c55\u793a,\u79df\u6237Id: " + pTenantId + "api\u540d\u79f0: " + pApiName + "redis\u5185\u5bb9\u89e3\u6790: " + title));
                    continue;
                }
                list.add(title);
                tGatewayItemNode.put("gateway_id", tProductGatewayId);
                ObjectNode tProductItemNode = this.mapper.createObjectNode();
                tProductItemNode.put("name", tProductName);
                tProductItemNode.put("version", tProductVersion);
                tProductItemNode.put("ip", tProductIp);
                tProductItemNode.put("id", tProductId);
                tProductItemNode.put("uid", tProductUid);
                if (StringUtil.isEmpty(tImplementProductMap.get(tProductInfoString))) {
                    tProductItemNode.put("api_version", this.getImplementServiceVersion(pApiName, pTenantId));
                } else {
                    tProductItemNode.put("api_version", tImplementProductMap.get(tProductInfoString));
                }
                tProductArrayNode.add((JsonNode)tProductItemNode);
            }
            StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
            String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
            ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, (JsonNode)tDataNode);
            return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
        }
        Api tApi = pApiName.startsWith("uc.") ? this.apiDao.getByNameAndTenantId(pApiName, pTenantId) : this.apiDao.getByName(pApiName);
        String tLatestVer = "";
        if (null != tApi && null != (tApiLatestVersion = this.apiVersionDao.getLatestVerByApiId(tApi.getId()))) {
            tLatestVer = tApiLatestVersion.getVersion();
        }
        HashMap<String, String> pServiceCondition = new HashMap<String, String>();
        pServiceCondition.put("name", pApiName.trim());
        List<com.digiwin.metadatacache.model.Service> tServices = this.serviceDao.fetch(pServiceCondition);
        List tReturnServiceList = tServices.stream().filter(x -> x.getProduct().getProductType().equals(ApiTypeEnum.standard.toString()) && null != x.getProduct().getTenantId() && pTenantId.equals(x.getProduct().getTenantId()) || x.getProduct().getProductType().equals(ApiTypeEnum.agile.toString())).collect(Collectors.toList());
        boolean judgeType = false;
        if (CollectionUtils.isNotEmpty(tReturnServiceList)) {
            List tServiceList = tReturnServiceList.stream().filter(x -> x.getProduct().getProductType().equals(ApiTypeEnum.standard.toString())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(tServiceList)) {
                judgeType = true;
                tServiceList = tReturnServiceList.stream().filter(x -> x.getProduct().getProductType().equals(ApiTypeEnum.agile.toString())).collect(Collectors.toList());
            }
            Map tServicesMap = this.transformListToGroupMap(tServiceList, pTenantId);
            for (String tGatewayId : tServicesMap.get(pTenantId).keySet()) {
                ObjectNode tGatewayItemNode = this.mapper.createObjectNode();
                tGatewayItemNode.put("gateway_id", tGatewayId);
                tGatewayArrayNode.add((JsonNode)tGatewayItemNode);
                ArrayNode tProductArrayNode = this.mapper.createArrayNode();
                tGatewayItemNode.set("product", (JsonNode)tProductArrayNode);
                for (String tProductName : tServicesMap.get(pTenantId).get(tGatewayId).keySet()) {
                    for (com.digiwin.metadatacache.model.Service tService : tServicesMap.get(pTenantId).get(tGatewayId).get(tProductName)) {
                        ObjectNode tProductItemNode = this.mapper.createObjectNode();
                        tProductItemNode.put("name", tService.getProduct().getName());
                        tProductItemNode.put("version", tService.getProduct().getVersion());
                        tProductItemNode.put("ip", tService.getProduct().getIp());
                        tProductItemNode.put("id", tService.getProduct().getApid());
                        tProductItemNode.put("uid", tService.getProduct().getUid());
                        tProductItemNode.put("prod_type", tService.getProduct().getProductType());
                        tProductItemNode.put("eai_uid", tService.getProduct().getEaiUid());
                        tProductItemNode.put("service_name", tService.getName());
                        if (!StringUtil.isEmptyOrSpace(tService.getVersion())) {
                            tProductItemNode.put("provider_api_version", tService.getVersion());
                        } else {
                            tProductItemNode.put("provider_api_version", "");
                        }
                        if (null == tService.getVersion()) {
                            tProductItemNode.put("api_version", tLatestVer);
                        } else {
                            ApiVersion tApiVersion = null;
                            if (null != tApi) {
                                tApiVersion = this.apiVersionDao.getByApiIdAndVer(tApi.getId(), tService.getVersion());
                            }
                            if (tApiVersion == null) {
                                tProductItemNode.put("api_version", tLatestVer);
                            } else {
                                tProductItemNode.put("api_version", tService.getVersion());
                            }
                        }
                        tProductArrayNode.add((JsonNode)tProductItemNode);
                    }
                }
            }
        }
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, (JsonNode)tDataNode);
        if ("000".equals(tStateCode.getCode()) && CollectionUtils.isNotEmpty(tReturnServiceList)) {
            for (JsonNode tGatewayNode : tGatewayArrayNode) {
                this.setCache(tGatewayNode, tStandardKey, tAgileKey, judgeType);
            }
        }
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    private void setCache(JsonNode tGatewayNode, String tStandardKey, String tAgileKey, boolean judgeType) {
        ArrayNode tProductArrayNode = (ArrayNode)tGatewayNode.get("product");
        if (judgeType) {
            HashMap<String, String> tAgileProductMap = (HashMap<String, String>)this.cacheService.get(tAgileKey);
            for (JsonNode tProductNode : tProductArrayNode) {
                String tProductFullInfo = tProductNode.get("name").asText() + "/" + tProductNode.get("uid").asText() + "/" + tProductNode.get("eai_uid").asText() + "/" + tProductNode.get("version").asText() + "/" + tProductNode.get("ip").asText() + "/" + tProductNode.get("id").asText() + "/" + tGatewayNode.get("gateway_id").asText();
                String tProductKey = tProductNode.get("name").asText() + ":" + tProductNode.get("uid").asText();
                tProductFullInfo = tProductFullInfo + ":::" + tProductNode.get("provider_api_version").asText();
                if (null == tAgileProductMap) {
                    tAgileProductMap = new HashMap<String, String>();
                    tAgileProductMap.put(tProductKey, tProductFullInfo);
                    continue;
                }
                tAgileProductMap.put(tProductKey, tProductFullInfo);
            }
            this.cacheService.setSyncTimeOut(tAgileKey, tAgileProductMap, MdcApplicationParameter._TIME_OUT + (long)((int)(Math.random() * (double)MdcApplicationParameter._TIME_RANDOM)));
        } else {
            HashMap tProductServiceMapFromCache = (HashMap)this.cacheService.get(tStandardKey);
            for (JsonNode tProductNode : tProductArrayNode) {
                ArrayList<String> tNewList;
                String tProductFullInfo = tProductNode.get("name").asText() + "/" + tProductNode.get("uid").asText() + "/" + tProductNode.get("eai_uid").asText() + "/" + tProductNode.get("version").asText() + "/" + tProductNode.get("ip").asText() + "/" + tProductNode.get("id").asText() + "/" + tGatewayNode.get("gateway_id").asText();
                String tProductKey = tProductNode.get("name").asText() + ":" + tProductNode.get("uid").asText();
                ArrayList<String> tService = new ArrayList<String>();
                tService.add(tProductNode.get("service_name").asText() + "/" + tProductNode.get("provider_api_version").asText());
                tProductKey = tProductKey + ":" + tProductNode.get("eai_uid").asText();
                if (null == tProductServiceMapFromCache) {
                    tProductServiceMapFromCache = new HashMap();
                    tNewList = new ArrayList<String>();
                    tNewList.add(tProductFullInfo);
                    tNewList.addAll(tService);
                    tProductServiceMapFromCache.put(tProductKey, tNewList);
                    continue;
                }
                if (null != tProductServiceMapFromCache.get(tProductKey)) {
                    ((List)tProductServiceMapFromCache.get(tProductKey)).add(tProductNode.get("service_name").asText() + "/" + tProductNode.get("provider_api_version").asText());
                    this.cacheService.setSync(tStandardKey, tProductServiceMapFromCache);
                    continue;
                }
                if (null != tProductServiceMapFromCache.get(tProductKey)) continue;
                tNewList = new ArrayList();
                tNewList.add(tProductFullInfo);
                tNewList.addAll(tService);
                tProductServiceMapFromCache.put(tProductKey, tNewList);
                this.cacheService.setSync(tStandardKey, tProductServiceMapFromCache);
            }
            this.cacheService.setSync(tStandardKey, tProductServiceMapFromCache);
        }
    }

    private <T> Map<String, Map<String, Map<String, List<T>>>> transformListToGroupMap(List<T> pList, String pTenant) {
        HashMap<String, Map<String, Map<String, List<T>>>> tTenantMap = new HashMap<String, Map<String, Map<String, List<T>>>>();
        for (T tObject : pList) {
            Product tProduct = null;
            if (tObject instanceof Product) {
                tProduct = (Product)tObject;
            } else if (tObject instanceof com.digiwin.metadatacache.model.Service) {
                tProduct = ((com.digiwin.metadatacache.model.Service)tObject).getProduct();
            }
            if (tProduct == null) continue;
            Map tGatewayMap = tTenantMap.computeIfAbsent(pTenant, k -> new HashMap());
            Map tProductNameMap = tGatewayMap.computeIfAbsent(null == tProduct.getGatewayId() ? "null" : tProduct.getGatewayId(), k -> new HashMap());
            List tServiceList = tProductNameMap.computeIfAbsent(tProduct.getName(), k -> new ArrayList());
            tServiceList.add(tObject);
        }
        return tTenantMap;
    }

    public ArrayNode sortProductArray(ArrayNode pArrayNode) {
        ArrayList<JsonNode> erpList = new ArrayList<JsonNode>();
        ArrayList<JsonNode> erpIIList = new ArrayList<JsonNode>();
        for (JsonNode node : pArrayNode) {
            if (node.get("type").asText().equals("ERP")) {
                erpList.add(node);
                continue;
            }
            erpIIList.add(node);
        }
        Collections.sort(erpList, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = ((ObjectNode)o1).get("name").asText();
                String name2 = ((ObjectNode)o2).get("name").asText();
                return name1.compareTo(name2);
            }
        });
        Collections.sort(erpIIList, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = ((ObjectNode)o1).get("name").asText();
                String name2 = ((ObjectNode)o2).get("name").asText();
                return name1.compareTo(name2);
            }
        });
        ArrayNode sortedJsonArray = this.mapper.createArrayNode();
        for (JsonNode jsonNode : erpList) {
            sortedJsonArray.add(jsonNode);
        }
        for (JsonNode jsonNode : erpIIList) {
            sortedJsonArray.add(jsonNode);
        }
        return sortedJsonArray;
    }

    private Map<String, String> getAgileProductCache(String tAgileKey) {
        Map tProductServiceList = (Map)this.cacheService.get(tAgileKey);
        HashMap<String, String> tImplementProductMap = new HashMap<String, String>();
        if (null != tProductServiceList) {
            for (String tProductInfoKey : tProductServiceList.keySet()) {
                String[] tApiInfoSplitAry = ((String)tProductServiceList.get(tProductInfoKey)).split(":::");
                String tProductInfo = tApiInfoSplitAry[0];
                String tApiVersion = "";
                if (tApiInfoSplitAry.length == 2) {
                    tApiVersion = tApiInfoSplitAry[1];
                }
                tImplementProductMap.put(tProductInfo, tApiVersion);
            }
        }
        return tImplementProductMap;
    }

    private Map<String, String> getStandardProductCatch(String key, String pApiName) {
        Map tProductServiceMapFromCache = (Map)this.cacheService.get(key);
        HashMap<String, String> tImplementProductMap = new HashMap<String, String>();
        if (null != tProductServiceMapFromCache) {
            for (String tProductInfoKey : tProductServiceMapFromCache.keySet()) {
                List apiInfoList = (List)tProductServiceMapFromCache.get(tProductInfoKey);
                if (!CollectionUtils.isNotEmpty((Collection)apiInfoList)) continue;
                for (String tApiInfo : apiInfoList.subList(1, apiInfoList.size())) {
                    String[] tApiInfoSplitAry = tApiInfo.split("/");
                    String tApiName = tApiInfoSplitAry[0];
                    String tApiVersion = "";
                    if (tApiInfoSplitAry.length == 2) {
                        tApiVersion = tApiInfoSplitAry[1];
                    }
                    if (!pApiName.matches(tApiName)) continue;
                    tImplementProductMap.put((String)apiInfoList.get(0), tApiVersion);
                }
            }
        }
        return tImplementProductMap;
    }

    private String getImplementServiceVersion(String pApiName, String pTenantId) {
        String tKey = CacheMapTypeEnum.api_version_list.getCode() + ":" + pApiName;
        String tLatestVersion = (String)this.cacheService.get(tKey);
        if (null == tLatestVersion) {
            ApiVersion tApiLatestVersion;
            Api tApi = pApiName.startsWith("uc.") ? this.apiDao.getByNameAndTenantId(pApiName, pTenantId) : this.apiDao.getByName(pApiName);
            if (null != tApi && null != (tApiLatestVersion = this.apiVersionDao.getLatestVerByApiId(tApi.getId()))) {
                tLatestVersion = tApiLatestVersion.getVersion();
            }
            if (null != tLatestVersion) {
                this.cacheService.setSyncTimeOut(tKey, tLatestVersion, MdcApplicationParameter._TIME_OUT + (long)((int)(Math.random() * (double)MdcApplicationParameter._TIME_RANDOM)));
            }
        }
        return null == tLatestVersion ? "" : tLatestVersion;
    }
}

