/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.annotate.AppTokenVerify;
import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.apiservice.TenantProductUpdateProcessService;
import com.digiwin.metadatacache.dao.EaiTenantMappingDao;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.enums.ApiTypeEnum;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EaiTenantMapping;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.services.MdcCacheService;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@AppTokenVerify
public class TenantProductListUpdateService
extends AbstractApiService {
    @Autowired
    private ProductDao productDao;
    @Autowired
    private EaiTenantMappingDao eaiTenantMappingDao;
    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;
    @Autowired
    private MdcCacheService cacheService;
    @Autowired
    private TenantProductUpdateProcessService tenantProductUpdateProcessService;

    public TenantProductListUpdateService() {
        this.jsonSchemaFileName = "tenant_prd_list_update_schema.json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        String tKey = CacheMapTypeEnum.tenant_product_list_update_cachemap.getCode() + ":" + "ESP";
        try {
            String tEaiUid = null;
            String tAction = null;
            if (tRequestJsonNode.get("eai_uid") != null && tRequestJsonNode.get("eai_uid").asText().length() != 0) {
                tEaiUid = tRequestJsonNode.get("eai_uid").asText();
                tKey = CacheMapTypeEnum.tenant_product_list_update_cachemap.getCode() + ":" + tEaiUid;
            }
            if (tRequestJsonNode.get("action") != null && tRequestJsonNode.get("action").asText().length() != 0) {
                tAction = tRequestJsonNode.get("action").asText();
            }
            if (tAction == null || tAction.matches("Update")) {
                this.updateProductAndServiceList(tRequestJsonNode, this.requestMsg, tKey, tEaiUid);
            } else if (tAction.matches("Remove")) {
                this.removeEaiInfo(tEaiUid, tKey);
            }
        }
        finally {
            this.cacheService.unLock(tKey + "cache");
        }
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    private void removeEaiInfo(String pEaiUid, String pKey) {
        this.eaiTenantMappingDao.removeByEaiUid(pEaiUid);
        HashMap<String, String> tProductCondition = new HashMap<String, String>();
        tProductCondition.put("eai_uid", pEaiUid);
        List<Product> tProducts = this.productDao.fetch(tProductCondition);
        this.tenantProductUpdateProcessService.removeProductList(tProducts);
        this.log.info((Object)("\u522a\u6389\u5feb\u53d6\u4e2d\u7684\u6700\u65b0\u540c\u6b65\u7522\u54c1\u670d\u52d9\u8a0a\u606f\u7d00\u9304 key: " + pKey));
    }

    private void updateProductAndServiceList(JsonNode pNode, String pMessage, String pKey, String pEaiUid) throws InterruptedException {
        ArrayList<Product> tListToUpdate = new ArrayList<Product>();
        ArrayList<Product> tListToRemove = new ArrayList<Product>();
        String tGatewayId = null;
        if (pNode.get("gateway_id") != null && pNode.get("gateway_id").asText().length() != 0) {
            tGatewayId = pNode.get("gateway_id").asText();
        }
        if (!this.cacheService.lock(pKey + "cache")) {
            return;
        }
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u7522\u54c1\u670d\u52d9\u540c\u6b65\u8a0a\u606f\u8207\u5feb\u53d6\u6700\u5f8c\u4e00\u6b21\u7684\u7d00\u9304\u4e0d\u540c\uff0c\u57f7\u884c\u66f4\u65b0\u3002"));
        ArrayNode tTenantList = (ArrayNode)pNode.get("tenant");
        ArrayNode tProductAryNode = (ArrayNode)pNode.get("product");
        if (tProductAryNode.size() == 0) {
            this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u540c\u6b65\u7522\u54c1\u6e05\u55ae\u70ba\u7a7a\uff0c\u4e0d\u57f7\u884c\u66f4\u65b0(EAI UID = " + pEaiUid + ")\uff1a"));
            return;
        }
        HashMap<String, String> tProductCondition = new HashMap<String, String>();
        tProductCondition.put("eai_uid", pEaiUid);
        List<Product> tProducts = this.productDao.fetch(tProductCondition);
        for (Product product : tProducts) {
            this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]eai_uid = " + product.getEaiUid() + ", tenant_id = " + product.getTenantId() + ", name = " + product.getName() + ", uid = " + product.getUid()));
        }
        boolean b = tListToRemove.addAll(tProducts);
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u958b\u59cb\u57f7\u884c\u7522\u54c1\u66f4\u65b0(EAI UID = " + pEaiUid + ")\uff1a" + b));
        for (JsonNode tNode : tProductAryNode) {
            boolean productExist = false;
            if (!tProductAryNode.isArray()) continue;
            for (Product tProduct : tProducts) {
                if (!tProduct.getName().equals(tNode.get("name").asText()) || !tProduct.getUid().equals(tNode.get("uid").asText())) continue;
                tProduct.setVersion(tNode.get("version").asText());
                tProduct.setIp(tNode.get("ip").asText());
                tProduct.setApid(tNode.get("id").asText());
                if (tNode.get("url") != null) {
                    tProduct.setUrl(tNode.get("url").asText());
                }
                if (!StringUtil.isEmptyOrSpace(tNode.get("setting_eoc_flag"))) {
                    tProduct.setSettingEocFlag(tNode.get("setting_eoc_flag").asInt());
                }
                if (!StringUtil.isEmptyOrSpace(tNode.get("appid"))) {
                    tProduct.setAppId(tNode.get("appid").asText());
                }
                tProduct.setGatewayId(tGatewayId);
                tProduct.setLastUpdateTime(Calendar.getInstance());
                productExist = true;
                tListToUpdate.add(tProduct);
                tListToRemove.remove(tProduct);
            }
            if (productExist) continue;
            Product tProduct = new Product();
            tProduct.setIp(tNode.get("ip").asText());
            tProduct.setApid(tNode.get("id").asText());
            tProduct.setUid(tNode.get("uid").asText());
            tProduct.setGatewayId(tGatewayId);
            tProduct.setName(tNode.get("name").asText());
            tProduct.setVersion(tNode.get("version").asText());
            if (tNode.get("url") != null) {
                tProduct.setUrl(tNode.get("url").asText());
            }
            if (!StringUtil.isEmptyOrSpace(tNode.get("setting_eoc_flag"))) {
                tProduct.setSettingEocFlag(tNode.get("setting_eoc_flag").asInt());
            }
            if (!StringUtil.isEmptyOrSpace(tNode.get("appid"))) {
                tProduct.setAppId(tNode.get("appid").asText());
            }
            tProduct.setBuildTime(Calendar.getInstance());
            tProduct.setEaiUid(pEaiUid);
            if (pEaiUid == null) {
                tProduct.setProductType(ApiTypeEnum.agile.toString());
            } else {
                tProduct.setProductType(ApiTypeEnum.standard.toString());
            }
            tListToUpdate.add(tProduct);
        }
        this.tenantProductUpdateProcessService.removeProductList(tListToRemove);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)pEaiUid)) {
            HashMap<String, String> tConditionMap = new HashMap<String, String>();
            tConditionMap.put("eai_uid", pEaiUid);
            List<EaiTenantMapping> eaiTenantMappings = this.eaiTenantMappingDao.fetch(tConditionMap);
            for (EaiTenantMapping tenantMapping : eaiTenantMappings) {
                arrayList.add(tenantMapping.getTenantId());
            }
        }
        this.productDao.updateList(arrayList, tListToUpdate);
        this.updateServiceList(tProductAryNode, tListToUpdate);
        if (pEaiUid != null && pEaiUid.length() != 0) {
            ArrayList<String> tUpdateTenantIdList = new ArrayList<String>();
            this.eaiTenantMappingDao.removeByEaiUid(pEaiUid);
            for (JsonNode tNode : tTenantList) {
                tUpdateTenantIdList.add(tNode.textValue());
                EaiTenantMapping tEaiTenantMapping = new EaiTenantMapping();
                tEaiTenantMapping.setTenantId(tNode.textValue());
                tEaiTenantMapping.setEaUid(pEaiUid);
                tEaiTenantMapping.setBuildTime(Calendar.getInstance());
                this.eaiTenantMappingDao.save(tEaiTenantMapping);
            }
            List tTenantIdDifferenceList = (List)CollectionUtils.disjunction(arrayList, tUpdateTenantIdList);
            for (String tenantId : tTenantIdDifferenceList) {
                String tKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + tenantId;
                this.cacheService.remove(tKey);
                this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u79df\u6236\u7684\u6574\u500b\u7522\u54c1\u6e05\u55ae)\uff1akey = " + tKey));
                this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u79df\u6236\u7684\u6574\u500b\u7522\u54c1\u6e05\u55ae)\uff1atenant = " + tenantId));
                if (!arrayList.contains(tenantId)) continue;
                this.eocIntgMappingDao.deleteMappingByTenantId(tenantId);
                HashMap<String, String> tCondition = new HashMap<String, String>();
                tCondition.put("tenant", tenantId);
                List<Product> tProductList = this.productDao.fetch(tCondition);
                if (tProductList == null || tProductList.size() == 0) continue;
                for (Product tProduct : tProductList) {
                    tProduct.setTenantId("");
                    this.productDao.save(tProduct);
                }
            }
        }
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u5b8c\u6210\u7522\u54c1\u670d\u52d9\u66f4\u65b0(EAI UID = " + pEaiUid + ")"));
    }

    private void updateServiceList(ArrayNode pProductAryNode, List<Product> pListToUpdate) {
        if (pProductAryNode.isArray()) {
            this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u958b\u59cb\u57f7\u884c\u670d\u52d9\u66f4\u65b0\uff1a"));
            for (JsonNode tProductNode : pProductAryNode) {
                this.tenantProductUpdateProcessService.updateProductService(tProductNode, pListToUpdate);
            }
        }
    }
}

