/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.enums.ApiTypeEnum;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.enums.EocLevelEnum;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.EocInfoServiceUtil;
import com.digiwin.metadatacache.util.IamVerifyServiceUtil;
import com.digiwin.metadatacache.util.IntgInfoServiceUtil;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantProductOperationListGetService
extends AbstractApiService {
    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;
    @Autowired
    private ProductDao productDao;

    public TenantProductOperationListGetService() {
        this.jsonSchemaFileName = "tenant_prd_operation_list_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        String tTenantId = tRequestJsonNode.get("tenant_id").asText();
        String tUid = null;
        String tId = null;
        if (tRequestJsonNode.get("uid") != null && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("uid").asText())) {
            tUid = tRequestJsonNode.get("uid").asText();
        }
        if (tRequestJsonNode.get("id") != null && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("id").asText())) {
            tId = tRequestJsonNode.get("id").asText();
        }
        String version = IamVerifyServiceUtil.getCurrentTenantVersion(tTenantId);
        if (tRequestJsonNode.get("prod_name") != null && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("prod_name").asText())) {
            String tProdName = tRequestJsonNode.get("prod_name").asText();
            if ("v1".equalsIgnoreCase(version)) {
                return this.processTenantProdOperationListGet(tTenantId, tProdName, tUid, tId);
            }
            return this.processTenantProdOperationListGetV2(tTenantId, tProdName, tUid, tId);
        }
        boolean tNameInclude = false;
        if (tRequestJsonNode.get("name_include") != null) {
            tNameInclude = tRequestJsonNode.get("name_include").asBoolean();
        }
        if ("v1".equalsIgnoreCase(version)) {
            return this.processTenantOperationListGet(tTenantId, tNameInclude);
        }
        return this.processTenantOperationListGetV2(tTenantId, tNameInclude);
    }

    private Map<String, Object> processTenantOperationListGet(String pTenantId, Boolean pNameInclude) {
        HashMap<String, String> pCondition = new HashMap<String, String>();
        pCondition.put("tenant_id", pTenantId);
        List<EocIntgMapping> tMappings = this.eocIntgMappingDao.fetch(pCondition);
        ObjectNode tEocNode = null;
        if (pNameInclude.booleanValue() && tMappings.size() != 0) {
            try {
                tEocNode = EocInfoServiceUtil.getEocInfoByTenantId(pTenantId);
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        ObjectNode tEnterpriseObjectNode = this.mapper.createObjectNode();
        ArrayList<EocIntgMapping> tEnterpriseIdMappings = new ArrayList<EocIntgMapping>();
        for (EocIntgMapping eocIntgMapping : tMappings) {
            if (!eocIntgMapping.getEocLevel().equals(EocLevelEnum.enterprise_id.toString())) continue;
            tEnterpriseIdMappings.add(eocIntgMapping);
        }
        if (tEnterpriseIdMappings.size() != 0) {
            tEnterpriseObjectNode.put("eoc_enterprise_id", ((EocIntgMapping)tEnterpriseIdMappings.get(0)).getEocId());
            tEnterpriseObjectNode.put("om_enterprise_id", ((EocIntgMapping)tEnterpriseIdMappings.get(0)).getIntgId());
        } else {
            tEnterpriseObjectNode.put("eoc_enterprise_id", "");
            tEnterpriseObjectNode.put("om_enterprise_id", "");
        }
        HashMap tMappingsGroupByProductName = new HashMap();
        for (EocIntgMapping eocIntgMapping : tMappings) {
            if (tMappingsGroupByProductName.get(eocIntgMapping.getProducName()) == null) {
                ArrayList<EocIntgMapping> tProductNameMappingList = new ArrayList<EocIntgMapping>();
                tProductNameMappingList.add(eocIntgMapping);
                tMappingsGroupByProductName.put(eocIntgMapping.getProducName(), tProductNameMappingList);
                continue;
            }
            ((List)tMappingsGroupByProductName.get(eocIntgMapping.getProducName())).add(eocIntgMapping);
        }
        ArrayNode arrayNode = this.mapper.createArrayNode();
        for (String tProductName : tMappingsGroupByProductName.keySet()) {
            Object tEocFactoryObject22;
            JsonNode tIntgCompanyObject;
            Iterator tIntgCompanyAryNode;
            Object tEocDataNode;
            JsonNode tIntgInfoNode = null;
            try {
                if (pNameInclude.booleanValue()) {
                    tIntgInfoNode = IntgInfoServiceUtil.getIntgInfo(null, pTenantId, tProductName, ((EocIntgMapping)((List)tMappingsGroupByProductName.get(tProductName)).get(0)).getProductUid());
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            ArrayList<EocIntgMapping> tCompanyIdMappings = new ArrayList<EocIntgMapping>();
            ArrayList<EocIntgMapping> tSiteIdMappings = new ArrayList<EocIntgMapping>();
            ArrayList<EocIntgMapping> tRegionIdMappings = new ArrayList<EocIntgMapping>();
            for (EocIntgMapping mapping : (List)tMappingsGroupByProductName.get(tProductName)) {
                if (mapping.getEocLevel().equals(EocLevelEnum.company_id.toString())) {
                    tCompanyIdMappings.add(mapping);
                    continue;
                }
                if (mapping.getEocLevel().equals(EocLevelEnum.site_id.toString())) {
                    tSiteIdMappings.add(mapping);
                    continue;
                }
                if (!mapping.getEocLevel().equals(EocLevelEnum.region_id.toString())) continue;
                tRegionIdMappings.add(mapping);
            }
            ObjectNode tProdEocMappingObjectNode = this.mapper.createObjectNode();
            if (pNameInclude.booleanValue()) {
                HashMap<String, String> tPrdCondition = new HashMap<String, String>();
                tPrdCondition.put("name", tProductName);
                tPrdCondition.put("uid", ((EocIntgMapping)((List)tMappingsGroupByProductName.get(tProductName)).get(0)).getProductUid());
                Iterator tProducts = this.productDao.fetch(tPrdCondition);
                String tEocSetting = "";
                String tEocSettingRegion = "";
                if (tProducts != null && tProducts.size() != 0 && ((Product)tProducts.get(0)).getEocSetting() != null) {
                    tEocSetting = ((Product)tProducts.get(0)).getEocSetting();
                    tEocSettingRegion = ((Product)tProducts.get(0)).getEocSettingRegion();
                }
                tProdEocMappingObjectNode.put("eoc_setting", tEocSetting);
                tProdEocMappingObjectNode.put("eoc_setting_region", tEocSettingRegion);
            }
            tProdEocMappingObjectNode.put("prod_name", tProductName);
            tProdEocMappingObjectNode.put("uid", ((EocIntgMapping)((List)tMappingsGroupByProductName.get(tProductName)).get(0)).getProductUid());
            ArrayNode tOrgTypeCompanyArrayNode = this.mapper.createArrayNode();
            tProdEocMappingObjectNode.set("org_type_company", (JsonNode)tOrgTypeCompanyArrayNode);
            for (EocIntgMapping mapping : tCompanyIdMappings) {
                ObjectNode tCompanyLevelMappingNode = this.mapper.createObjectNode();
                tCompanyLevelMappingNode.put("eoc_company_id", mapping.getEocId());
                if (pNameInclude.booleanValue()) {
                    tEocDataNode = (ObjectNode)tEocNode.get("data");
                    ArrayNode tEocCompanyAryNode = (ArrayNode)tEocDataNode.get("companies");
                    for (Object tEocCompanyObject : tEocCompanyAryNode) {
                        if (!tEocCompanyObject.get("id").asText().equals(mapping.getEocId())) continue;
                        tCompanyLevelMappingNode.set("eoc_company_name", tEocCompanyObject.get("name"));
                    }
                    if (tIntgInfoNode != null) {
                        Object tEocCompanyObject;
                        tIntgCompanyAryNode = (ArrayNode)tIntgInfoNode.get("org_type_company");
                        tEocCompanyObject = tIntgCompanyAryNode.iterator();
                        while (tEocCompanyObject.hasNext()) {
                            tIntgCompanyObject = (JsonNode)tEocCompanyObject.next();
                            if (!mapping.getIntgId().equals(tIntgCompanyObject.get("company_no").asText())) continue;
                            tCompanyLevelMappingNode.set("om_company_name", tIntgCompanyObject.get("company_name"));
                        }
                    }
                }
                tCompanyLevelMappingNode.put("om_company_id", mapping.getIntgId());
                if (mapping.getDatakey() != null && mapping.getDatakey().length() != 0) {
                    tCompanyLevelMappingNode.put("datakey", mapping.getDatakey());
                }
                tOrgTypeCompanyArrayNode.add((JsonNode)tCompanyLevelMappingNode);
            }
            for (EocIntgMapping mapping : tSiteIdMappings) {
                ObjectNode tSiteLevelMappingNode = this.mapper.createObjectNode();
                tSiteLevelMappingNode.put("eoc_site_id", mapping.getEocId());
                if (pNameInclude.booleanValue()) {
                    tEocDataNode = (ObjectNode)tEocNode.get("data");
                    ArrayNode tEocFactoryAryNode = (ArrayNode)tEocDataNode.get("factories");
                    for (Object tEocFactoryObject22 : tEocFactoryAryNode) {
                        if (!tEocFactoryObject22.get("id").asText().equals(mapping.getEocId()) || mapping.getEocIntgMapping() == null || tEocFactoryObject22.get("companyId") == null || !mapping.getEocIntgMapping().getEocId().equals(tEocFactoryObject22.get("companyId").asText())) continue;
                        tSiteLevelMappingNode.set("eoc_site_name", tEocFactoryObject22.get("name"));
                    }
                    if (tIntgInfoNode != null) {
                        tIntgCompanyAryNode = (ArrayNode)tIntgInfoNode.get("org_type_company");
                        tEocFactoryObject22 = tIntgCompanyAryNode.iterator();
                        while (tEocFactoryObject22.hasNext()) {
                            tIntgCompanyObject = (JsonNode)tEocFactoryObject22.next();
                            if (mapping.getEocIntgMapping() == null || !mapping.getEocIntgMapping().getEocId().equals(tIntgCompanyObject.get("company_no").asText()) || tIntgCompanyObject.get("org_type_site") == null) continue;
                            for (JsonNode tIntgSiteObject : tIntgCompanyObject.get("org_type_site")) {
                                if (!mapping.getIntgId().equals(tIntgSiteObject.get("site_no").asText())) continue;
                                tSiteLevelMappingNode.set("om_site_name", tIntgSiteObject.get("site_name"));
                            }
                        }
                    }
                }
                tSiteLevelMappingNode.put("om_site_id", mapping.getIntgId());
                if (mapping.getDatakey() != null && mapping.getDatakey().length() != 0) {
                    tSiteLevelMappingNode.put("datakey", mapping.getDatakey());
                }
                if (mapping.getEocIntgMapping() == null) continue;
                for (JsonNode tCompanyNode : tOrgTypeCompanyArrayNode) {
                    if (!tCompanyNode.get("eoc_company_id").asText().equals(mapping.getEocIntgMapping().getEocId())) continue;
                    if (tCompanyNode.get("org_type_site") != null) {
                        ((ArrayNode)tCompanyNode.get("org_type_site")).add((JsonNode)tSiteLevelMappingNode);
                        continue;
                    }
                    ArrayNode tOrgTypeSiteArrayNode = this.mapper.createArrayNode();
                    ((ObjectNode)tCompanyNode).set("org_type_site", (JsonNode)tOrgTypeSiteArrayNode);
                    tOrgTypeSiteArrayNode.add((JsonNode)tSiteLevelMappingNode);
                }
            }
            ArrayNode tOrgTypeRegionArrayNode = this.mapper.createArrayNode();
            tProdEocMappingObjectNode.set("org_type_region", (JsonNode)tOrgTypeRegionArrayNode);
            for (EocIntgMapping mapping : tRegionIdMappings) {
                ObjectNode tRegionLevelMappingNode = this.mapper.createObjectNode();
                tRegionLevelMappingNode.put("eoc_region_id", mapping.getEocId());
                if (pNameInclude.booleanValue()) {
                    ArrayNode tIntgRegionAryNode;
                    ObjectNode tEocDataNode2 = (ObjectNode)tEocNode.get("data");
                    ArrayNode tEocRegionAryNode = (ArrayNode)tEocDataNode2.get("areas");
                    tEocFactoryObject22 = tEocRegionAryNode.iterator();
                    while (tEocFactoryObject22.hasNext()) {
                        JsonNode tEocRegionObject = (JsonNode)tEocFactoryObject22.next();
                        if (!tEocRegionObject.get("id").asText().equals(mapping.getEocId()) || !tEocRegionObject.get("type").asText().equals(mapping.getRegionType())) continue;
                        tRegionLevelMappingNode.set("eoc_region_name", tEocRegionObject.get("name"));
                    }
                    if (tIntgInfoNode != null && (tIntgRegionAryNode = (ArrayNode)tIntgInfoNode.get("org_type_region")) != null) {
                        for (JsonNode tIntgRegionObject : tIntgRegionAryNode) {
                            if (!mapping.getIntgId().equals(tIntgRegionObject.get("region_no").asText()) || !mapping.getRegionType().equals(tIntgRegionObject.get("region_type").asText())) continue;
                            tRegionLevelMappingNode.set("om_region_name", tIntgRegionObject.get("region_name"));
                        }
                    }
                }
                tRegionLevelMappingNode.put("om_region_id", mapping.getIntgId());
                if (mapping.getRegionType() == null) {
                    tRegionLevelMappingNode.put("region_type", "");
                } else {
                    tRegionLevelMappingNode.put("region_type", mapping.getRegionType());
                }
                if (mapping.getDatakey() != null && mapping.getDatakey().length() != 0) {
                    tRegionLevelMappingNode.put("datakey", mapping.getDatakey());
                }
                tOrgTypeRegionArrayNode.add((JsonNode)tRegionLevelMappingNode);
            }
            arrayNode.add((JsonNode)tProdEocMappingObjectNode);
        }
        StateCode stateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = this.getDescriptionByLocale(stateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(stateCode.getCode(), tDescription, null);
        tResponseJsonNode.set("org_type_enterprise", (JsonNode)tEnterpriseObjectNode);
        tResponseJsonNode.set("prod_eoc_mapping", (JsonNode)arrayNode);
        tResponseJsonNode.put("tenant_id", pTenantId);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    private Map<String, Object> processTenantOperationListGetV2(String pTenantId, Boolean pNameInclude) {
        HashMap<String, String> pCondition = new HashMap<String, String>();
        pCondition.put("tenant_id", pTenantId);
        pCondition.put("eoc_level", "cloud_mapping_id");
        List<EocIntgMapping> tMappings = this.eocIntgMappingDao.fetchGroupByEocId(pCondition);
        Map<Object, Object> tEocNode = new HashMap();
        if (pNameInclude.booleanValue() && !tMappings.isEmpty()) {
            try {
                tEocNode = EocInfoServiceUtil.getEocInfoV2MapByTenantId(pTenantId);
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        HashMap tMappingsGroupByProductName = new HashMap();
        for (EocIntgMapping eocIntgMapping : tMappings) {
            if (tMappingsGroupByProductName.get(eocIntgMapping.getProducName()) == null) {
                ArrayList<EocIntgMapping> tProductNameMappingList = new ArrayList<EocIntgMapping>();
                tProductNameMappingList.add(eocIntgMapping);
                tMappingsGroupByProductName.put(eocIntgMapping.getProducName(), tProductNameMappingList);
                continue;
            }
            ((List)tMappingsGroupByProductName.get(eocIntgMapping.getProducName())).add(eocIntgMapping);
        }
        ArrayNode tProdEocMappingAryNode = this.mapper.createArrayNode();
        for (String tProductName : tMappingsGroupByProductName.keySet()) {
            ObjectNode tProdEocMappingObjectNode = this.mapper.createObjectNode();
            if (pNameInclude.booleanValue()) {
                HashMap<String, String> tPrdCondition = new HashMap<String, String>();
                tPrdCondition.put("name", tProductName);
                tPrdCondition.put("uid", ((EocIntgMapping)((List)tMappingsGroupByProductName.get(tProductName)).get(0)).getProductUid());
                List<Product> tProducts = this.productDao.fetch(tPrdCondition);
                String tEocSetting = "";
                String tEocSettingRegion = "";
                if (tProducts != null && tProducts.size() != 0 && tProducts.get(0).getEocSetting() != null) {
                    tEocSetting = tProducts.get(0).getEocSetting();
                    tEocSettingRegion = tProducts.get(0).getEocSettingRegion();
                }
                tProdEocMappingObjectNode.put("eoc_setting", tEocSetting);
                tProdEocMappingObjectNode.put("eoc_setting_region", tEocSettingRegion);
            }
            tProdEocMappingObjectNode.put("prod_name", tProductName);
            tProdEocMappingObjectNode.put("uid", ((EocIntgMapping)((List)tMappingsGroupByProductName.get(tProductName)).get(0)).getProductUid());
            ArrayNode orgTypeMapping = this.mapper.createArrayNode();
            tProdEocMappingObjectNode.set("org_type_mapping", (JsonNode)orgTypeMapping);
            for (EocIntgMapping mapping : (List)tMappingsGroupByProductName.get(tProductName)) {
                ObjectNode orgTypeMappingNode = this.mapper.createObjectNode();
                orgTypeMappingNode.put("eoc_mapping_id", mapping.getEocId());
                if (pNameInclude.booleanValue() && tEocNode.get(mapping.getEocId()) != null) {
                    orgTypeMappingNode.put("eoc_mapping_name", (String)tEocNode.get(mapping.getEocId()));
                }
                orgTypeMapping.add((JsonNode)orgTypeMappingNode);
            }
            tProdEocMappingAryNode.add((JsonNode)tProdEocMappingObjectNode);
        }
        StateCode stateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = this.getDescriptionByLocale(stateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(stateCode.getCode(), tDescription, null);
        tResponseJsonNode.set("prod_eoc_mapping", (JsonNode)tProdEocMappingAryNode);
        tResponseJsonNode.put("tenant_id", pTenantId);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    public Map<String, Object> processTenantProdOperationListGet(String pTenantId, String pProdName, String pUid, String pId) throws Exception {
        String tDataFromCache;
        String tCacheMapKey = CacheMapTypeEnum.tenant_product_operation_cachemap.getCode() + ":" + pTenantId;
        String tKey = pProdName;
        if (pId != null) {
            tKey = tKey.concat(":").concat("id=").concat(pId);
        }
        if (pUid != null) {
            tKey = tKey.concat(":").concat("uid=").concat(pUid);
        }
        if (null != (tDataFromCache = this.cacheService.getCacheMapValue(tCacheMapKey, tKey))) {
            this.log.info((Object)("\u547d\u4e2d\u5feb\u53d6: " + tCacheMapKey + "// " + tKey));
            return this.converJsonStringToMap(tDataFromCache);
        }
        HashMap<String, String> pCondition = new HashMap<String, String>();
        pCondition.put("tenant_id", pTenantId);
        pCondition.put("prod_name", pProdName);
        if (pUid != null) {
            pCondition.put("uid", pUid);
        }
        List<EocIntgMapping> tMappings = this.eocIntgMappingDao.fetch(pCondition);
        ArrayList<EocIntgMapping> tEnterpriseIdMappings = new ArrayList<EocIntgMapping>();
        ArrayList<EocIntgMapping> tCompanyIdMappings = new ArrayList<EocIntgMapping>();
        ArrayList<EocIntgMapping> tSiteIdMappings = new ArrayList<EocIntgMapping>();
        ArrayList<EocIntgMapping> tRegionIdMappings = new ArrayList<EocIntgMapping>();
        for (EocIntgMapping mapping : tMappings) {
            if (mapping.getEocLevel().equals(EocLevelEnum.company_id.toString())) {
                tCompanyIdMappings.add(mapping);
                continue;
            }
            if (mapping.getEocLevel().equals(EocLevelEnum.site_id.toString())) {
                tSiteIdMappings.add(mapping);
                continue;
            }
            if (mapping.getEocLevel().equals(EocLevelEnum.region_id.toString())) {
                tRegionIdMappings.add(mapping);
                continue;
            }
            if (!mapping.getEocLevel().equals(EocLevelEnum.enterprise_id.toString())) continue;
            tEnterpriseIdMappings.add(mapping);
        }
        ObjectNode tEnterpriseLevelMappingNode = this.mapper.createObjectNode();
        if (!tEnterpriseIdMappings.isEmpty()) {
            EocIntgMapping mapping;
            mapping = (EocIntgMapping)tEnterpriseIdMappings.get(0);
            tEnterpriseLevelMappingNode.put("eoc_enterprise_id", mapping.getEocId());
            tEnterpriseLevelMappingNode.put("om_enterprise_id", mapping.getIntgId());
            if (mapping.getDatakey() != null && mapping.getDatakey().length() != 0) {
                tEnterpriseLevelMappingNode.put("datakey", mapping.getDatakey());
            }
        }
        ArrayNode tOrgTypeCompanyArrayNode = this.mapper.createArrayNode();
        for (EocIntgMapping eocIntgMapping : tCompanyIdMappings) {
            ObjectNode tCompanyLevelMappingNode = this.mapper.createObjectNode();
            tCompanyLevelMappingNode.put("eoc_company_id", eocIntgMapping.getEocId());
            tCompanyLevelMappingNode.put("om_company_id", eocIntgMapping.getIntgId());
            if (eocIntgMapping.getDatakey() != null && eocIntgMapping.getDatakey().length() != 0) {
                tCompanyLevelMappingNode.put("datakey", eocIntgMapping.getDatakey());
            }
            tOrgTypeCompanyArrayNode.add((JsonNode)tCompanyLevelMappingNode);
        }
        for (EocIntgMapping eocIntgMapping : tSiteIdMappings) {
            ObjectNode tSiteLevelMappingNode = this.mapper.createObjectNode();
            tSiteLevelMappingNode.put("eoc_site_id", eocIntgMapping.getEocId());
            tSiteLevelMappingNode.put("om_site_id", eocIntgMapping.getIntgId());
            if (eocIntgMapping.getDatakey() != null && eocIntgMapping.getDatakey().length() != 0) {
                tSiteLevelMappingNode.put("datakey", eocIntgMapping.getDatakey());
            }
            if (eocIntgMapping.getEocIntgMapping() == null) continue;
            for (JsonNode tCompanyNode : tOrgTypeCompanyArrayNode) {
                if (!tCompanyNode.get("eoc_company_id").asText().equals(eocIntgMapping.getEocIntgMapping().getEocId())) continue;
                if (tCompanyNode.get("org_type_site") != null) {
                    ((ArrayNode)tCompanyNode.get("org_type_site")).add((JsonNode)tSiteLevelMappingNode);
                    continue;
                }
                ArrayNode tOrgTypeSiteArrayNode = this.mapper.createArrayNode();
                ((ObjectNode)tCompanyNode).set("org_type_site", (JsonNode)tOrgTypeSiteArrayNode);
                tOrgTypeSiteArrayNode.add((JsonNode)tSiteLevelMappingNode);
            }
        }
        ArrayNode tOrgTypeRegionArrayNode = this.mapper.createArrayNode();
        for (EocIntgMapping mapping : tRegionIdMappings) {
            ObjectNode tRegionLevelMappingNode = this.mapper.createObjectNode();
            tRegionLevelMappingNode.put("eoc_region_id", mapping.getEocId());
            tRegionLevelMappingNode.put("om_region_id", mapping.getIntgId());
            if (mapping.getRegionType() == null) {
                tRegionLevelMappingNode.put("region_type", "");
            } else {
                tRegionLevelMappingNode.put("region_type", mapping.getRegionType());
            }
            if (mapping.getDatakey() != null && mapping.getDatakey().length() != 0) {
                tRegionLevelMappingNode.put("datakey", mapping.getDatakey());
            }
            tOrgTypeRegionArrayNode.add((JsonNode)tRegionLevelMappingNode);
        }
        StateCode stateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = this.getDescriptionByLocale(stateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(stateCode.getCode(), tDescription, null);
        tResponseJsonNode.set("org_type_enterprise", (JsonNode)tEnterpriseLevelMappingNode);
        tResponseJsonNode.set("org_type_company", (JsonNode)tOrgTypeCompanyArrayNode);
        tResponseJsonNode.set("org_type_region", (JsonNode)tOrgTypeRegionArrayNode);
        tResponseJsonNode.put("tenant_id", pTenantId);
        tResponseJsonNode.put("prod_name", pProdName);
        if (!tMappings.isEmpty()) {
            tResponseJsonNode.put("uid", tMappings.get(0).getProductUid());
            tResponseJsonNode.put("prod_type", ApiTypeEnum.standard.toString());
            tResponseJsonNode.put("url", "");
        } else {
            HashMap<String, String> tAgileAppCondition = new HashMap<String, String>();
            tAgileAppCondition.put("product_type", ApiTypeEnum.agile.toString());
            tAgileAppCondition.put("name", pProdName);
            if (pId != null) {
                tAgileAppCondition.put("id", pId);
            } else if (pUid != null) {
                tAgileAppCondition.put("uid", pUid);
            }
            List<Product> tAgileAppList = this.productDao.fetch(tAgileAppCondition);
            if (tAgileAppList != null && !tAgileAppList.isEmpty()) {
                tResponseJsonNode.put("uid", tAgileAppList.get(0).getUid());
                tResponseJsonNode.put("prod_type", ApiTypeEnum.agile.toString());
                tResponseJsonNode.put("url", tAgileAppList.get(0).getUrl());
            }
        }
        if (!tMappings.isEmpty()) {
            this.cacheService.setCacheMapValue(tCacheMapKey, tKey, tResponseJsonNode.toString());
        }
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    public Map<String, Object> processTenantProdOperationListGetV2(String pTenantId, String pProdName, String pUid, String pId) throws Exception {
        HashMap<String, String> pCondition = new HashMap<String, String>();
        pCondition.put("tenant_id", pTenantId);
        pCondition.put("prod_name", pProdName);
        pCondition.put("eoc_level", "cloud_mapping_id");
        if (pUid != null) {
            pCondition.put("uid", pUid);
        }
        List<EocIntgMapping> tMappings = this.eocIntgMappingDao.fetchGroupByEocId(pCondition);
        ArrayNode orgTypeMapping = this.mapper.createArrayNode();
        for (EocIntgMapping mapping : tMappings) {
            ObjectNode orgTypeMappingNode = this.mapper.createObjectNode();
            orgTypeMappingNode.put("eoc_mapping_id", mapping.getEocId());
            orgTypeMapping.add((JsonNode)orgTypeMappingNode);
        }
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        tResponseJsonNode.set("org_type_mapping", (JsonNode)orgTypeMapping);
        tResponseJsonNode.put("tenant_id", pTenantId);
        tResponseJsonNode.put("prod_name", pProdName);
        if (!tMappings.isEmpty()) {
            tResponseJsonNode.put("uid", tMappings.get(0).getProductUid());
            tResponseJsonNode.put("prod_type", ApiTypeEnum.standard.toString());
            tResponseJsonNode.put("url", "");
        } else {
            HashMap<String, String> tAgileAppCondition = new HashMap<String, String>();
            tAgileAppCondition.put("product_type", ApiTypeEnum.agile.toString());
            tAgileAppCondition.put("name", pProdName);
            if (pId != null) {
                tAgileAppCondition.put("id", pId);
            } else if (pUid != null) {
                tAgileAppCondition.put("uid", pUid);
            }
            List<Product> tAgileAppList = this.productDao.fetch(tAgileAppCondition);
            if (tAgileAppList != null && !tAgileAppList.isEmpty()) {
                tResponseJsonNode.put("uid", tAgileAppList.get(0).getUid());
                tResponseJsonNode.put("prod_type", ApiTypeEnum.agile.toString());
                tResponseJsonNode.put("url", tAgileAppList.get(0).getUrl());
            }
        }
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    public Map<String, Object> tenantProdOperationListGetV2(String pTenantId, String pProdName, String pUid, String pId) {
        HashMap<String, String> pCondition = new HashMap<String, String>();
        pCondition.put("tenant_id", pTenantId);
        pCondition.put("prod_name", pProdName);
        pCondition.put("eoc_level", "cloud_mapping_id");
        if (pUid != null) {
            pCondition.put("uid", pUid);
        }
        List<EocIntgMapping> tMappings = this.eocIntgMappingDao.fetch(pCondition);
        ArrayNode orgTypeMapping = this.mapper.createArrayNode();
        for (EocIntgMapping mapping : tMappings) {
            ObjectNode orgTypeMappingNode = this.mapper.createObjectNode();
            orgTypeMappingNode.put("eoc_mapping_id", mapping.getEocId());
            orgTypeMappingNode.put("om_mapping_id", mapping.getIntgId());
            if (mapping.getCloudMappingType().equalsIgnoreCase(EocLevelEnum.enterprise_id.toString())) {
                orgTypeMappingNode.put("type", "enterprise_id");
            } else if (mapping.getCloudMappingType().equalsIgnoreCase(EocLevelEnum.company_id.toString())) {
                orgTypeMappingNode.put("type", "company_id");
            } else if (mapping.getCloudMappingType().equalsIgnoreCase(EocLevelEnum.site_id.toString())) {
                orgTypeMappingNode.put("type", "site_id");
            } else if (mapping.getCloudMappingType().equalsIgnoreCase(EocLevelEnum.region_id.toString())) {
                orgTypeMappingNode.put("type", "region_id");
            }
            if (mapping.getDatakey() != null && !mapping.getDatakey().isEmpty()) {
                orgTypeMappingNode.put("datakey", mapping.getDatakey());
            }
            orgTypeMapping.add((JsonNode)orgTypeMappingNode);
        }
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        tResponseJsonNode.set("org_type_mapping", (JsonNode)orgTypeMapping);
        tResponseJsonNode.put("tenant_id", pTenantId);
        tResponseJsonNode.put("prod_name", pProdName);
        if (!tMappings.isEmpty()) {
            tResponseJsonNode.put("uid", tMappings.get(0).getProductUid());
            tResponseJsonNode.put("prod_type", ApiTypeEnum.standard.toString());
            tResponseJsonNode.put("url", "");
        } else {
            HashMap<String, String> tAgileAppCondition = new HashMap<String, String>();
            tAgileAppCondition.put("product_type", ApiTypeEnum.agile.toString());
            tAgileAppCondition.put("name", pProdName);
            if (pId != null) {
                tAgileAppCondition.put("id", pId);
            } else if (pUid != null) {
                tAgileAppCondition.put("uid", pUid);
            }
            List<Product> tAgileAppList = this.productDao.fetch(tAgileAppCondition);
            if (tAgileAppList != null && !tAgileAppList.isEmpty()) {
                tResponseJsonNode.put("uid", tAgileAppList.get(0).getUid());
                tResponseJsonNode.put("prod_type", ApiTypeEnum.agile.toString());
                tResponseJsonNode.put("url", tAgileAppList.get(0).getUrl());
            }
        }
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

