/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.dao.impl;

import com.digiwin.metadatacache.dao.ApiDao;
import com.digiwin.metadatacache.dao.impl.GenericDaoImpl;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.model.Api;
import com.digiwin.metadatacache.model.ApiMetadata;
import com.digiwin.metadatacache.model.ApiVersion;
import com.digiwin.metadatacache.services.MdcCacheService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="mdcTransactionManager")
public class ApiDaoImpl
extends GenericDaoImpl<Api, Long>
implements ApiDao {
    @Autowired
    protected MdcCacheService cacheService;

    public ApiDaoImpl() {
        super(Api.class);
    }

    @Override
    public Api save(final Api pApi) {
        return (Api)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Api>(){

            public Api doInHibernate(Session pSession) throws HibernateException {
                Api margedApi;
                block15: {
                    Transaction tTransaction = pSession.getTransaction();
                    margedApi = null;
                    try {
                        String tOriginalVersion = pApi.getApiVersions().get(0).getVersion();
                        Api existingApi = null;
                        String tApiName = pApi.getName();
                        existingApi = pApi.getTenantId() != null && pApi.getTenantId().length() != 0 ? ApiDaoImpl.this.getByNameAndTenantId(tApiName, pApi.getTenantId()) : ApiDaoImpl.this.getByName(tApiName);
                        if (existingApi != null) {
                            pApi.setId(existingApi.getId());
                            ArrayList toRemove = new ArrayList();
                            block2: for (ApiVersion tUpdateApiVersion : pApi.getApiVersions()) {
                                for (ApiVersion tOrgApiVersion : existingApi.getApiVersions()) {
                                    if (!tOrgApiVersion.getVersion().equals(tUpdateApiVersion.getVersion())) continue;
                                    toRemove.add(tUpdateApiVersion);
                                    continue block2;
                                }
                            }
                            pApi.getApiVersions().removeAll(toRemove);
                        }
                        pApi.setBuildTime(Calendar.getInstance());
                        margedApi = (Api)pSession.merge((Object)pApi);
                        block4: for (ApiVersion margedApiVersion : margedApi.getApiVersions()) {
                            for (ApiVersion version : pApi.getApiVersions()) {
                                if (!margedApiVersion.getVersion().equals(version.getVersion())) continue;
                                if (version.getApiMetadata() == null) continue block4;
                                ApiMetadata tApiMetadata = version.getApiMetadata();
                                tApiMetadata.setApiVersionId(margedApiVersion.getId());
                                pSession.save((Object)tApiMetadata);
                                continue block4;
                            }
                        }
                        String tKey = "";
                        ArrayList<String> tKeyList = new ArrayList<String>();
                        if (margedApi.getTenantId() == null && tOriginalVersion == null) {
                            tKey = CacheMapTypeEnum.api_metadata_cachemap.getCode() + ":" + margedApi.getName();
                        } else if (margedApi.getTenantId() == null && tOriginalVersion != null) {
                            tKey = CacheMapTypeEnum.api_metadata_cachemap.getCode() + ":" + margedApi.getName() + ":" + tOriginalVersion;
                            tKeyList.add(CacheMapTypeEnum.api_metadata_cachemap.getCode() + ":" + margedApi.getName());
                        } else if (margedApi.getTenantId() != null && tOriginalVersion == null) {
                            tKey = CacheMapTypeEnum.api_metadata_cachemap.getCode() + ":" + margedApi.getTenantId() + ":" + margedApi.getName();
                        } else if (margedApi.getTenantId() != null && tOriginalVersion != null) {
                            tKey = CacheMapTypeEnum.api_metadata_cachemap.getCode() + ":" + margedApi.getTenantId() + ":" + margedApi.getName() + ":" + tOriginalVersion;
                            tKeyList.add(CacheMapTypeEnum.api_metadata_cachemap.getCode() + ":" + margedApi.getTenantId() + ":" + margedApi.getName());
                        }
                        tKeyList.add(tKey);
                        for (String key : tKeyList) {
                            ApiDaoImpl.this.cacheService.remove(key);
                        }
                    }
                    catch (Exception e) {
                        if (tTransaction == null) break block15;
                        tTransaction.rollback();
                        throw e;
                    }
                }
                return margedApi;
            }
        });
    }

    @Override
    public List<Api> fetch(final Map<String, String> pConditions) {
        System.out.println(this.getHibernateTemplate().getSessionFactory());
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Api>>(){

            public List<Api> doInHibernate(Session session) throws HibernateException {
                Criteria tCriteria = session.createCriteria(Api.class);
                tCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
                tCriteria.setFetchMode("apiVersions", FetchMode.EAGER);
                if (pConditions.containsKey("tenant_id")) {
                    tCriteria.add((Criterion)Restrictions.eq((String)"tenantId", pConditions.get("tenant_id")));
                } else {
                    tCriteria.add(Restrictions.isNull((String)"tenantId"));
                }
                if (pConditions.containsKey("name")) {
                    tCriteria.add((Criterion)Restrictions.like((String)"name", (String)((String)pConditions.get("name")), (MatchMode)MatchMode.START));
                }
                return tCriteria.list();
            }
        });
    }

    @Override
    public Api getByName(String pName) {
        DetachedCriteria tDetachedCriteria = DetachedCriteria.forClass(Api.class);
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"name", (Object)pName));
        List tStandardApis = this.getHibernateTemplate().findByCriteria(tDetachedCriteria);
        if (tStandardApis.size() == 0) {
            return null;
        }
        return (Api)tStandardApis.get(0);
    }

    @Override
    public List<Api> getUcApi() {
        DetachedCriteria tDetachedCriteria = DetachedCriteria.forClass(Api.class);
        tDetachedCriteria.add((Criterion)Restrictions.like((String)"name", (String)"uc.", (MatchMode)MatchMode.START));
        return this.getHibernateTemplate().findByCriteria(tDetachedCriteria);
    }

    @Override
    public Boolean judgeApi(String pName, String pTenantId, Boolean judge) {
        DetachedCriteria tDetachedCriteria = DetachedCriteria.forClass(Api.class);
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"name", (Object)pName));
        if (null != pTenantId) {
            if (judge.booleanValue()) {
                Disjunction disjunction = Restrictions.disjunction();
                disjunction.add((Criterion)Restrictions.eq((String)"tenantId", (Object)pTenantId));
                disjunction.add(Restrictions.isNull((String)"tenantId"));
                tDetachedCriteria.add((Criterion)disjunction);
            } else {
                tDetachedCriteria.add((Criterion)Restrictions.eq((String)"tenantId", (Object)pTenantId));
            }
        } else {
            tDetachedCriteria.add(Restrictions.isNull((String)"tenantId"));
        }
        List apiList = this.getHibernateTemplate().findByCriteria(tDetachedCriteria);
        return CollectionUtils.isNotEmpty((Collection)apiList);
    }

    @Override
    public Api getByNameAndTenantId(String pName, String pTenantId) {
        DetachedCriteria tDetachedCriteria = DetachedCriteria.forClass(Api.class);
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"name", (Object)pName));
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"tenantId", (Object)pTenantId));
        List tStandardApis = this.getHibernateTemplate().findByCriteria(tDetachedCriteria);
        if (tStandardApis.size() == 0) {
            return null;
        }
        return (Api)tStandardApis.get(0);
    }

    @Override
    public void removeByNameAndVersionTenantId(String pName, final String pVersion, String pTenantId) {
        final Api tApi = pTenantId != null && pTenantId.length() != 0 ? this.getByNameAndTenantId(pName, pTenantId) : this.getByName(pName);
        if (tApi != null) {
            this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Api>>(){

                public List<Api> doInHibernate(Session pSession) throws HibernateException {
                    block11: {
                        Transaction tQ = null;
                        try {
                            for (ApiVersion tVersion : tApi.getApiVersions()) {
                                if (!tVersion.getVersion().equals(pVersion)) continue;
                                tQ = pSession.getTransaction();
                                Query tQueryRemoveApiMetadata = pSession.createQuery("delete ApiMetadata where api_version_id = :api_version_id");
                                tQueryRemoveApiMetadata.setParameter("api_version_id", (Object)tVersion.getId());
                                Query tQueryRemoveApiVersion = pSession.createQuery("delete ApiVersion where api_id= :api_id and version = :version");
                                tQueryRemoveApiVersion.setParameter("api_id", (Object)tApi.getId());
                                tQueryRemoveApiVersion.setParameter("version", (Object)pVersion);
                                Query tQueryRemoveApi = pSession.createQuery("delete Api where id = :id");
                                tQueryRemoveApi.setParameter("id", (Object)tApi.getId());
                                tQueryRemoveApiMetadata.executeUpdate();
                                tQueryRemoveApiVersion.executeUpdate();
                                if (tApi.getApiVersions().size() != 1) continue;
                                tQueryRemoveApi.executeUpdate();
                            }
                            String tKey = "";
                            ArrayList<String> tKeyList = new ArrayList<String>();
                            if (tApi.getTenantId() == null && pVersion == null) {
                                tKey = CacheMapTypeEnum.api_metadata_cachemap.getCode() + ":" + tApi.getName();
                            } else if (tApi.getTenantId() == null && pVersion != null) {
                                tKey = CacheMapTypeEnum.api_metadata_cachemap.getCode() + ":" + tApi.getName() + ":" + pVersion;
                                tKeyList.add(CacheMapTypeEnum.api_metadata_cachemap.getCode() + ":" + tApi.getName());
                            } else if (tApi.getTenantId() != null && pVersion == null) {
                                tKey = CacheMapTypeEnum.api_metadata_cachemap.getCode() + ":" + tApi.getTenantId() + ":" + tApi.getName();
                            } else if (tApi.getTenantId() != null && pVersion != null) {
                                tKey = CacheMapTypeEnum.api_metadata_cachemap.getCode() + ":" + tApi.getTenantId() + ":" + tApi.getName() + ":" + pVersion;
                                tKeyList.add(CacheMapTypeEnum.api_metadata_cachemap.getCode() + ":" + tApi.getTenantId() + ":" + tApi.getName());
                            }
                            tKeyList.add(tKey);
                            for (String key : tKeyList) {
                                ApiDaoImpl.this.cacheService.remove(key);
                            }
                        }
                        catch (Exception e) {
                            ApiDaoImpl.this.log.error((Object)e);
                            if (tQ == null) break block11;
                            tQ.rollback();
                        }
                    }
                    return null;
                }
            });
        }
    }
}

