/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.dao.impl;

import com.digiwin.metadatacache.dao.GenericDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.transaction.annotation.Transactional;

@Transactional(value="mdcTransactionManager")
public class GenericDaoImpl<T, PK extends Serializable>
implements GenericDao<T, PK> {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Class<T> persistentClass;
    private HibernateTemplate hibernateTemplate;
    private SessionFactory sessionFactory;

    public GenericDaoImpl(Class<T> persistentClass) {
        this.persistentClass = persistentClass;
    }

    public GenericDaoImpl(Class<T> persistentClass, @Qualifier(value="mdcLocalSessionFactoryBean") SessionFactory sessionFactory) {
        this.persistentClass = persistentClass;
        this.sessionFactory = sessionFactory;
        this.hibernateTemplate = new HibernateTemplate(sessionFactory);
    }

    public HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Autowired(required=true)
    @Required
    public void setSessionFactory(@Qualifier(value="mdcLocalSessionFactoryBean") SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.hibernateTemplate = new HibernateTemplate(sessionFactory);
    }

    @Override
    public List<T> getAll() {
        return this.hibernateTemplate.loadAll(this.persistentClass);
    }

    @Override
    public T get(PK id) {
        Object entity = this.hibernateTemplate.get(this.persistentClass, id);
        if (entity == null) {
            this.log.warn((Object)("Uh oh, '" + this.persistentClass + "' object with id '" + id + "' not found..."));
            throw new ObjectRetrievalFailureException(this.persistentClass, id);
        }
        return (T)entity;
    }

    @Override
    public boolean exists(PK id) {
        Object entity = this.hibernateTemplate.get(this.persistentClass, id);
        return entity != null;
    }

    @Override
    public T save(T object) {
        return (T)this.hibernateTemplate.merge(object);
    }

    @Override
    public void remove(PK id) {
        this.hibernateTemplate.delete(this.get(id));
    }

    @Override
    public List<T> findByExample(T pObject) {
        return this.hibernateTemplate.findByExample(pObject);
    }

    @Override
    public List<T> findByExampleLike(T pObject, Class<T> pClazz) {
        Example tExample = Example.create(pObject);
        tExample.enableLike(MatchMode.ANYWHERE);
        tExample.ignoreCase();
        DetachedCriteria tCriteria = DetachedCriteria.forClass(pClazz).add((Criterion)tExample);
        return this.hibernateTemplate.findByCriteria(tCriteria);
    }

    @Override
    public List<T> getDistinct(List<T> list) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(list);
        return new ArrayList<T>(result);
    }

    @Override
    public void saveOrupdate(T object) {
        this.hibernateTemplate.saveOrUpdate(object);
    }
}

