/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.mq;

import com.digiwin.metadatacache.MdcApplicationParameter;
import com.digiwin.metadatacache.model.MqPublishParam;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RabbitMqManager {
    protected final Log log = LogFactory.getLog(this.getClass());
    private static RabbitMqManager rabbitMQManager = null;
    private final Connection connection;

    public static RabbitMqManager getRabbitMQManager() {
        if (rabbitMQManager == null) {
            throw new RuntimeException("RabbitMQ created failed");
        }
        return rabbitMQManager;
    }

    private RabbitMqManager() throws Exception {
        if (null == MdcApplicationParameter._MQ_HOST || MdcApplicationParameter._MQ_HOST.length() == 0) {
            throw new RuntimeException("mdc rabbitmq properties config error");
        }
        ConnectionFactory factory = new ConnectionFactory();
        factory.setUsername(MdcApplicationParameter._MQ_USERNAME);
        factory.setPassword(MdcApplicationParameter._MQ_PASSWORD);
        factory.setHost(MdcApplicationParameter._MQ_HOST);
        if (!MdcApplicationParameter._MQ_VIRTUAL_HOST.isEmpty()) {
            factory.setVirtualHost(MdcApplicationParameter._MQ_VIRTUAL_HOST);
        }
        factory.setPort(Integer.parseInt(MdcApplicationParameter._MQ_PORT));
        this.connection = factory.newConnection();
        try (Channel tChannel = this.connection.createChannel();){
            tChannel.exchangeDeclare(MdcApplicationParameter._MQ_EXCHANGE_NAME, MdcApplicationParameter._MQ_EXCHANGE_TYPE, true);
            tChannel.queueDeclare(MdcApplicationParameter._MQ_QUEUE_NAME, true, false, false, null);
            tChannel.queueBind(MdcApplicationParameter._MQ_QUEUE_NAME, MdcApplicationParameter._MQ_EXCHANGE_NAME, MdcApplicationParameter._MQ_ROUTING_KEY);
        }
        catch (Exception e) {
            this.log.error((Object)"Creat queue failed.", (Throwable)e);
        }
    }

    public boolean publishMessage(MqPublishParam publishParam) {
        boolean result = false;
        if (null == publishParam.getMessage() || publishParam.getMessage().isEmpty()) {
            throw new RuntimeException("message can't be empty");
        }
        if (publishParam.getQueueName() == null || publishParam.getQueueName().isEmpty()) {
            throw new RuntimeException("queueName can't be empty");
        }
        if (publishParam.getRoutingKey() == null || publishParam.getRoutingKey().isEmpty()) {
            throw new RuntimeException("routingKey can't be empty");
        }
        try (Channel channel = this.connection.createChannel();){
            channel.confirmSelect();
            channel.basicPublish(publishParam.getExchangeName(), publishParam.getRoutingKey(), null, publishParam.getMessage().getBytes());
            channel.waitForConfirmsOrDie();
            result = true;
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    static {
        try {
            rabbitMQManager = new RabbitMqManager();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

