/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.services;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.utils.DWURIBuilder;
import com.digiwin.metadatacache.MdcApplicationParameter;
import com.digiwin.metadatacache.exception.TenantQueryProdException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CacVerifyService {
    private final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private DWHttpClient dwHttpClient;
    @Value(value="${iamApToken}")
    private String iamApToken;
    ObjectMapper mapper = new ObjectMapper();

    public List<String> getEnabledModules(String tenantId, String pUserToken) throws Exception {
        JsonNode tResponse = this.analyzeAuthorization(tenantId, pUserToken);
        ArrayList<String> ids = new ArrayList<String>();
        if (null != tResponse && tResponse.isArray()) {
            for (JsonNode jsonNode : tResponse) {
                if (null == jsonNode.get("categoryId") || !"app".equals(jsonNode.get("categoryId").asText()) || null == jsonNode.get("code") || "Athena".equals(jsonNode.get("code").asText())) continue;
                ids.add(jsonNode.get("code").asText());
            }
        }
        this.log.info((Object)("\u8bf7\u6c42cac\u83b7\u53d6\u5bf9\u5e94\u7684\u4ea7\u54c1appId" + ids));
        return ids;
    }

    private JsonNode analyzeAuthorization(String tenantId, String pUserToken) throws Exception {
        try {
            URI tUri = DWURIBuilder.create((String)(MdcApplicationParameter._CAC_HOST + String.format("/api/cac/v4/authorizations/tenants/%s", tenantId))).build();
            HttpGet tGet = new HttpGet(tUri);
            tGet.setHeader("Content-Type", "application/json;charset=UTF-8");
            tGet.setHeader("digi-middleware-auth-user", pUserToken);
            tGet.setHeader("digi-middleware-auth-app", this.iamApToken);
            tGet.setHeader("token", pUserToken);
            if (null != DWServiceContext.getContext().getRequestHeader().get("routerKey")) {
                tGet.setHeader("routerKey", DWServiceContext.getContext().getRequestHeader().get("routerKey").toString());
            }
            String tResponse = (String)this.dwHttpClient.execute((HttpUriRequest)tGet, String.class, new DWRequestOption(false));
            return this.mapper.readTree(tResponse);
        }
        catch (Exception e) {
            throw new TenantQueryProdException(this.getClass());
        }
    }
}

