/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.services;

import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.services.RedissonService;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.redisson.api.RTopic;
import org.springframework.stereotype.Service;

@Service
public class LocalCacheService {
    private static final Log log = LogFactory.getLog(LocalCacheService.class);
    private static final Object lock = new Object();
    private static final String CLEAR_ALL_MSG = "[clear_all]";
    private static final String CURRENT_CLIENT_ID = UUID.randomUUID().toString().replaceAll("-", "");
    private static final String CHANGE_MSG_SLIPTOR = "|||";
    private Map<String, Cache> CACHE_CONTEXT = new HashMap<String, Cache>();
    private Map<String, RTopic> TOPIC_CONTEXT = new HashMap<String, RTopic>();
    private final RedissonService redissonService;

    public LocalCacheService(RedissonService redissonService) {
        this.redissonService = redissonService;
    }

    public <T extends Serializable> void putToL2Cache(CacheMapTypeEnum pCacheKeyEnum, String pKey, T val) {
        try {
            Cache<String, T> cache = this.getCache(pCacheKeyEnum);
            cache.put((Object)pKey, val);
            this.publishChange(pCacheKeyEnum, pKey);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public <T extends Serializable> void putToL2Cache(CacheMapTypeEnum pCacheKeyEnum, String firstKey, String secondKey, T val) {
        try {
            Cache<String, T> cache = this.getCache(pCacheKeyEnum);
            Map cacheMap = (Map)cache.get((Object)firstKey, one -> new ConcurrentHashMap());
            cacheMap.put(secondKey, val);
            cache.put((Object)firstKey, (Object)cacheMap);
            this.publishChange(pCacheKeyEnum, firstKey, secondKey);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public <T extends Serializable> T getFromL2Cache(CacheMapTypeEnum pCacheKeyEnum, String pKey) {
        try {
            Cache<String, T> cache = this.getCache(pCacheKeyEnum);
            return (T)((Serializable)cache.get((Object)pKey, key -> null));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <T extends Serializable> T getFromL2Cache(CacheMapTypeEnum pCacheKeyEnum, String firstKey, String secondKey) {
        try {
            Cache<String, T> cache = this.getCache(pCacheKeyEnum);
            Map cacheMap = (Map)cache.get((Object)firstKey, one -> null);
            return (T)(null == cacheMap ? null : (Serializable)cacheMap.get(secondKey));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void remove(CacheMapTypeEnum pCacheKeyEnum, String pKey) {
        this.getCache(pCacheKeyEnum).invalidate((Object)pKey);
        this.publishChange(pCacheKeyEnum, pKey);
    }

    private void publishChange(CacheMapTypeEnum pCacheKeyEnum, String key) {
        try {
            this.TOPIC_CONTEXT.get(pCacheKeyEnum.getCode()).publish((Object)(CURRENT_CLIENT_ID + CHANGE_MSG_SLIPTOR + key));
        }
        catch (Exception e) {
            log.error((Object)"publish modify err", (Throwable)e);
        }
    }

    private void publishChange(CacheMapTypeEnum pCacheKeyEnum, String firstKey, String secondKey) {
        try {
            this.TOPIC_CONTEXT.get(pCacheKeyEnum.getCode()).publish((Object)(CURRENT_CLIENT_ID + CHANGE_MSG_SLIPTOR + firstKey + CHANGE_MSG_SLIPTOR + secondKey));
        }
        catch (Exception e) {
            log.error((Object)"publish modify err", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Cache<String, T> getCache(CacheMapTypeEnum cacheKeyEnum) {
        String namespace = cacheKeyEnum.getCode();
        Cache cache = this.CACHE_CONTEXT.get(namespace);
        if (null == cache) {
            Object object = lock;
            synchronized (object) {
                cache = this.CACHE_CONTEXT.get(namespace);
                if (cache == null) {
                    cache = Caffeine.newBuilder().maximumSize(2000L).expireAfterWrite(12L, TimeUnit.HOURS).build();
                    this.CACHE_CONTEXT.put(namespace, cache);
                    RTopic topic = this.redissonService.getClient().getTopic(namespace + ":change");
                    this.TOPIC_CONTEXT.put(namespace, topic);
                    topic.addListener(String.class, (channel, msg) -> {
                        String[] msgInfo = StringUtils.split((String)msg, (String)CHANGE_MSG_SLIPTOR);
                        if (!CURRENT_CLIENT_ID.equals(msgInfo[0])) {
                            Cache firstCache;
                            Map cacheMap;
                            if (CLEAR_ALL_MSG.equals(msgInfo[1])) {
                                this.CACHE_CONTEXT.get(namespace).invalidateAll();
                            } else if (msgInfo.length == 2) {
                                this.CACHE_CONTEXT.get(namespace).invalidate((Object)msgInfo[1]);
                            } else if (msgInfo.length > 2 && null != (cacheMap = (Map)(firstCache = this.CACHE_CONTEXT.get(namespace)).get((Object)msgInfo[1], k -> null))) {
                                cacheMap.remove(msgInfo[2]);
                            }
                        }
                    });
                }
            }
        }
        return cache;
    }
}

