/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.services;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWHttpResponseEntity;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.http.client.utils.DWURIBuilder;
import com.digiwin.metadatacache.bo.KgServiceProductConfigDto;
import com.digiwin.metadatacache.exception.KgFailException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MdcKgService {
    private static final Log log = LogFactory.getLog(MdcKgService.class);
    @Value(value="${iamApToken}")
    private String iamApToken;
    @Autowired
    private DWHttpClient dwHttpClient;

    public KgServiceProductConfigDto getServiceProductConfig(String tenantId, String serviceName) throws KgFailException {
        try {
            URI uri = DWURIBuilder.createServiceRouteDapAPI((String)"thememap", (String)"/knowledgegraph/tenant/systemTenantServiceConfig").setParameter("tenantId", tenantId).setParameter("serviceName", serviceName).build();
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("digi-middleware-auth-app", this.iamApToken);
            httpGet.setHeader("token", (String)DWServiceContext.getContext().getRequestHeader().get("token"));
            if (null != DWServiceContext.getContext().getRequestHeader().get("routerKey")) {
                httpGet.setHeader("routerKey", (String)DWServiceContext.getContext().getRequestHeader().get("routerKey"));
            }
            if (null != DWServiceContext.getContext().getRequestHeader().get("security-token")) {
                httpGet.setHeader("security-token", (String)DWServiceContext.getContext().getRequestHeader().get("security-token"));
            }
            DWHttpResponseEntity tDWHttpResponse = this.dwHttpClient.executeAndGetDWHttpResponseEntity((HttpUriRequest)httpGet, KgServiceProductConfigDto.class, new DWRequestOption(false));
            return (KgServiceProductConfigDto)tDWHttpResponse.getResult();
        }
        catch (DWHttpFailedException e) {
            log.error(e.getEntity(String.class));
            throw new KgFailException(e, this.getClass());
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new KgFailException(e, this.getClass());
        }
    }
}

