package com.digiwin.metadatacache.apiservice;

import java.util.Map;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import org.springframework.beans.factory.annotation.Autowired;

import com.digiwin.metadatacache.dao.ApiDao;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.Api;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * 查询API提供者信息
 * API provider Path:[/restful/standard/mdc/ApiProvider/Get]
 */
@org.springframework.stereotype.Service
public class ApiProviderGetService extends AbstractApiService {

	@Autowired
	private ApiDao apiDao;

	public ApiProviderGetService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.API_PROVIDER_GET_SCHEMA;
	}

	/**
	 * 查询API提供者信息
	 * @param validatorResult      * @param validatorResult
	 * @return Map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
				+ ", 原始訊息: " + tRequestJsonNode);
		// 取出入參api_name
		String tApiName = tRequestJsonNode.get(MdcConstant.API_NAME).asText();
		return processApiProviderGet(tApiName);
	}

	private Map<String, Object> processApiProviderGet(String pApiName) {
		ObjectNode tDataNode = mapper.createObjectNode();
		tDataNode.put(MdcConstant.API_NAME, pApiName);
		ArrayNode tProviderArrayNode = mapper.createArrayNode();
		tDataNode.set(MdcConstant.PROVIDER, tProviderArrayNode);
		Api tApi = apiDao.getByName(pApiName);
		if (tApi != null) {
			String[] tProvidersSplitAry = null;
			String tProviders = tApi.getProvider();
			if (!StringUtil.isEmptyOrSpace(tProviders)) {
				tProvidersSplitAry = tProviders.split(",");
			}
			if (tProvidersSplitAry != null && tProvidersSplitAry.length != 0) {
				for (String tProvider : tProvidersSplitAry) {
					tProviderArrayNode.add(tProvider);
				}
			}
		}
		StateCode tStateCode = getStateCode(ValidateStateEnum.SUCCESS.getCode());
		String tDescription = getDescriptionByLocale(tStateCode, locale);
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, tDataNode);
		return converJsonNodeToMap(tResponseJsonNode);
	}

}
