package com.digiwin.metadatacache.apiservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.digiwin.metadatacache.dao.AppSupportVersionDao;
import com.digiwin.metadatacache.exception.AppVerNotFoundException;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.AppSupportVersion;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 *  取得租戶穩態產品支持的應用版本
 *  Path:[/restful/standard/mdc/AppSupportList/Get]
 */
@Service
public class AppSupportListGetService extends AbstractApiService {
	
	@Autowired
	private AppSupportVersionDao appSupportVersionDao;
	
	public AppSupportListGetService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.APP_SUPPORT_LIST_GET_SCHEMA;
	}

	/**
	 * 查询提供版本信息
	 * @param validatorResult      * @param validatorResult
	 * @return Map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
				+ ", 原始訊息: " + tRequestJsonNode);
		String tTenantId = tRequestJsonNode.get(MdcConstant.TENANT_ID).asText();
		String tAppId = null;
		if(tRequestJsonNode.get(MdcConstant.APP_ID) != null){
			tAppId = tRequestJsonNode.get(MdcConstant.APP_ID).asText();
		}
		Map<String, String> tConditions = new HashMap<>();
		tConditions.put(MdcConstant.TENANT_ID, tTenantId);
		if(tAppId != null){
			tConditions.put(MdcConstant.APP_ID, tAppId);
		}
		List<AppSupportVersion> tAppSupportVersionList = appSupportVersionDao.fetch(tConditions);
		// 未找到支持的應用版本
		if (tAppSupportVersionList == null || tAppSupportVersionList.isEmpty()) {
			throw new AppVerNotFoundException(getClass());
		}
		// 組成回傳訊息
		// 建立data節點
		ObjectNode tDataNode = mapper.createObjectNode();
		// 紀錄Tenant ID
		tDataNode.put(MdcConstant.TENANT_ID, tTenantId);
		// 建立應用、版本陣列
		ArrayNode tVersionAryNode = mapper.createArrayNode();
		for (AppSupportVersion tAppSupportVersion : tAppSupportVersionList) {
			ObjectNode tAppVerNode = mapper.createObjectNode();
			tAppVerNode.put(MdcConstant.APP_ID, tAppSupportVersion.getAppId().trim());
			tAppVerNode.put(MdcConstant.VERSION, tAppSupportVersion.getAppVersion().trim());
			tVersionAryNode.add(tAppVerNode);
		}
		tDataNode.set(MdcConstant.APP_VER, tVersionAryNode);
		StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
		String tDescription = getDescriptionByLocale(tStateCode, locale);
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, tDataNode);
		return converJsonNodeToMap(tResponseJsonNode);
	}
}
