package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.constant.AssetConstant;
import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.dao.AssetIndustryWordDictionaryDao;
import com.digiwin.metadatacache.model.IndustryWordResponse;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 获取行业辞汇清单
 * Path:[/restful/standard/mdc/AssetIndustryVocabularyList/Get]
 */
@Service
public class AssetIndustryVocabularyListGetService extends AbstractApiService {

    @Autowired
    private AssetIndustryWordDictionaryDao assetIndustryWordDictionaryDao;


    public AssetIndustryVocabularyListGetService() {
        super();
        jsonSchemaFileName = JsonSchemaFileConstant.ASSET_INDUSTRY_VOCABULARY_LIST_GET_SCHEMA;
    }

    /**
     * 查询API
     * 入参 辞汇编号、辞汇名称、行业术语
     * @param validatorResult validatorResult
     * @return Map
     * @throws BaseException BaseException
     * @throws Exception     Exception
     */
    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        String standardWordNo = null;
        if (null != tRequestJsonNode.get(AssetConstant.STANDARD_WORD_NO)
             && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get(AssetConstant.STANDARD_WORD_NO).asText())) {
            standardWordNo = tRequestJsonNode.get(AssetConstant.STANDARD_WORD_NO).asText();
        }
        String standardWordName = null;
        if (null != tRequestJsonNode.get(AssetConstant.STANDARD_WORD_NAME)
                && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get(AssetConstant.STANDARD_WORD_NAME).asText())) {
            standardWordName = tRequestJsonNode.get(AssetConstant.STANDARD_WORD_NAME).asText();
        }
        String industryTerm = null;
        if (null != tRequestJsonNode.get(AssetConstant.INDUSTRY_TERM)
                && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get(AssetConstant.INDUSTRY_TERM).asText())) {
            industryTerm = tRequestJsonNode.get(AssetConstant.INDUSTRY_TERM).asText();
        }
        List<IndustryWordResponse> industryWordResponseList = assetIndustryWordDictionaryDao.queryByInfo(standardWordNo, standardWordName, industryTerm);
        ObjectNode tDataNode = mapper.createObjectNode();
        ArrayNode jsonNode = mapper.createArrayNode();
        if (CollectionUtils.isNotEmpty(industryWordResponseList)) {
            for (IndustryWordResponse industryWordResponse : industryWordResponseList) {
                ObjectNode wordNode = mapper.createObjectNode();
                wordNode.put(MdcConstant.DATA_NAME, industryWordResponse.getDataName());
                wordNode.put(MdcConstant.DESCRIPTION_ZH_CN, industryWordResponse.getDescriptionZhCn());
                wordNode.put(MdcConstant.INDUSTRY_NO, industryWordResponse.getIndustryNo());
                wordNode.put(MdcConstant.INDUSTRY_NAME, industryWordResponse.getIndustryName());
                wordNode.put(MdcConstant.INDUSTRY_TERM_ZH_CN, industryWordResponse.getIndustryTermZhCn());
                wordNode.put(MdcConstant.DATA_TYPE, industryWordResponse.getDataType());
                wordNode.put(MdcConstant.SIZE, industryWordResponse.getSize());
                wordNode.put(MdcConstant.FIELD_PRECISION, industryWordResponse.getFieldPrecision());
                jsonNode.add(wordNode);
            }
        }
        tDataNode.set(MdcConstant.DATA, jsonNode);
        StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
        String tDescription = getDescriptionByLocale(tStateCode, locale);
        ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, tDataNode);
        return converJsonNodeToMap(tResponseJsonNode);
    }
}
