package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.constant.AssetConstant;
import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.services.ElasticsearchService;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 获取资产清单
 * Path:[/restful/standard/mdc/AssetList/Get]
 */
@Service
public class AssetListGetService extends AbstractApiService {

    @Autowired
    private ElasticsearchService elasticsearchService;

    public AssetListGetService() {
        super();
        jsonSchemaFileName = JsonSchemaFileConstant.ASSET_LIST_GET_SCHEMA;
    }

    /**
     * 获取资产清单 -ES
     *
     * @param validatorResult * @param validatorResult
     * @return Map<String, Object>
     * @throws BaseException BaseException
     * @throws Exception     Exception
     */
    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        Map<String, String> mapCondition = new HashMap<>();
        mapCondition.put(AssetConstant.FROM, "0");
        mapCondition.put(AssetConstant.SIZE, "50");
        if (null != tRequestJsonNode.get(AssetConstant.FROM)
                && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get(AssetConstant.FROM).asText())) {
            mapCondition.put(AssetConstant.FROM, tRequestJsonNode.get(AssetConstant.FROM).asText());
        }
        if (null != tRequestJsonNode.get(AssetConstant.SIZE)
                && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get(AssetConstant.SIZE).asText())) {
            mapCondition.put(AssetConstant.SIZE, tRequestJsonNode.get(AssetConstant.SIZE).asText());
        }
        if (null != tRequestJsonNode.get(AssetConstant.PROPERTY_SOURCE)
                && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get(AssetConstant.PROPERTY_SOURCE).asText())) {
            mapCondition.put(AssetConstant.PROPERTY_SOURCE, tRequestJsonNode.get(AssetConstant.PROPERTY_SOURCE).asText());
        }
        if (null != tRequestJsonNode.get(AssetConstant.OWNER_PRODUCT)
                && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get(AssetConstant.OWNER_PRODUCT).asText())) {
            mapCondition.put(AssetConstant.OWNER_PRODUCT, tRequestJsonNode.get(AssetConstant.OWNER_PRODUCT).asText());
        }
        if (null != tRequestJsonNode.get(AssetConstant.PROPERTY_TYPE)
                && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get(AssetConstant.PROPERTY_TYPE).asText())) {
            mapCondition.put(AssetConstant.PROPERTY_TYPE, tRequestJsonNode.get(AssetConstant.PROPERTY_TYPE).asText());
        }
        if (null != tRequestJsonNode.get(AssetConstant.CODE)
                && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get(AssetConstant.CODE).asText())) {
            mapCondition.put(AssetConstant.CODE, tRequestJsonNode.get(AssetConstant.CODE).asText());
        }
        if (null != tRequestJsonNode.get(AssetConstant.NAME)
                && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get(AssetConstant.NAME).asText())) {
            mapCondition.put(AssetConstant.NAME, tRequestJsonNode.get(AssetConstant.NAME).asText());
        }
        if (null != tRequestJsonNode.get(AssetConstant.PROPERTY_CONTENT)
                && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get(AssetConstant.PROPERTY_CONTENT).asText())) {
            mapCondition.put(AssetConstant.CONTENT, tRequestJsonNode.get(AssetConstant.PROPERTY_CONTENT).asText());
        }
        if (null != tRequestJsonNode.get(AssetConstant.PROPERTY_COMMENT)
                && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get(AssetConstant.PROPERTY_COMMENT).asText())) {
            mapCondition.put(AssetConstant.PROPERTY_COMMENT, tRequestJsonNode.get(AssetConstant.PROPERTY_COMMENT).asText());
        }
        ObjectNode objectNode = elasticsearchService.searchAssetDataDoc(mapCondition);
        StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
        String tDescription = getDescriptionByLocale(tStateCode, locale);
        ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, objectNode);
        return converJsonNodeToMap(tResponseJsonNode);
    }
}
