package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.enums.EocLevelEnum;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.EocInfoServiceUtil;
import com.digiwin.metadatacache.util.IntgInfoServiceUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 云地映射场域列表查询
 * Path:[/restful/standard/mdc/CloudRegionMapping/Get]
 */
@org.springframework.stereotype.Service
public class CloudRegionMappingGetService extends AbstractApiService {

	@Autowired
	private ProductDao productDao;

	@Autowired
	private EocIntgMappingDao eocIntgMappingDao;


	public CloudRegionMappingGetService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.CLOUD_REGION_GET_SCHEMA;
	}

	/**
	 * 云地映射场域列表查询
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
				+ ", 原始訊息: " + tRequestJsonNode);

		// 取出入參tenant, api_name
		String tTenantId = tRequestJsonNode.get(MdcConstant.TENANT_ID).asText();

		// 如果有註明需要"敘述" "name_include": true 則先取EOC運營單元碼清單
		boolean tNameInclude = false;
		if (tRequestJsonNode.get(MdcConstant.NAME_INCLUDE) != null) {
			tNameInclude = tRequestJsonNode.get(MdcConstant.NAME_INCLUDE).asBoolean();
		}
		return processTenantOperationListGetV2(tTenantId, tNameInclude);
	}


	/**
	 * 取得租戶所有產品的運營清單(蔣穎EOC配置畫面呼叫) v2版本
	 */
	private Map<String, Object> processTenantOperationListGetV2(String pTenantId, Boolean pNameInclude) {
		//根據入參tenant_id、eocLevel取得eoc_intg_mapping v2 資料
		Map<String, String> pCondition = new HashMap<>();
		pCondition.put(MdcConstant.TENANT_ID, pTenantId);
		pCondition.put(MdcConstant.EOC_LEVEL, MdcConstant.CLOUD_MAPPING_ID);
		List<EocIntgMapping> tMappings = eocIntgMappingDao.fetch(pCondition);

		//ObjectNode tEocNode = null;
		Map<String, String> tEocNode = new HashMap<>();
		// NameInclude=true，代表回傳訊息中要包含運營單元的描述(name)，須向EOC取得
		// 若該租戶還未配置運營，則不用取得token呼叫EOC
		if (pNameInclude && !tMappings.isEmpty()) {
			try {
				// 根據租戶ID取得EOC運營單元碼 v2版本接口
				tEocNode = EocInfoServiceUtil.getEocInfoV2MapByTenantId(pTenantId);
				// 取得eoc清單時發生任何錯誤都繼續執行，因為取得name值(敘述)是額外的資訊
				// 不要因為取得name值(敘述)失敗，而影響取得運營大表
			} catch (Exception e) {
				log.error(e.getMessage(), e);
			}
		}
		// 組成org_type_enterprise物件
		ObjectNode tEnterpriseObjectNode = mapper.createObjectNode();
		List<EocIntgMapping> tEnterpriseIdMappings = new ArrayList<>();
		/* 取出enterprise_id層級的mapping */
		for (EocIntgMapping mapping : tMappings) {
			//v2 集团级别
			if (mapping.getCloudMappingType().equals(EocLevelEnum.enterprise_id.toString())) {
				tEnterpriseIdMappings.add(mapping);
			}
		}
		if (!tEnterpriseIdMappings.isEmpty()) {
			tEnterpriseObjectNode.put(MdcConstant.EOC_ENTERPRISE_ID, tEnterpriseIdMappings.get(0).getEocId());
			tEnterpriseObjectNode.put(MdcConstant.OM_ENTERPRISE_ID, tEnterpriseIdMappings.get(0).getIntgId());
		} else {
			tEnterpriseObjectNode.put(MdcConstant.EOC_ENTERPRISE_ID, "");
			tEnterpriseObjectNode.put(MdcConstant.OM_ENTERPRISE_ID, "");
		}
		// 將tMappings依照產品名稱分出來
		Map<String, List<EocIntgMapping>> tMappingsGroupByProductName = new HashMap<>();
		for (EocIntgMapping mapping : tMappings) {
			if (tMappingsGroupByProductName.get(mapping.getProducName()) == null) {
				List<EocIntgMapping> tProductNameMappingList = new ArrayList<>();
				tProductNameMappingList.add(mapping);
				tMappingsGroupByProductName.put(mapping.getProducName(), tProductNameMappingList);
			} else {
				tMappingsGroupByProductName.get(mapping.getProducName()).add(mapping);
			}
		}
		ArrayNode tProdEocMappingAryNode = mapper.createArrayNode();
		for (String tProductName : tMappingsGroupByProductName.keySet()) {
			JsonNode tIntgInfoNode = null;
			// 如果有註明需要"敘述" "name_include": true 則根據產品UID取得ESP單元對應碼
			try {
				if (pNameInclude) {
					/* 取得ESP單元對應碼 */
					// 根據tProdName, tUid呼叫ESP->ERP取得集成代碼
					tIntgInfoNode = IntgInfoServiceUtil.getIntgInfo(null, pTenantId, tProductName,
							tMappingsGroupByProductName.get(tProductName).get(0).getProductUid());
				}
				// 取得地端om時發生任何錯誤也略過 因為取得name_include是額外的功能
				// 不要因為取得name_include失敗而影響取得運營大表
			} catch (Exception e) {
				log.error(e.getMessage(), e);
			}
			List<EocIntgMapping> tCompanyIdMappings = new ArrayList<>();
			List<EocIntgMapping> tSiteIdMappings = new ArrayList<>();
			List<EocIntgMapping> tRegionIdMappings = new ArrayList<>();
			/*將mappings依據eoc_level分出來 */
			for (EocIntgMapping mapping : tMappingsGroupByProductName.get(tProductName)) {
				if (mapping.getCloudMappingType().equals(EocLevelEnum.company_id.toString())) {
					tCompanyIdMappings.add(mapping);
				} else if (mapping.getCloudMappingType().equals(EocLevelEnum.site_id.toString())) {
					tSiteIdMappings.add(mapping);
				} else if (mapping.getCloudMappingType().equals(EocLevelEnum.region_id.toString())) {
					tRegionIdMappings.add(mapping);
				}
			}
			// 個別產品名稱的運營物件
			ObjectNode tProdEocMappingObjectNode = mapper.createObjectNode();
			if (pNameInclude) {
				Map<String, String> tPrdCondition = new HashMap<>();
				tPrdCondition.put(MdcConstant.NAME, tProductName);
				tPrdCondition.put(MdcConstant.UID, tMappingsGroupByProductName.get(tProductName).get(0).getProductUid());
				List<Product> tProducts = productDao.fetch(tPrdCondition);
				String tEocSetting = "";
				String tEocSettingRegion = "";
				if (tProducts != null && tProducts.size() != 0 && tProducts.get(0).getEocSetting() != null) {
					tEocSetting = tProducts.get(0).getEocSetting();
					tEocSettingRegion = tProducts.get(0).getEocSettingRegion();
				}
				tProdEocMappingObjectNode.put(MdcConstant.EOC_SETTING, tEocSetting);
				tProdEocMappingObjectNode.put(MdcConstant.EOC_SETTING_REGION, tEocSettingRegion);
			}
			tProdEocMappingObjectNode.put(MdcConstant.PROD_NAME, tProductName);
			tProdEocMappingObjectNode.put(MdcConstant.UID, tMappingsGroupByProductName.get(tProductName).get(0).getProductUid());

			/* 組成回傳json */
			// 組成org_type_company陣列
			ArrayNode tOrgTypeCompanyArrayNode = mapper.createArrayNode();
			tProdEocMappingObjectNode.set(MdcConstant.ORG_TYPE_COMPANY, tOrgTypeCompanyArrayNode);
			// 組成cloudMappingType = company_id的物件
			// 從某產品的org_type_company mappings開始掃
			for (EocIntgMapping mapping : tCompanyIdMappings) {
				ObjectNode tCompanyLevelMappingNode = mapper.createObjectNode();
				tCompanyLevelMappingNode.put(MdcConstant.EOC_COMPANY_ID, mapping.getEocId());
				if (pNameInclude) {
					//赋值eoc companyName
					if (tEocNode.get(mapping.getEocId()) !=  null) {
						tCompanyLevelMappingNode.put(MdcConstant.EOC_COMPANY_NAME, tEocNode.get(mapping.getEocId()));
					}
					if (tIntgInfoNode != null) {
						ArrayNode tIntgCompanyAryNode = (ArrayNode) tIntgInfoNode.get(MdcConstant.ORG_TYPE_COMPANY);
						for (JsonNode tIntgCompanyObject : tIntgCompanyAryNode) {
							if (mapping.getIntgId().equals(tIntgCompanyObject.get(MdcConstant.COMPANY_NO).asText())) {
								tCompanyLevelMappingNode.set(MdcConstant.OM_COMPANY_NAME, tIntgCompanyObject.get(MdcConstant.COMPANY_NAME));
							}
						}
					}
				}
				tCompanyLevelMappingNode.put(MdcConstant.OM_COMPANY_ID, mapping.getIntgId());
				if (mapping.getDatakey() != null && mapping.getDatakey().length() != 0) {
					tCompanyLevelMappingNode.put(MdcConstant.DATAKEY, mapping.getDatakey());
				}
				tOrgTypeCompanyArrayNode.add(tCompanyLevelMappingNode);
			}
			// 組成eoc_level = site_id的物件，並放入parent物件
			ArrayNode tOrgTypeSiteArrayNode = mapper.createArrayNode();
			tProdEocMappingObjectNode.set(MdcConstant.ORG_TYPE_SITE, tOrgTypeSiteArrayNode);
			for (EocIntgMapping mapping : tSiteIdMappings) {
				ObjectNode tSiteLevelMappingNode = mapper.createObjectNode();
				tSiteLevelMappingNode.put(MdcConstant.EOC_SITE_ID, mapping.getEocId());
				if (pNameInclude) {
					//赋值eoc siteName
					if (tEocNode.get(mapping.getEocId()) !=  null) {
						tSiteLevelMappingNode.put(MdcConstant.EOC_SITE_NAME, tEocNode.get(mapping.getEocId()));
					}
					if (tIntgInfoNode != null) {
						ArrayNode tIntgCompanyAryNode = (ArrayNode) tIntgInfoNode.get(MdcConstant.ORG_TYPE_COMPANY);
						for (JsonNode tIntgCompanyObject : tIntgCompanyAryNode) {
							if (tIntgCompanyObject.get(MdcConstant.ORG_TYPE_SITE) != null) {

								for (JsonNode tIntgSiteObject : tIntgCompanyObject.get(MdcConstant.ORG_TYPE_SITE)) {
									if (mapping.getIntgId().equals(tIntgSiteObject.get(MdcConstant.SITE_NO).asText())) {
										tSiteLevelMappingNode.set(MdcConstant.OM_SITE_NAME, tIntgSiteObject.get(MdcConstant.SITE_NAME));
									}
								}
							}
						}
					}
				}
				tSiteLevelMappingNode.put(MdcConstant.OM_SITE_ID, mapping.getIntgId());
				if (mapping.getDatakey() != null && mapping.getDatakey().length() != 0) {
					tSiteLevelMappingNode.put(MdcConstant.DATAKEY, mapping.getDatakey());
				}

				tOrgTypeSiteArrayNode.add(tSiteLevelMappingNode);
			}
			// 組成org_type_region陣列
			ArrayNode tOrgTypeRegionArrayNode = mapper.createArrayNode();
			tProdEocMappingObjectNode.set(MdcConstant.ORG_TYPE_REGION, tOrgTypeRegionArrayNode);
			// 組成eoc_level = region_id的物件
			// 從某產品的org_type_region mappings開始掃
			for (EocIntgMapping mapping : tRegionIdMappings) {
				ObjectNode tRegionLevelMappingNode = mapper.createObjectNode();
				tRegionLevelMappingNode.put(MdcConstant.EOC_REGION_ID, mapping.getEocId());
				if (pNameInclude) {

					//赋值eoc regionName
					if (tEocNode.get(mapping.getEocId()) !=  null) {
						tRegionLevelMappingNode.put(MdcConstant.EOC_REGION_NAME, tEocNode.get(mapping.getEocId()));
					}
					if (tIntgInfoNode != null) {
						ArrayNode tIntgRegionAryNode = (ArrayNode) tIntgInfoNode.get(MdcConstant.ORG_TYPE_REGION);

						if (tIntgRegionAryNode != null) {
							for (JsonNode tIntgRegionObject : tIntgRegionAryNode) {
								if (mapping.getIntgId().equals(tIntgRegionObject.get(MdcConstant.REGION_NO).asText())) {
									tRegionLevelMappingNode.set(MdcConstant.OM_REGION_NAME, tIntgRegionObject.get(MdcConstant.REGION_NAME));
								}
							}
						}
					}
				}
				tRegionLevelMappingNode.put(MdcConstant.OM_REGION_ID, mapping.getIntgId());
				/*if (mapping.getRegionType() == null) {
					tRegionLevelMappingNode.put(MdcConstant.REGION_TYPE, "");
				} else {
					tRegionLevelMappingNode.put(MdcConstant.REGION_TYPE, mapping.getRegionType());
				}*/
				if (mapping.getDatakey() != null && mapping.getDatakey().length() != 0) {
					tRegionLevelMappingNode.put(MdcConstant.DATAKEY, mapping.getDatakey());
				}
				tOrgTypeRegionArrayNode.add(tRegionLevelMappingNode);
			}
			tProdEocMappingAryNode.add(tProdEocMappingObjectNode);
		}
		StateCode tStateCode = getStateCode(ValidateStateEnum.SUCCESS.getCode());
		String tDescription = getDescriptionByLocale(tStateCode, locale);
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, null);
		tResponseJsonNode.set(MdcConstant.ORG_TYPE_ENTERPRISE, tEnterpriseObjectNode);
		tResponseJsonNode.set("prod_eoc_mapping", tProdEocMappingAryNode);
		tResponseJsonNode.put(MdcConstant.TENANT_ID, pTenantId);
		return converJsonNodeToMap(tResponseJsonNode);
	}

}