package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.dao.*;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.*;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * 云地映射场域新增、修改、删除
 * Path:[/restful/standard/mdc/CloudRegionMapping/Update]
 */
@org.springframework.stereotype.Service
public class CloudRegionMappingUpdateService extends AbstractApiService {

	@Autowired
	private ProductDao productDao;

	@Autowired
	private ServiceDao serviceDao;

	@Autowired
	private EocIntgMappingDao eocIntgMappingDao;

	@Autowired
	private PrdDatakeyMappingDao prdDatakeyMappingDao;


	@Autowired
	private EaiTenantMappingDao eaiTenantMappingDao;

	public CloudRegionMappingUpdateService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.CLOUD_REGION_UPDATE_SCHEMA;
	}

	/**
	 * 更新eoc_intg_mapping大表(新增、修改、刪除)
	 * 删除-需要清除产品对应的
	 * @param validatorResult      * @param validatorResult
	 * @return map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
				+ ", 原始訊息: " + tRequestJsonNode);
		updateEocOmMapping(tRequestJsonNode);
		StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
		String tDescription =getDescriptionByLocale(tStateCode, locale);
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, null);
		return converJsonNodeToMap(tResponseJsonNode);
	}

	private void updateEocOmMapping(JsonNode pNode) {
		List<EocIntgMapping> tList = new ArrayList<>();
		ArrayNode tMappingInfoAryNode = (ArrayNode) pNode.get(MdcConstant.MAPPING_INFO);
		String tTenantId = pNode.get(MdcConstant.TENANT_ID).asText();
		String tAction = pNode.get(MdcConstant.ACTION).asText();
		String tEocSetting = null;
		String tEocSettingRegion = null;
		// 有給eoc_setting且有值
		if (pNode.get(MdcConstant.EOC_SETTING) != null && pNode.get(MdcConstant.EOC_SETTING).asText().length() != 0) {
			tEocSetting = pNode.get(MdcConstant.EOC_SETTING).asText();
		}
		// 有給eoc_setting_region且有值
		if (pNode.get(MdcConstant.EOC_SETTING_REGION) != null && pNode.get(MdcConstant.EOC_SETTING_REGION).asText().length() != 0) {
			tEocSettingRegion = pNode.get(MdcConstant.EOC_SETTING_REGION).asText();
		}
		// 刪除云地映射数据
		if (MdcConstant.DELETE.equalsIgnoreCase(tAction)) {
			String tLevel = pNode.get(MdcConstant.LEVEL).asText();
			String type = pNode.get(MdcConstant.MAPPING_TYPE).asText();
			// 取得入參UID
			String tUid = pNode.get(MdcConstant.UID).asText();
			String prodName = pNode.get(MdcConstant.PROD_NAME).asText();

			// 將該租戶ID、UID、eocLevel、cloudMappingType、prodName相關的eoc_intg_mapping都刪除
			eocIntgMappingDao.deleteCloudMapping(tTenantId, tUid, tLevel,type,prodName);
			// 取得該UID的產品主機(product資料表)
			Map<String, String> tProductCondition = new HashMap<>();
			tProductCondition.put(MdcConstant.TENANT, tTenantId);
			tProductCondition.put(MdcConstant.UID, tUid);
			List<Product> tProducts = productDao.fetch(tProductCondition);
			// 取得該租戶該產品主機的運營資料
			Map<String, String> tEocIntgCondition = new HashMap<>();
			tEocIntgCondition.put(MdcConstant.PRODUCT_UID, tUid);
			tEocIntgCondition.put(MdcConstant.TENANT_ID, tTenantId);
			tEocIntgCondition.put(MdcConstant.EOC_LEVEL, MdcConstant.CLOUD_MAPPING_ID);
			List<EocIntgMapping> tEocIntgMappings = eocIntgMappingDao.fetch(tEocIntgCondition);
			// 舊規則：將該產品主機的tenant_id設為空字串
			// 新規則：如果該租戶已經沒有該產品主機的運營資料，則將該產品主機的tenant_id設為空字串
			if (tProducts != null && !tProducts.isEmpty() && tEocIntgMappings.isEmpty()) {
				tProducts.get(0).setTenantId("");
				productDao.save(tProducts.get(0));
			}
		} else {

			if(tMappingInfoAryNode.size()<=0){
				return;
			}
			// 新增或更新云地映射
			if (tMappingInfoAryNode.isArray()) {
				for (JsonNode tNode : tMappingInfoAryNode) {

						EocIntgMapping tMapping = new EocIntgMapping();
						// 沒有eoc_id element則不新增該筆運營
						if (tNode.get(MdcConstant.EOC_ID) == null) {
							continue;
						} else {
							tMapping.setEocId(tNode.get(MdcConstant.EOC_ID).asText());
						}
						tMapping.setIntgId(tNode.get(MdcConstant.INTG_ID).asText());
						tMapping.setEocLevel(tNode.get(MdcConstant.LEVEL).asText());
						tMapping.setCloudMappingType(tNode.get(MdcConstant.MAPPING_TYPE).asText());
						tMapping.setProducName(tNode.get(MdcConstant.PROD_NAME).asText());
						tMapping.setProductUid(tNode.get(MdcConstant.UID).asText());
						tMapping.setTenantId(tTenantId);
						Map<String, String> tPrdDatakeyMappingCondition = new HashMap<>();
						tPrdDatakeyMappingCondition.put(MdcConstant.PROD_NAME, tNode.get(MdcConstant.PROD_NAME).asText());
						tPrdDatakeyMappingCondition.put(MdcConstant.EOC_LEVEL, tNode.get(MdcConstant.MAPPING_TYPE).asText());
						List<PrdDatakeyMapping> tDatakeyMappings = prdDatakeyMappingDao.fetch(tPrdDatakeyMappingCondition);
						if (tDatakeyMappings != null && !tDatakeyMappings.isEmpty()) {
							tMapping.setDatakey(tDatakeyMappings.get(0).getFieldName());
						}
						tMapping.setBuildTime(Calendar.getInstance());
						tList.add(tMapping);
				}
			}

			//更新前先删除
			if(MdcConstant.UPDATE.equalsIgnoreCase(tAction) && !tList.isEmpty()){
				eocIntgMappingDao.deleteCloudMapping(tTenantId, tList.get(0).getProductUid(), tList.get(0).getEocLevel(),
						tList.get(0).getCloudMappingType(),tList.get(0).getProductName());
			}
			// 先處理沒有階層關係的eoc_intg_mapping資料
			eocIntgMappingDao.updateCloudList(tList);

			// 用UID找出所有符合的產品
			Map<String, String> tProductCondition = new HashMap<>();
			tProductCondition.put(MdcConstant.UID, tMappingInfoAryNode.get(0).get(MdcConstant.UID).asText());
			List<Product> tProducts = productDao.fetch(tProductCondition);
			boolean tProductWithSameTenantIdExist = false;
			boolean tProductWithNoTenantIdExist = false;
			for (Product tProduct : tProducts) {
				// 存在相同租戶ID的產品
				if (tTenantId.equals(tProduct.getTenantId())) {
					if (tEocSetting != null) {
						tProduct.setEocSetting(tEocSetting);
					}
					if (tEocSettingRegion != null) {
						tProduct.setEocSettingRegion(tEocSettingRegion);
					}
					tProduct.setLastUpdateTime(Calendar.getInstance());
					productDao.save(tProduct);
					tProductWithSameTenantIdExist = true;
				}
			}
			// 不存在相同租戶ID的產品
			if (!tProductWithSameTenantIdExist) {
				// 複製其中一筆產品的資訊和服務清單
				for (Product tProduct : tProducts) {
					if (tProduct.getTenantId() == null || tProduct.getTenantId().length() == 0) {
						Map<String, String> tCondition = new HashMap<>();
						tCondition.put(MdcConstant.TENANT, tTenantId);
						List<EaiTenantMapping> eaiTenantMappings = eaiTenantMappingDao.fetch(tCondition);
						// 要檢查是否相同eai uid
						if (eaiTenantMappings != null && eaiTenantMappings.size() != 0
								&& tProduct.getEaiUid().equals(eaiTenantMappings.get(0).getEaUid())) {
							// 存在無租戶ID的產品，則設定租戶ID、儲存
							if (tEocSetting != null) {
								tProduct.setEocSetting(tEocSetting);
							}
							if (tEocSettingRegion != null) {
								tProduct.setEocSettingRegion(tEocSettingRegion);
							}
							tProduct.setTenantId(tTenantId);
							tProduct.setLastUpdateTime(Calendar.getInstance());
							productDao.save(tProduct);
							tProductWithNoTenantIdExist = true;
							break;
						}
					}
				}
				// 不存在無租戶ID的產品
				if (!tProductWithNoTenantIdExist) {
					for (Product tProduct : tProducts) {
						Map<String, String> tCondition = new HashMap<>();
						tCondition.put(MdcConstant.TENANT, tTenantId);
						List<EaiTenantMapping> eaiTenantMappings = eaiTenantMappingDao.fetch(tCondition);
						if (eaiTenantMappings != null && eaiTenantMappings.size() != 0
								&& tProduct.getEaiUid().equals(eaiTenantMappings.get(0).getEaUid())) {
							List<Service> tServices = serviceDao.getByPrdId(tProduct.getId());
							// 設定租戶ID、清空主鍵、儲存
							if (tEocSetting != null) {
								tProduct.setEocSetting(tEocSetting);
							}
							if (tEocSettingRegion != null) {
								tProduct.setEocSettingRegion(tEocSettingRegion);
							}
							tProduct.setBuildTime(Calendar.getInstance());
							tProduct.setTenantId(tTenantId);
							tProduct.setId(null);
							Product tReturnedProduct = productDao.save(tProduct);
							// 設定服務清單
							for (Service service : tServices) {
								service.setProduct(tReturnedProduct);
								service.setId(null);
								serviceDao.save(service);
							}
							break;
						}
					}
				}
			}
		}
	}
}