package com.digiwin.metadatacache.apiservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.digiwin.metadatacache.dao.GlobalParamsDao;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.GlobalParam;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * 取得某租戶的全域管理參數值
 * Path:[/restful/standard/mdc/GlobalParams/Get]
 */
@Service
public class GlobalParamsGetService extends AbstractApiService {
	
	@Autowired
	private GlobalParamsDao globalParamsDao;

	public GlobalParamsGetService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.GLOBAL_PARAMS_GET_SCHEMA;
	}

	/**
	 * 查询租户全局配置
	 * @param validatorResult      * @param validatorResult
	 * @return Map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
				+ ", 原始訊息: " + tRequestJsonNode);
		String tTenantId = tRequestJsonNode.get(MdcConstant.TENANT_ID).asText();
		// 組CacheKey
		// 取tenant_id+'/'+api_name做HashKey
		String tCacheMapKey = CacheMapTypeEnum.global_param_cachemap.getCode();
		// 進元數據快取中找出對應資料
		String tDataFromCache = cacheService.getCacheMapValue(tCacheMapKey, tTenantId);
		// 有對應資料直接回傳
		if (null != tDataFromCache) {
			log.info("命中快取: " + tCacheMapKey + "// " + tTenantId);
			return converJsonStringToMap(tDataFromCache);
		}
		//根據入參tenant_id取得全域管理參數值
		Map<String, String> pCondition = new HashMap<>();
		pCondition.put(MdcConstant.TENANT_ID, tTenantId);
		List<GlobalParam> tGlobalParamsList = globalParamsDao.fetch(pCondition);
		// 組成回傳json
		ObjectNode tMgmtParamsNode = mapper.createObjectNode();
		if (CollectionUtils.isNotEmpty(tGlobalParamsList)) {
			for (GlobalParam tGlobalParam : tGlobalParamsList) {
				tMgmtParamsNode.put(tGlobalParam.getParam(), tGlobalParam.getValue());
			}
		}
		StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
		String tDescription = getDescriptionByLocale(tStateCode, locale);
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, null);
		tResponseJsonNode.put(MdcConstant.TENANT_ID, tTenantId);
		tResponseJsonNode.set(MdcConstant.MGMT_PARAMS, tMgmtParamsNode);
		// 將回傳訊息加入快取中
		if (tStateCode.getCode().equals("000") && CollectionUtils.isNotEmpty(tGlobalParamsList)) {
			cacheService.setCacheMapValue(tCacheMapKey, tTenantId, tResponseJsonNode.toString());
		}
		return converJsonNodeToMap(tResponseJsonNode);
	}

}
