package com.digiwin.metadatacache.apiservice;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

import com.digiwin.metadatacache.dao.TenantEocSetInfoDao;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.TenantEocSetInfo;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;

/**
 * 设置运营单元忽略配置
 * Path:[/restful/standard/mdc/tenant/IgnoreEocSet]
 */
@org.springframework.stereotype.Service
public class IgnoreEocSetService extends AbstractApiService {

	@Autowired
	private TenantEocSetInfoDao tenantEocSetInfoDao;

	public IgnoreEocSetService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.IGNORE_EOC_SET_SCHEMA;
	}

	/**
	 * 设置运营单元忽略配置
	 * @param validatorResult      * @param validatorResult
	 * @return map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
				+ ", 原始訊息: " + tRequestJsonNode);
		return ignoreEocSet(tRequestJsonNode);
	}

	private Map<String, Object> ignoreEocSet(JsonNode pMessageNode) {
		String tenantId = pMessageNode.get(MdcConstant.TENANT_ID).asText();
		String userId = pMessageNode.get(MdcConstant.USER_ID).asText();
		Map<String, String> condition = new HashMap<>();
		condition.put(MdcConstant.TENANT_ID, tenantId);
		condition.put(MdcConstant.USER_ID, userId);
		List<TenantEocSetInfo> tenantEocSetInfos = tenantEocSetInfoDao.fetch(condition);
		TenantEocSetInfo tenantEocSetInfo = new TenantEocSetInfo();
		if (CollectionUtils.isNotEmpty(tenantEocSetInfos)) {
			tenantEocSetInfo = tenantEocSetInfos.get(0);
			tenantEocSetInfo.setRequireSetting(false);
			tenantEocSetInfo.setLastUpdateTime(Calendar.getInstance());
		} else {
			tenantEocSetInfo.setTenantId(tenantId);
			tenantEocSetInfo.setUserId(userId);
			tenantEocSetInfo.setBuildTime(Calendar.getInstance());
			tenantEocSetInfo.setRequireSetting(false);
		}
		tenantEocSetInfoDao.saveOrupdate(tenantEocSetInfo);
		Map<String, Object> tReturn = new HashMap<>();
		tReturn.put(MdcConstant.RESULT, "success");
		return tReturn;
	}

}