package com.digiwin.metadatacache.apiservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.constant.MdcSymbolConstant;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.util.IamVerifyServiceUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

import com.digiwin.metadatacache.dao.EaiTenantMappingDao;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EaiTenantMapping;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * 取得om單元對應租戶ID
 * Path:[/restful/standard/mdc/OmTenantId/Get]
 */
@org.springframework.stereotype.Service
public class OmTenantIdGetService extends AbstractApiService {

	@Autowired
	private EocIntgMappingDao eocIntgMappingDao;

	@Autowired
	private EaiTenantMappingDao eaiTenantMappingDao;

	@Autowired
	private ProductDao productDao;

	public OmTenantIdGetService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.OM_TENANTID_GET_SCHEMA;
	}

	/**
	 * 获取集成清单代码对应的租户
	 * @param validatorResult      * @param validatorResult
	 * @return Map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
				+ ", 原始訊息: " + tRequestJsonNode);
		// 取得入參eai_uid, prod_uid, om_map(om_company_id, om_site_id)
		String tEaiUid = tRequestJsonNode.get(MdcConstant.EAI_UID).asText();
		String tProdUid = tRequestJsonNode.get(MdcConstant.PROD_UID).asText();
		JsonNode tOmMapNode = tRequestJsonNode.get(MdcConstant.OM_MAP);
		String tOmCompanyId = null;
		String tOmSiteId = null;

		String tReturnedTenantId = "";
		if (tOmMapNode.get(MdcConstant.OM_COMPANY_ID) != null && tOmMapNode.get(MdcConstant.OM_COMPANY_ID).asText().length() != 0) {
			tOmCompanyId = tOmMapNode.get(MdcConstant.OM_COMPANY_ID).asText();
		}
		if (tOmMapNode.get(MdcConstant.OM_SITE_ID) != null && tOmMapNode.get(MdcConstant.OM_SITE_ID).asText().length() != 0) {
			tOmSiteId = tOmMapNode.get(MdcConstant.OM_SITE_ID).asText();
		}


		Map<String, String> condition = new HashMap<>();
		condition.put(MdcConstant.EAI_UID, tEaiUid);
		condition.put(MdcConstant.UID, tProdUid);
		List<Product> tProducts = productDao.fetch(condition);
		if(CollectionUtils.isNotEmpty(tProducts)){
			Product product = tProducts.get(0);
			String tenantId = product.getTenantId();
			//获取当前租户的版本
			String version = IamVerifyServiceUtil.getCurrentTenantVersion(tenantId);
			//老版本处理
			if(MdcConstant.TENANT_VERSION_V1.equalsIgnoreCase(version)){

				// 組CacheKey
				// 取tenant_id+'/'+product_name做HashKey
				String tCacheMapKey = CacheMapTypeEnum.om_tenant_cachemap.getCode();
				String tKey = null;
				if (tOmCompanyId != null) {
					StringBuilder tSB = new StringBuilder();
					tSB.append(tEaiUid).append(MdcSymbolConstant.COLON).append(tProdUid)
							.append(MdcSymbolConstant.COLON).append(tOmCompanyId);
					if (tOmSiteId != null) {
						tSB.append(MdcSymbolConstant.COLON).append(tOmSiteId);
					}
					tKey = tSB.toString();
					// 進元數據快取中找出對應資料
					String tDataFromCache = cacheService.getCacheMapValue(tCacheMapKey, tKey);
					// 有對應資料直接回傳
					if (null != tDataFromCache) {
						log.info("命中快取: " + tCacheMapKey + "// " + tKey);
						return converJsonStringToMap(tDataFromCache);
					}
				}

				List<EocIntgMapping> tCompanyEocIntgMappings = null;
				List<EocIntgMapping> tSiteEocIntgMappings;
				Map<String, String> tCompanyEocIntgMappingCondition = new HashMap<>();
				Map<String, String> tSiteEocIntgMappingCondition = new HashMap<>();
				List<EaiTenantMapping> tEaiTenantMappings;

				//取得符合prod_uid, om_company_id的運營單元
				if (tOmCompanyId != null) {
					tCompanyEocIntgMappingCondition.put(MdcConstant.PRODUCT_UID, tProdUid);
					tCompanyEocIntgMappingCondition.put(MdcConstant.INTG_ID, tOmCompanyId);
					tCompanyEocIntgMappingCondition.put(MdcConstant.EOC_LEVEL, MdcConstant.COMPANY_ID);
					tCompanyEocIntgMappings = eocIntgMappingDao.fetch(tCompanyEocIntgMappingCondition);
				}
				if (CollectionUtils.isNotEmpty(tCompanyEocIntgMappings)) {
					// 取得符合prod_uid, om_site_id的運營單元
					if (tOmSiteId != null) {
						tSiteEocIntgMappingCondition.put(MdcConstant.PRODUCT_UID, tProdUid);
						tSiteEocIntgMappingCondition.put(MdcConstant.INTG_ID, tOmSiteId);
						tSiteEocIntgMappingCondition.put(MdcConstant.EOC_LEVEL, MdcConstant.SITE_ID);
						tSiteEocIntgMappings = eocIntgMappingDao.fetch(tSiteEocIntgMappingCondition);
						if (CollectionUtils.isNotEmpty(tSiteEocIntgMappings)) {
							point: for (EocIntgMapping tSiteEocIntgMapping : tSiteEocIntgMappings) {
								for (EocIntgMapping tCompanyEocIntgMapping : tCompanyEocIntgMappings) {
									if (tSiteEocIntgMapping.getEocIntgMapping() != null) {
										if (tSiteEocIntgMapping.getEocIntgMapping().getId()
												.equals(tCompanyEocIntgMapping.getId())) {
											Map<String, String> tEaiTenantMappingCondition = new HashMap<>();
											tEaiTenantMappingCondition.put(MdcConstant.EAI_UID, tEaiUid);
											tEaiTenantMappingCondition.put(MdcConstant.TENANT_ID,
													tCompanyEocIntgMappings.get(0).getTenantId());
											tEaiTenantMappings = eaiTenantMappingDao.fetch(tEaiTenantMappingCondition);
											if (tEaiTenantMappings != null && !tEaiTenantMappings.isEmpty()) {
												tReturnedTenantId = tSiteEocIntgMapping.getTenantId();
												break point;
											}
										}
									}
								}
							}
						}
					} else {
						for (EocIntgMapping tEocIntgMapping : tCompanyEocIntgMappings) {
							Map<String, String> tEaiTenantMappingCondition = new HashMap<>();
							tEaiTenantMappingCondition.put(MdcConstant.EAI_UID, tEaiUid);
							tEaiTenantMappingCondition.put(MdcConstant.TENANT, tEocIntgMapping.getTenantId());
							tEaiTenantMappings = eaiTenantMappingDao.fetch(tEaiTenantMappingCondition);
							if (CollectionUtils.isNotEmpty(tEaiTenantMappings)) {
								tReturnedTenantId = tEocIntgMapping.getTenantId();
								break;
							}
						}
					}
				}

				StateCode tStateCode = getStateCode(ValidateStateEnum.SUCCESS.getCode());
				String tDescription = getDescriptionByLocale(tStateCode, locale);
				ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, null);
				tResponseJsonNode.put(MdcConstant.TENANT_ID, tReturnedTenantId);
				// 將回傳訊息加入快取中
				if (tStateCode.getCode().equals("000") && tKey != null && CollectionUtils.isNotEmpty(tCompanyEocIntgMappings)) {
					cacheService.setCacheMapValue(tCacheMapKey, tKey, tResponseJsonNode.toString());
				}
				return converJsonNodeToMap(tResponseJsonNode);
			}else {
				//查询v2运营单元数据
				Map<String, String> tEocIntgMappingCondition = new HashMap<>();
				tEocIntgMappingCondition.put(MdcConstant.PRODUCT_UID, tProdUid);
				tEocIntgMappingCondition.put(MdcConstant.TENANT_ID, tenantId);
				tEocIntgMappingCondition.put(MdcConstant.EOC_LEVEL, MdcConstant.CLOUD_MAPPING_ID);
				List<EocIntgMapping> list = eocIntgMappingDao.fetch(tEocIntgMappingCondition);
				//拿到地端id集合
				List<String> intgIds = list.stream().map(EocIntgMapping::getIntgId).collect(Collectors.toList());
				//如果存在公司或者工厂
				if(intgIds.contains(tOmCompanyId) || intgIds.contains(tOmSiteId)){
					tReturnedTenantId = tenantId;
				}
				StateCode tStateCode = getStateCode(ValidateStateEnum.SUCCESS.getCode());
				String tDescription = getDescriptionByLocale(tStateCode, locale);
				ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, null);
				tResponseJsonNode.put(MdcConstant.TENANT_ID, tReturnedTenantId);
				return converJsonNodeToMap(tResponseJsonNode);
			}
		}

		StateCode tStateCode = getStateCode(ValidateStateEnum.SUCCESS.getCode());
		String tDescription = getDescriptionByLocale(tStateCode, locale);
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, null);
		return converJsonNodeToMap(tResponseJsonNode);
	}
}
