package com.digiwin.metadatacache.apiservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.util.EocInfoServiceUtil;
import com.digiwin.metadatacache.util.IntgInfoServiceUtil;
import org.springframework.beans.factory.annotation.Autowired;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.enums.EocLevelEnum;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * 取得指定產品運營清單(含運營階層關係)
 * Path:[/restful/standard/mdc/OperationManageSetting/Get]
 */
@org.springframework.stereotype.Service
public class OperationManageSettingGetService extends AbstractApiService {

	@Autowired
	private EocIntgMappingDao eocIntgMappingDao;

	public OperationManageSettingGetService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.OPERATION_MANAGE_SETTING_GET_SCHEMA;
	}

	/**
	 * 取得指定产品的运营清单-入参解析
	 * @param validatorResult      * @param validatorResult
	 * @return map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
				+ ", 原始訊息: " + tRequestJsonNode);
		// 取出入參tenant, api_name
		String tTenantId = tRequestJsonNode.get(MdcConstant.TENANT_ID).asText();
		String tUid = null;
		String tEnterPriseId = null;
		if (tRequestJsonNode.get(MdcConstant.ENTERPRISE_ID) != null
				&& !StringUtil.isEmptyOrSpace(tRequestJsonNode.get(MdcConstant.ENTERPRISE_ID).asText())) {
			tEnterPriseId = tRequestJsonNode.get(MdcConstant.ENTERPRISE_ID).asText();
		}
		if (tRequestJsonNode.get(MdcConstant.UID) != null && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get(MdcConstant.UID).asText())) {
			tUid = tRequestJsonNode.get(MdcConstant.UID).asText();
		}
		String tProdName = tRequestJsonNode.get(MdcConstant.PROD_NAME).asText();
		return getOperationManageSetting(tTenantId, tProdName, tUid, tEnterPriseId);
	}

	/**
	 * 取得租戶特定產品的運營清單
	 * @param pTenantId 租户ID
	 * @param pProdName 产品名称
	 * @param pUid      产品UID
	 * @param pEnterPriseId  pEnterPriseId
	 * @return Map
	 * @throws Exception Exception
	 */
	private Map<String, Object> getOperationManageSetting(String pTenantId, String pProdName, String pUid, String pEnterPriseId) throws Exception {
		List<EocIntgMapping> tEnterpriseIdMappings = new ArrayList<>();
		List<EocIntgMapping> tCompanyIdMappings = new ArrayList<>();
		List<EocIntgMapping> tSiteIdMappings = new ArrayList<>();
		List<EocIntgMapping> tRegionIdMappings = new ArrayList<>();
		// 取得已配置數據
		Map<String, String> pCondition = new HashMap<>();
		pCondition.put(MdcConstant.TENANT_ID, pTenantId);
		pCondition.put(MdcConstant.PROD_NAME, pProdName);
		if (pUid != null) {
			pCondition.put(MdcConstant.UID, pUid);
		}
		List<EocIntgMapping> tEocIntgMappings = eocIntgMappingDao.fetch(pCondition);
		// 將tEocIntgMappings依據eoc_level分出來
		for (EocIntgMapping eocIntgMapping : tEocIntgMappings) {
			if (eocIntgMapping.getEocLevel().equals(EocLevelEnum.company_id.toString())) {
				tCompanyIdMappings.add(eocIntgMapping);
			} else if (eocIntgMapping.getEocLevel().equals(EocLevelEnum.site_id.toString())) {
				tSiteIdMappings.add(eocIntgMapping);
			} else if (eocIntgMapping.getEocLevel().equals(EocLevelEnum.region_id.toString())) {
				tRegionIdMappings.add(eocIntgMapping);
			} else if (eocIntgMapping.getEocLevel().equals(EocLevelEnum.enterprise_id.toString())) {
				tEnterpriseIdMappings.add(eocIntgMapping);
			}
		}
		// 組成回傳json
		// 組成org_type_enterprise物件
		ObjectNode tEnterpriseLevelMappingNode = mapper.createObjectNode();
		if (!tEnterpriseIdMappings.isEmpty()) {
			EocIntgMapping mapping = tEnterpriseIdMappings.get(0);
			tEnterpriseLevelMappingNode.put(MdcConstant.EOC_ENTERPRISE_ID, mapping.getEocId());
			tEnterpriseLevelMappingNode.put(MdcConstant.OM_ENTERPRISE_ID, mapping.getIntgId());
			if (mapping.getDatakey() != null && mapping.getDatakey().length() != 0) {
				tEnterpriseLevelMappingNode.put(MdcConstant.DATAKEY, mapping.getDatakey());
			}
		}
		// 組成org_type_company陣列
		ArrayNode tOrgTypeCompanyArrayNode = mapper.createArrayNode();
		for (EocIntgMapping mapping : tCompanyIdMappings) {
			ObjectNode tCompanyLevelMappingNode = mapper.createObjectNode();
			tCompanyLevelMappingNode.put(MdcConstant.EOC_COMPANY_ID, mapping.getEocId());
			tCompanyLevelMappingNode.put(MdcConstant.OM_COMPANY_ID, mapping.getIntgId());
			// 加上eoc_company_name, om_company_name字段
			tCompanyLevelMappingNode.put(MdcConstant.EOC_COMPANY_NAME, mapping.getEocName());
			tCompanyLevelMappingNode.put(MdcConstant.OM_COMPANY_NAME, mapping.getIntgName());
			if (mapping.getDatakey() != null && mapping.getDatakey().length() != 0) {
				tCompanyLevelMappingNode.put(MdcConstant.DATAKEY, mapping.getDatakey());
			}
			tOrgTypeCompanyArrayNode.add(tCompanyLevelMappingNode);
			// 加上"enable":true字段(表示此配置已啟用)
			tCompanyLevelMappingNode.put(MdcConstant.ENABLE, true);
		}
		// 組成org_type_site陣列，eoc_level = site_id的物件，並放入parent物件
		for (EocIntgMapping tSiteIdMapping : tSiteIdMappings) {
			ObjectNode tSiteLevelMappingNode = mapper.createObjectNode();
			tSiteLevelMappingNode.put(MdcConstant.EOC_SITE_ID, tSiteIdMapping.getEocId());
			tSiteLevelMappingNode.put(MdcConstant.OM_SITE_ID, tSiteIdMapping.getIntgId());
			// 加上eoc_site_name, om_site_name字段
			tSiteLevelMappingNode.put(MdcConstant.EOC_SITE_NAME, tSiteIdMapping.getEocName());
			tSiteLevelMappingNode.put(MdcConstant.OM_SITE_NAME, tSiteIdMapping.getIntgName());
			if (tSiteIdMapping.getDatakey() != null && tSiteIdMapping.getDatakey().length() != 0) {
				tSiteLevelMappingNode.put(MdcConstant.DATAKEY, tSiteIdMapping.getDatakey());
			}
			// 加上"enable":true字段(表示此配置已啟用)
			tSiteLevelMappingNode.put(MdcConstant.ENABLE, true);
			// 有parent mapping
			if (tSiteIdMapping.getEocIntgMapping() != null) {
				// 找到parent節點
				for (JsonNode tCompanyNode : tOrgTypeCompanyArrayNode) {
					if (tCompanyNode.get(MdcConstant.EOC_COMPANY_ID).asText()
							.equals(tSiteIdMapping.getEocIntgMapping().getEocId())) {
						// parent節點已經有"org_type_site"陣列
						if (tCompanyNode.get(MdcConstant.ORG_TYPE_SITE) != null) {
							((ArrayNode) tCompanyNode.get(MdcConstant.ORG_TYPE_SITE)).add(tSiteLevelMappingNode);
							// parent節點沒有"org_type_site"陣列
						} else {
							ArrayNode tOrgTypeSiteArrayNode = mapper.createArrayNode();
							((ObjectNode) tCompanyNode).set(MdcConstant.ORG_TYPE_SITE, tOrgTypeSiteArrayNode);
							tOrgTypeSiteArrayNode.add(tSiteLevelMappingNode);
						}
					}
				}
			}
		}
		// 組成org_type_region陣列
		ArrayNode tOrgTypeRegionArrayNode = mapper.createArrayNode();
		for (EocIntgMapping tRegionIdMapping : tRegionIdMappings) {
			ObjectNode tRegionLevelMappingNode = mapper.createObjectNode();
			tRegionLevelMappingNode.put(MdcConstant.EOC_REGION_ID, tRegionIdMapping.getEocId());
			tRegionLevelMappingNode.put(MdcConstant.OM_REGION_ID, tRegionIdMapping.getIntgId());
			if (tRegionIdMapping.getRegionType() == null) {
				tRegionLevelMappingNode.put(MdcConstant.REGION_TYPE, "");
			} else {
				tRegionLevelMappingNode.put(MdcConstant.REGION_TYPE, tRegionIdMapping.getRegionType());
			}
			if (tRegionIdMapping.getDatakey() != null && tRegionIdMapping.getDatakey().length() != 0) {
				tRegionLevelMappingNode.put(MdcConstant.DATAKEY, tRegionIdMapping.getDatakey());
			}
			// 加上"enable":true字段(表示此配置已啟用)
			tRegionLevelMappingNode.put(MdcConstant.ENABLE, true);
			tOrgTypeRegionArrayNode.add(tRegionLevelMappingNode);
		}
		// 取得穩態產品om
		JsonNode tOmInfoNode;
		//畫面上沒有傳集團碼
		if (StringUtil.isEmpty(pEnterPriseId)) {
			//如果數據庫中有集團的配置就用數據庫的
			if (tEnterpriseIdMappings.size() != 0) {
				tOmInfoNode = IntgInfoServiceUtil.getIntgInfo(tEnterpriseIdMappings.get(0).getEocId(), pTenantId, pProdName, pUid);
			} else {
				tOmInfoNode = IntgInfoServiceUtil.getIntgInfo(null, pTenantId, pProdName, pUid);
			}
			//畫面上有傳集團碼
		} else {
			tOmInfoNode = IntgInfoServiceUtil.getIntgInfo(pEnterPriseId, pTenantId, pProdName, pUid);
		}
		// 取得雲上eoc
		JsonNode tEocInfoNode = EocInfoServiceUtil.getEocInfoByUserToken(
				DWServiceContext.getContext().getRequestHeader().get(MdcConstant.TOKEN).toString());
		ObjectNode tEocDataNode = (ObjectNode) tEocInfoNode.get(MdcConstant.DATA);
		ArrayNode tEocCompanyAryNode = (ArrayNode) tEocDataNode.get(MdcConstant.COMPANIES);
		ArrayNode tEocFactoriesAryNode = (ArrayNode) tEocDataNode.get(MdcConstant.FACTORIES);
		ArrayNode tIntgCompanyAryNode = (ArrayNode) tOmInfoNode.get(MdcConstant.ORG_TYPE_COMPANY);
		// 從tOmInfoNode裡面的org_type_company[]開始逐個檢查
		for (JsonNode tIntgCompanyObject : tIntgCompanyAryNode) {
			boolean isEnable = false;
			JsonNode enableCompanyNode = null;
			for (JsonNode tCompanyNode : tOrgTypeCompanyArrayNode) {
				// 有配置過就略過不用放入回傳json
				if (tIntgCompanyObject.get(MdcConstant.COMPANY_NO).asText().equals(tCompanyNode.get(MdcConstant.OM_COMPANY_ID).asText())) {
					isEnable = true;
					enableCompanyNode = tCompanyNode;
					break;
				}
			}
			// 沒有配置過的om_company_id，則將對應放入回傳json，狀態為禁用("enable":false)
			ObjectNode tAddCompanyMappingNode = mapper.createObjectNode();
			if (!isEnable) {
				tAddCompanyMappingNode.put(MdcConstant.EOC_COMPANY_ID, tIntgCompanyObject.get(MdcConstant.COMPANY_NO).asText());
				tAddCompanyMappingNode.put(MdcConstant.OM_COMPANY_ID, tIntgCompanyObject.get(MdcConstant.COMPANY_NO).asText());
				tAddCompanyMappingNode.put(MdcConstant.OM_COMPANY_NAME, tIntgCompanyObject.get(MdcConstant.COMPANY_NAME).asText());
				for (JsonNode tEocCompanyObject : tEocCompanyAryNode) {
					// 如果雲上eoc的id有和om company_no相同者，則取其name值用
					if (tEocCompanyObject.get(MdcConstant.ID).asText().equals(tIntgCompanyObject.get(MdcConstant.COMPANY_NO).asText())) {
						tAddCompanyMappingNode.put(MdcConstant.EOC_COMPANY_NAME, tEocCompanyObject.get(MdcConstant.NAME).asText());
					}
				}
				// 加上"enable":false字段(表示此配置未啟用)
				tAddCompanyMappingNode.put(MdcConstant.ENABLE, false);
				tOrgTypeCompanyArrayNode.add(tAddCompanyMappingNode);
			}
			// 檢查該company_no底下的org_type_site陣列內容
			if (tIntgCompanyObject.get(MdcConstant.ORG_TYPE_SITE) != null) {
				ArrayNode tOrgTypeSiteAryNodeUnderCompany = (ArrayNode) tIntgCompanyObject.get(MdcConstant.ORG_TYPE_SITE);
				// 沒有配置過company
				if (!isEnable) {
					ArrayNode tAddSiteAryNode = mapper.createArrayNode();
					for (JsonNode tSiteNode : tOrgTypeSiteAryNodeUnderCompany) {
						ObjectNode tAddSiteMappingNode = mapper.createObjectNode();
						tAddSiteMappingNode.put(MdcConstant.EOC_SITE_ID, tSiteNode.get(MdcConstant.SITE_NO).asText());
						tAddSiteMappingNode.put(MdcConstant.OM_SITE_ID, tSiteNode.get(MdcConstant.SITE_NO).asText());
						for (JsonNode tEocSiteObject : tEocFactoriesAryNode) {
							// 如果雲上eoc的id有和om site_no相同者，則取其name值用
							if (tEocSiteObject.get(MdcConstant.COMPANYID) != null
									&& tEocSiteObject.get(MdcConstant.COMPANYID).asText()
											.equals(tIntgCompanyObject.get(MdcConstant.COMPANY_NO).asText())
									&& tEocSiteObject.get(MdcConstant.ID).asText().equals(tSiteNode.get(MdcConstant.SITE_NO).asText())) {
								tAddSiteMappingNode.put(MdcConstant.EOC_SITE_NAME, tEocSiteObject.get(MdcConstant.NAME).asText());
							}

						}
						tAddSiteMappingNode.put(MdcConstant.OM_SITE_NAME, tSiteNode.get(MdcConstant.SITE_NAME).asText());
						// 加上"enable":false字段(表示此配置未啟用)
						tAddSiteMappingNode.put(MdcConstant.ENABLE, false);
						tAddSiteAryNode.add(tAddSiteMappingNode);
					}
					tAddCompanyMappingNode.put(MdcConstant.ORG_TYPE_SITE, tAddSiteAryNode);
					// 有配置過company
				} else {
					ArrayNode tEnableSiteAryNode = (ArrayNode) enableCompanyNode.get(MdcConstant.ORG_TYPE_SITE);
					if (tEnableSiteAryNode == null) {
						tEnableSiteAryNode = mapper.createArrayNode();
					}
					for (JsonNode tSiteNode : tOrgTypeSiteAryNodeUnderCompany) {
						boolean isSiteEnable = false;
						for (JsonNode tEnableSiteNode : tEnableSiteAryNode) {
							// 有配置過site就略過不用放入回傳json
							if (tEnableSiteNode.get(MdcConstant.OM_SITE_ID).asText().equals(tSiteNode.get(MdcConstant.SITE_NO).asText())) {
								isSiteEnable = true;
								break;
							}
						}
						// 沒有配置過site就補上
						if (!isSiteEnable) {
							ObjectNode tAddSiteMappingNode = mapper.createObjectNode();
							tAddSiteMappingNode.put(MdcConstant.EOC_SITE_ID, tSiteNode.get(MdcConstant.SITE_NO).asText());
							tAddSiteMappingNode.put(MdcConstant.OM_SITE_ID, tSiteNode.get(MdcConstant.SITE_NO).asText());
							for (JsonNode tEocSiteObject : tEocFactoriesAryNode) {
								// 如果雲上eoc的id有和om site_no相同者，則取其name值用
								if (tEocSiteObject.get(MdcConstant.COMPANYID) != null
										&& tEocSiteObject.get(MdcConstant.COMPANYID).asText()
												.equals(tIntgCompanyObject.get(MdcConstant.COMPANY_NO).asText())
										&& tEocSiteObject.get(MdcConstant.ID).asText().equals(tSiteNode.get(MdcConstant.SITE_NO).asText())) {
									tAddSiteMappingNode.put(MdcConstant.EOC_SITE_NAME, tEocSiteObject.get(MdcConstant.NAME).asText());
								}

							}
							tAddSiteMappingNode.put(MdcConstant.OM_SITE_NAME, tSiteNode.get(MdcConstant.SITE_NAME).asText());
							// 加上"enable":false字段(表示此配置未啟用)
							tAddSiteMappingNode.put(MdcConstant.ENABLE, false);
							tEnableSiteAryNode.add(tAddSiteMappingNode);
						}
					}
					((ObjectNode) enableCompanyNode).set(MdcConstant.ORG_TYPE_SITE, tEnableSiteAryNode);
				}
			}
		}
		StateCode tStateCode = getStateCode(ValidateStateEnum.SUCCESS.getCode());
		String tDescription =getDescriptionByLocale(tStateCode, locale);
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, null);
		tResponseJsonNode.set(MdcConstant.ORG_TYPE_ENTERPRISE, tEnterpriseLevelMappingNode);
		tResponseJsonNode.set(MdcConstant.ORG_TYPE_COMPANY, tOrgTypeCompanyArrayNode);
		tResponseJsonNode.set(MdcConstant.ORG_TYPE_REGION, tOrgTypeRegionArrayNode);
		tResponseJsonNode.put(MdcConstant.TENANT_ID, pTenantId);
		tResponseJsonNode.put(MdcConstant.PROD_NAME, pProdName);
		tResponseJsonNode.put(MdcConstant.UID, pUid);
		return converJsonNodeToMap(tResponseJsonNode);
	}
}