package com.digiwin.metadatacache.apiservice;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.constant.MdcSymbolConstant;
import com.digiwin.metadatacache.dao.ApiDao;
import com.digiwin.metadatacache.dao.ApiMetadataDao;
import com.digiwin.metadatacache.dao.ApiVersionDao;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.ApiMetadata;
import com.digiwin.metadatacache.model.ApiVersion;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.services.LoadCacheService;
import com.digiwin.metadatacache.services.LocalCacheService;
import com.digiwin.metadatacache.util.DateUtil;
import com.digiwin.metadatacache.util.MQUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 刪除API元數據(DSMS同步用)<br>
 * Path:[/restful/standard/mdc/StdApiMetadata/Delete]
 */
@Service
public class StdApiMetadataDeleteService extends AbstractApiService {

    @Autowired
    private ApiDao apiDao;

    @Autowired
    private ApiVersionDao apiVersionDao;

    @Autowired
    private ApiMetadataDao apiMetadataDao;

    @Autowired
    private ApiRelationDeleteService apiRelationDeleteService;

    @Autowired
    protected LoadCacheService loadCacheService;

    @Autowired
    private LocalCacheService localCacheService;

    @Autowired
    private AssetRegisterService assetRegisterService;

    public StdApiMetadataDeleteService() {
        super();
        jsonSchemaFileName = JsonSchemaFileConstant.STANDARD_API_DELETE_SCHEMA;
    }

    /**
     * 删除MDC元数据
     *
     * @param validatorResult * @param validatorResult
     * @return Map
     * @throws BaseException BaseException
     * @throws Exception     Exception
     */
    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        // 1、获取token信息
        String tUserId = (String) DWServiceContext.getContext().getRequestHeader().get(MdcConstant.USERID);
        ArrayNode tApiArrayNode = (ArrayNode) tRequestJsonNode.get(MdcConstant.API_INFO);
        boolean sendMqJudge = false;
        if (tRequestJsonNode.get(MdcConstant.SEND_MQ_JUDGE) != null) {
            sendMqJudge = tRequestJsonNode.get(MdcConstant.SEND_MQ_JUDGE).asBoolean(false);
        }
        if (tApiArrayNode.isArray()) {
            for (JsonNode tApi : tApiArrayNode) {
                String tApiName = tApi.get(MdcConstant.NAME).asText();
                String tApiVersion = tApi.get(MdcConstant.VERSION).asText();
                String tTenantId = null;
                if (tApi.get(MdcConstant.TENANT_ID) != null && tApi.get(MdcConstant.TENANT_ID).asText().length() != 0) {
                    tTenantId = tApi.get(MdcConstant.TENANT_ID).asText();
                }
                apiDao.removeByNameAndVersionTenantId(tApiName, tApiVersion, tTenantId);
                cacheService.remove(CacheMapTypeEnum.api_version_list.getCode() + MdcSymbolConstant.COLON + tApiName);
                log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "清除快取(清除服務版本號)：" + "key = "
                        + CacheMapTypeEnum.api_version_list.getCode() + MdcSymbolConstant.COLON + tApiName);
                loadCacheService.removeData(CacheMapTypeEnum.api_base_info_cachemap.getCode() + MdcSymbolConstant.COLON + tApiName);
                localCacheService.remove(CacheMapTypeEnum.api_relation_idempotency_cachemap, tApiName);
                log.info("删除本地缓存: " + CacheMapTypeEnum.api_base_info_cachemap.getCode() + MdcSymbolConstant.COLON + tApiName);
                // 建立data節點
                ObjectNode tApiMetadataNode = mapper.createObjectNode();
                tApiMetadataNode.put(MdcConstant.API_NAME, tApiName);
                tApiMetadataNode.put(MdcConstant.API_VERSION, tApiVersion);
                if (tTenantId != null) {
                    tApiMetadataNode.put(MdcConstant.TENANT_ID, tTenantId);
                }
                String tDate = DateUtil.formatToDate(new Date());
                tApiMetadataNode.put(MdcConstant.TIMESTAMP, tDate);
                tApiMetadataNode.put(MdcConstant.ACTION, "delete");
                // 發送訊息
                log.info("同步删除信息至MQ开始_API名称:" + tApiName + ",API版本:" + tApiVersion + ",API租户:" + tTenantId);
                MQUtil.sendApiMetadata(tApiMetadataNode.toString());
                log.info("同步删除信息至MQ成功_API名称:" + tApiName + ",API版本:" + tApiVersion + ",API租户:" + tTenantId);
                // 删除资产表
                //assetRegisterService.deletePropertyAndES(tApiName, PropertyTypeEnum.API.toString(), tTenantId);
                if (sendMqJudge) {
                    Map<String, Object> tDataMap = new HashMap<>();
                    // 查询API版本信息
                    List<ApiVersion> apiVersionList = apiVersionDao.getByApiNameAndTenantId(tApiName, tTenantId);
                    if (CollectionUtils.isNotEmpty(apiVersionList)) {
                        ApiVersion apiVersion = getLastedVersion(apiVersionList);
                        tDataMap.put(MdcConstant.API_NAME, apiVersion.getApi().getName());
                        tDataMap.put(MdcConstant.INVOKED_TYPE, apiVersion.getApi().getInvokedType());
                        tDataMap.put(MdcConstant.CATEGORY, apiVersion.getApi().getCategory());
                        tDataMap.put(MdcConstant.PROVIDER, apiVersion.getApi().getProvider());
                        if (StringUtils.isNotBlank(apiVersion.getApi().getTenantId())) {
                            tDataMap.put(MdcConstant.TENANT_ID, apiVersion.getApi().getTenantId());
                        }
                        if (StringUtils.isNotBlank(apiVersion.getApi().getApiExtend())) {
                            tDataMap.put(MdcConstant.API_EXTEND, apiVersion.getApi().getApiExtend());
                        }
                        tDataMap.put(MdcConstant.PACKAGE_NAME, apiVersion.getApi().getPackageName());
                        tDataMap.put(MdcConstant.APPROVED_STATUS, apiVersion.getApprovedStatus());
                        tDataMap.put(MdcConstant.IDEMPOTENCY, apiVersion.isIdempotency());
                        tDataMap.put(MdcConstant.DESCRIPTION_ZH_TW, apiVersion.getApi().getDescriptionZhTw());
                        tDataMap.put(MdcConstant.DESCRIPTION_ZH_CN, apiVersion.getApi().getDescriptionZhCn());
                        tDataMap.put(MdcConstant.DESCRIPTION_EN, apiVersion.getApi().getDescriptionEn());
                        tDataMap.put(MdcConstant.REMARK_ZH_TW, apiVersion.getApi().getRemarkZhTw());
                        tDataMap.put(MdcConstant.REMARK_ZH_CN, apiVersion.getApi().getRemarkZhCn());
                        tDataMap.put(MdcConstant.REMARK_EN, apiVersion.getApi().getRemarkEn());
                        // 查询metaDate
                        List<ApiMetadata> apiMetadataList = apiMetadataDao.getByApiVersionId(apiVersion.getId());
                        if (CollectionUtils.isNotEmpty(apiMetadataList)) {
                            ApiMetadata apiMetadata = apiMetadataList.get(0);
                            ObjectNode tVersionDataNode = mapper.createObjectNode();
                            ObjectMapper objectMapper = new ObjectMapper();
                            tVersionDataNode.set(apiVersion.getVersion(), objectMapper.readTree(apiMetadata.getMetadata()));
                            tDataMap.put(MdcConstant.API_VERSION_INFO, tVersionDataNode);
                            // 發送訊息
                            log.info("同步新增信息至MQ开始_API名称:" + tApiName + ",API版本:" + apiVersion.getVersion() + ",API租户:" + tTenantId);
                            MQUtil.sendApiMetadata(sendMqMessage(tDataMap));
                            log.info("同步新增信息至MQ成功_API名称:" + tApiName + ",API版本:" + apiVersion.getVersion() + ",API租户:" + tTenantId);
                            // 新增历史版本入资产表
//                            log.info("更新资产表开始");
//                            assetRegisterService.saveAssetProperty(tApiName, apiVersion.getApi().getDescriptionZhCn(),
//                                    apiVersion.getApi().getProvider() , apiMetadata, tTenantId, tUserId);
//                            log.info("更新资产表结束");
                        }
                    } else {
                        // 删除关联关系
                        apiRelationDeleteService.deleteApiRelation(tUserId, tApiName, tTenantId);
                    }
                }
            }
        }
        StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
        String tDescription = getDescriptionByLocale(tStateCode, locale);
        ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        return converJsonNodeToMap(tResponseJsonNode);
    }
}
