package com.digiwin.metadatacache.apiservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.digiwin.metadatacache.dao.ApiDao;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.Api;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * 取得拥有个案api的租户列表<br>
 * Path:[/restful/standard/mdc/UcTenantList/Get]
 */
@Service
public class UcTenantListGetService extends AbstractApiService {

	@Autowired
	private ApiDao apiDao;

	public UcTenantListGetService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.UC_TENANT_LIST_GET_SCHEMA;
	}

	/**
	 * 查询拥有个案API的租户
	 * @param validatorResult      * @param validatorResult
	 * @return map
	 * @throws BaseException BaseException
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		// 組成回傳訊息
		// 建立data節點
		ObjectNode tDataNode = mapper.createObjectNode();
		// 建立tenant_list節點(陣列，多筆資料)
		ArrayNode tTenantIdAryNode = mapper.createArrayNode();
		tDataNode.set(MdcConstant.TENANT_LIST, tTenantIdAryNode);
		// 如果入參有api_name
		String tApiName = null;
		if (tRequestJsonNode.get(MdcConstant.API_NAME) != null && tRequestJsonNode.get(MdcConstant.API_NAME).asText().length() != 0) {
			tApiName = tRequestJsonNode.get(MdcConstant.API_NAME).asText();

		}
		log.info("tApiName"+ tApiName);
		List<Api> tUcApiList = apiDao.getUcApi();
		List<String> tTenantList = new ArrayList<>();
		for (Api tApi : tUcApiList) {
			if (!StringUtil.isEmptyOrSpace(tApi.getTenantId()) && !tTenantList.contains(tApi.getTenantId())) {
				tTenantList.add(tApi.getTenantId());
				tTenantIdAryNode.add(tApi.getTenantId());
			}
		}
		// 建立API資訊的d
		StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
		String tDescription = getDescriptionByLocale(tStateCode, locale);
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, tDataNode);
		return converJsonNodeToMap(tResponseJsonNode);
	}
}
