package com.digiwin.metadatacache.dao.impl;

import java.util.Calendar;
import java.util.List;
import java.util.Map;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.digiwin.metadatacache.dao.AppSupportVersionDao;
import com.digiwin.metadatacache.model.AppSupportVersion;

@Service
@Transactional("mdcTransactionManager")
public class AppSupportVersionDaoImpl extends GenericDaoImpl<AppSupportVersion, Long> implements AppSupportVersionDao{

	public AppSupportVersionDaoImpl() {
		super(AppSupportVersion.class);
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public List<AppSupportVersion> fetch(Map<String, String> pConditions) {
		return getHibernateTemplate().execute(new HibernateCallback<List<AppSupportVersion>>() {
			@SuppressWarnings("deprecation")
			@Override
			public List<AppSupportVersion> doInHibernate(Session session) throws HibernateException {
				// Hibernate - Criteria Query 標準查詢
				Criteria tCriteria = session.createCriteria(AppSupportVersion.class);
				
				if (pConditions.containsKey("tenant_id")) {
					tCriteria.add(Restrictions.eq("tenantId", pConditions.get("tenant_id")));
				} 
				if (pConditions.containsKey("appid")) {
					tCriteria.add(Restrictions.eq("appId", pConditions.get("appid")));
				}
				if (pConditions.containsKey("version")) {
					tCriteria.add(Restrictions.eq("appVersion", pConditions.get("version")));
				}
				return tCriteria.list();
			}
		});
	}
	
	@Override
	public AppSupportVersion add(AppSupportVersion pAppSupportVersion) {
		pAppSupportVersion.setBuildTime(Calendar.getInstance());
		pAppSupportVersion.setLastUpdateTime(Calendar.getInstance());
		return super.save(pAppSupportVersion);
	}

	@Override
	public AppSupportVersion update(AppSupportVersion pAppSupportVersion) {
		pAppSupportVersion.setLastUpdateTime(Calendar.getInstance());
		return super.save(pAppSupportVersion);
	}
	
}
