package com.digiwin.metadatacache.dao.impl;

import com.digiwin.metadatacache.dao.AssetDataQueryDao;
import com.digiwin.metadatacache.model.Api;
import com.digiwin.metadatacache.model.AssetDataQuery;
import org.hibernate.*;
import org.hibernate.criterion.*;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

@Service
@Transactional("mdcTransactionManager")
public class AssetDataQueryDaoImpl extends GenericDaoImpl<AssetDataQuery, Long> implements AssetDataQueryDao {

	public AssetDataQueryDaoImpl() {
		super(AssetDataQuery.class);
	}

	// 查詢資料
	@SuppressWarnings("unchecked")
	@Override
	public List<AssetDataQuery> fetch(Map<String, String> pConditions) {
		return getHibernateTemplate().execute(new HibernateCallback<List<AssetDataQuery>>() {
			@SuppressWarnings("deprecation")
			@Override
			public List<AssetDataQuery> doInHibernate(Session session) throws HibernateException {
				// Hibernate - Criteria Query 標準查詢
				Criteria tCriteria = session.createCriteria(Api.class);

				tCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
				tCriteria.setFetchMode("apiVersions", FetchMode.EAGER);
				if (pConditions.containsKey("tenant_id")) {
					tCriteria.add(Restrictions.eq("tenantId", pConditions.get("tenant_id")));
				} else {
					tCriteria.add(Restrictions.isNull("tenantId"));
				}
				if (pConditions.containsKey("name")) {
					tCriteria.add(Restrictions.like("name", pConditions.get("name"), MatchMode.START));
				}
				return tCriteria.list();
			}
		});
	}
}
