package com.digiwin.metadatacache.dao.impl;

import com.digiwin.metadatacache.constant.AssetConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.dao.AssetPropertyDao;
import com.digiwin.metadatacache.model.AssetProperty;
import org.hibernate.*;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

@Service
@Transactional("mdcTransactionManager")
public class AssetPropertyDaoImpl extends GenericDaoImpl<AssetProperty, Long> implements AssetPropertyDao {

    public AssetPropertyDaoImpl() {
        super(AssetProperty.class);
    }

    @Override
    public void deleteByInfo(Map<String, String> pCondition) {
        getHibernateTemplate().execute(new HibernateCallback() {
            @Override
            public Object doInHibernate(Session pSession) throws HibernateException {
                String tenantId = pCondition.get(MdcConstant.TENANT_ID);
                String sql = "delete AssetProperty where code = :code and propertyType= :propertyType";
                if (null != tenantId) {
                    sql += " and tenantId = :tenantId";
                }
                Query tQueryRemoveApi = pSession.createQuery(sql);
                tQueryRemoveApi.setParameter("code", pCondition.get(AssetConstant.CODE));
                tQueryRemoveApi.setParameter("propertyType", pCondition.get(AssetConstant.PROPERTY_TYPE));
                if (null != tenantId) {
                    tQueryRemoveApi.setParameter("code", tenantId);
                }
                tQueryRemoveApi.executeUpdate();
                return null;
            }
        });
    }

    @Override
    public List<AssetProperty> getAssetPropertyByInfo(Map<String, String> pCondition) {
        DetachedCriteria tDetachedCriteria = DetachedCriteria.forClass(AssetProperty.class);
        tDetachedCriteria.add(Restrictions.eq("code", pCondition.get(AssetConstant.CODE)));
        tDetachedCriteria.add(Restrictions.eq("propertyType",  pCondition.get(AssetConstant.PROPERTY_TYPE)));
        String tenantId = pCondition.get(MdcConstant.TENANT_ID);
        if (null != tenantId) {
            tDetachedCriteria.add(Restrictions.eq("tenantId", tenantId));
        }else {
            tDetachedCriteria.add(Restrictions.isNull("tenantId"));
        }
        return (List<AssetProperty>) getHibernateTemplate().findByCriteria(tDetachedCriteria);
    }
}
