package com.digiwin.metadatacache.dao.impl;

import com.digiwin.metadatacache.constant.MdcSymbolConstant;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.services.MdcCacheService;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@Transactional("mdcTransactionManager")
public class EocIntgMappingDaoImpl extends GenericDaoImpl<EocIntgMapping, Long> implements EocIntgMappingDao {

	@Autowired
	protected MdcCacheService cacheService;

	public EocIntgMappingDaoImpl() {
		super(EocIntgMapping.class);
	}

	// 查詢資料
	@SuppressWarnings("unchecked")
	@Override
	public List<EocIntgMapping> fetch(Map<String, String> pConditions) {
		return getHibernateTemplate().execute((HibernateCallback<List<EocIntgMapping>>) pSession -> {
            Criteria tCriteria = getCriteria(pSession, pConditions);
            return tCriteria.list();
        });
	}

	private static Criteria getCriteria(Session pSession, Map<String, String> pConditions) {
		// Hibernate - Criteria Query 標準查詢
		Criteria tCriteria = pSession.createCriteria(EocIntgMapping.class);
		tCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
		if (pConditions.containsKey("tenant_id")) {
			tCriteria.add(Restrictions.eq("tenantId", pConditions.get("tenant_id")));
		}
		if (pConditions.containsKey("prod_name")) {
			tCriteria.add(Restrictions.eq("productName", pConditions.get("prod_name")));
		}
		if (pConditions.containsKey("eoc_id")) {
			tCriteria.add(Restrictions.eq("eocId", pConditions.get("eoc_id")));
		}
		if (pConditions.containsKey("eoc_level")) {
			tCriteria.add(Restrictions.eq("eocLevel", pConditions.get("eoc_level")));
		}
		if (pConditions.containsKey("product_uid")) {
			tCriteria.add(Restrictions.eq("productUid", pConditions.get("product_uid")));
		}
		if (pConditions.containsKey("intg_id")) {
			tCriteria.add(Restrictions.eq("intgId", pConditions.get("intg_id")));
		}
		if (pConditions.containsKey("region_type")) {
			tCriteria.add(Restrictions.eq("regionType", pConditions.get("region_type")));
		}
		if (pConditions.containsKey("uid")) {
			tCriteria.add(Restrictions.eq("productUid", pConditions.get("uid")));
		}
		if (pConditions.containsKey("cloud_mapping_type")) {
			tCriteria.add(Restrictions.eq("cloudMappingType", pConditions.get("cloud_mapping_type")));
		}
		return tCriteria;
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<EocIntgMapping> fetchGroupByEocId(Map<String, String> pConditions) {
		List<EocIntgMapping> list = this.fetch(pConditions);

		return list.stream()
				.collect(Collectors.collectingAndThen(
						Collectors.toMap(EocIntgMapping::getEocId, p -> p, (p, q) -> p),
						map -> new ArrayList<>(map.values())
				));
	}

	@Override
	public List<EocIntgMapping> updateList(final List<EocIntgMapping> pList) {
		// 取出符合的數據
		// 有符合則不更新 沒有符合則新增一筆
		// TODO
		for (EocIntgMapping tMapping : pList) {
			save(tMapping);
		}
		// 清除此運應清單對應租戶的運營清單快取
		if (!pList.isEmpty()) {
			cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_dispatch_cachemap.getCode() + MdcSymbolConstant.COLON + pList.get(0).getTenantId() + MdcSymbolConstant.ASTERISK_SYMBOL);
			cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_operation_cachemap.getCode() + MdcSymbolConstant.COLON + pList.get(0).getTenantId() + MdcSymbolConstant.ASTERISK_SYMBOL);
			cacheService.removeByPattern(CacheMapTypeEnum.om_tenant_cachemap.getCode() + MdcSymbolConstant.ASTERISK_SYMBOL);
			String tKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + MdcSymbolConstant.COLON + pList.get(0).getTenantId();
			cacheService.remove(tKey);
			log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "清除快取(租戶的整個產品清單)：" + "key = " + tKey);
			log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "清除快取(租戶的整個產品清單)：" + "tenant = "
					+ pList.get(0).getTenantId());
		}
		return pList;
	}

	@Override
	public List<EocIntgMapping> updateCloudList(final List<EocIntgMapping> pList) {
		for (EocIntgMapping tMapping : pList) {
			save(tMapping);
		}
		return pList;
	}

	@Override
	public void clearList(final String pTenantId, final String pProductUid) {
		getHibernateTemplate().execute(new HibernateCallback<EocIntgMapping>() {
			@Override
			public EocIntgMapping doInHibernate(Session pSession) throws HibernateException {
				Query tQ = pSession
						.createQuery("delete EocIntgMapping where tenantId is :tenantId and productUid is :productUid");
				tQ.setParameter("tenantId", pTenantId);
				tQ.setParameter("productUid", pProductUid);
				tQ.executeUpdate();
				// 清除此運應清單對應租戶的運營清單快取
				cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_dispatch_cachemap.getCode() + MdcSymbolConstant.COLON + pTenantId + MdcSymbolConstant.ASTERISK_SYMBOL);
				cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_operation_cachemap.getCode() + MdcSymbolConstant.COLON + pTenantId + MdcSymbolConstant.ASTERISK_SYMBOL);
				cacheService.removeByPattern(CacheMapTypeEnum.om_tenant_cachemap.getCode() + MdcSymbolConstant.ASTERISK_SYMBOL);
				String tKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + MdcSymbolConstant.COLON + pTenantId;
				cacheService.remove(tKey);
				log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "清除快取(租戶的整個產品清單)：" + "key = " + tKey);
				log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "清除快取(租戶的整個產品清單)：" + "tenant = "
						+ pTenantId);
				return null;
			}
		});
	}

	/** 刪除子運營 **/
	@Override
	public void deleteChildMapping(long pId) {
		getHibernateTemplate().execute(new HibernateCallback<EocIntgMapping>() {
			@Override
			public EocIntgMapping doInHibernate(Session pSession) throws HibernateException {
				Query tQ = pSession.createQuery("delete EocIntgMapping where eocIntgMapping.id is :id");
				tQ.setParameter("id", pId);
				tQ.executeUpdate();
				return null;
			}
		});
	}

	/** 找出子運營 **/
	@Override
	public List<EocIntgMapping> getChildMapping(long pId) {
		return getHibernateTemplate().execute(new HibernateCallback<List<EocIntgMapping>>() {
			@Override
			public List<EocIntgMapping> doInHibernate(Session pSession) throws HibernateException {
				StringBuilder tHqlSB = new StringBuilder();
				tHqlSB.append("from EocIntgMapping where eocIntgMapping.id is :id");
				Query<EocIntgMapping> tQuery = pSession.createQuery(tHqlSB.toString(), EocIntgMapping.class);
				tQuery.setParameter("id", pId);
				return tQuery.getResultList();
			}
		});
	}

	@Override
	public void clearListWithLevel(final String pTenantId, final String pProductUid, final String pLevel) {
		getHibernateTemplate().execute(new HibernateCallback<EocIntgMapping>() {
			@Override
			public EocIntgMapping doInHibernate(Session pSession) throws HibernateException {
				Query tQ;
				if (pLevel.equals("Company")) {
					tQ = pSession.createQuery(
							"delete EocIntgMapping where tenantId is :tenantId and productUid is :productUid and eocLevel is not :eocLevel");
					tQ.setParameter("tenantId", pTenantId);
					tQ.setParameter("productUid", pProductUid);
					tQ.setParameter("eocLevel", "region_id");
					tQ.executeUpdate();
					log.info("刪除運營配置資料:" + " 租戶 = " + pTenantId + ", 產品主機 = " + pProductUid + ", 層級 = 公司/工廠");
				} else if (pLevel.equals("Region")) {
					tQ = pSession.createQuery(
							"delete EocIntgMapping where tenantId is :tenantId and productUid is :productUid and eocLevel is :eocLevel");
					tQ.setParameter("tenantId", pTenantId);
					tQ.setParameter("productUid", pProductUid);
					tQ.setParameter("eocLevel", "region_id");
					tQ.executeUpdate();
					log.info("刪除運營配置資料:" + " 租戶 = " + pTenantId + ", 產品主機 = " + pProductUid + ", 層級 = 場域");
				} else if (pLevel.equals("All")) {
					tQ = pSession.createQuery(
							"delete EocIntgMapping where tenantId is :tenantId and productUid is :productUid");
					tQ.setParameter("tenantId", pTenantId);
					tQ.setParameter("productUid", pProductUid);
					tQ.executeUpdate();
					log.info("刪除運營配置資料:" + " 租戶 = " + pTenantId + ", 產品主機 = " + pProductUid + ", 層級 = 全層級");
				}
				// 清除此運應清單對應租戶的運營清單快取
				cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_dispatch_cachemap.getCode() + MdcSymbolConstant.COLON + pTenantId+ MdcSymbolConstant.ASTERISK_SYMBOL);
				cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_operation_cachemap.getCode() + MdcSymbolConstant.COLON + pTenantId + MdcSymbolConstant.ASTERISK_SYMBOL);
				cacheService.removeByPattern(CacheMapTypeEnum.om_tenant_cachemap.getCode() + MdcSymbolConstant.ASTERISK_SYMBOL);
				String tKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + MdcSymbolConstant.COLON + pTenantId;
				cacheService.remove(tKey);
				log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "清除快取(租戶的整個產品清單)：" + "key = " + tKey);
				log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "清除快取(租戶的整個產品清單)：" + "tenant = "
						+ pTenantId);
				return null;
			}
		});
	}

	@Override
	public void deleteMapping(final String pTenantId, final String pLevel, final String pUid, final String pProdName,
			final String pEocId, final String pOmId) {
		getHibernateTemplate().execute(new HibernateCallback<EocIntgMapping>() {
			@Override
			public EocIntgMapping doInHibernate(Session pSession) throws HibernateException {
				Query tQ;
				tQ = pSession.createQuery(
						"delete EocIntgMapping where tenantId is :tenantId and productUid is :productUid and eocLevel is :eocLevel and productName is :prodName and eocId is :eocId and intgId is :omId");
				tQ.setParameter("tenantId", pTenantId);
				tQ.setParameter("productUid", pUid);
				tQ.setParameter("eocLevel", pLevel);
				tQ.setParameter("prodName", pProdName);
				tQ.setParameter("eocId", pEocId);
				tQ.setParameter("omId", pOmId);
				tQ.executeUpdate();
				log.info("刪除運營配置資料:" + " 租戶 = " + pTenantId + ", 產品主機 = " + pUid + ", 層級 = " + pLevel + ", eoc = "
						+ pEocId + ", om = " + pOmId);
				// 清除此運應清單對應租戶的運營清單快取
				cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_dispatch_cachemap.getCode() + MdcSymbolConstant.COLON + pTenantId + MdcSymbolConstant.ASTERISK_SYMBOL);
				cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_operation_cachemap.getCode() + MdcSymbolConstant.COLON + pTenantId + MdcSymbolConstant.ASTERISK_SYMBOL);
				cacheService.removeByPattern(CacheMapTypeEnum.om_tenant_cachemap.getCode() + MdcSymbolConstant.ASTERISK_SYMBOL);

				String tKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + MdcSymbolConstant.COLON + pTenantId;
				cacheService.remove(tKey);
				log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "清除快取(租戶的整個產品清單)：" + "key = " + tKey);
				log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "清除快取(租戶的整個產品清單)：" + "tenant = "
						+ pTenantId);
				return null;
			}
		});
	}

	@Override
	public void deleteCloudMapping(String pTenantId, String pLevel, String cloudMappingType, String pUid, String productName, String pEocId, String intgId) {
		getHibernateTemplate().execute(new HibernateCallback<EocIntgMapping>() {
			@Override
			public EocIntgMapping doInHibernate(Session pSession) throws HibernateException {
				Query tQ;
				tQ = pSession.createQuery(
						"delete EocIntgMapping where tenantId is :tenantId and productUid is :productUid and eocLevel is :eocLevel and cloudMappingType is :cloudMappingType and productName is :productName and eocId is :eocId and intgId is :intgId");
				tQ.setParameter("tenantId", pTenantId);
				tQ.setParameter("productUid", pUid);
				tQ.setParameter("eocLevel", pLevel);
				tQ.setParameter("cloudMappingType", cloudMappingType);
				tQ.setParameter("productName", productName);
				tQ.setParameter("eocId", pEocId);
				tQ.setParameter("intgId", intgId);
				tQ.executeUpdate();
				log.info("刪除云地映射運營配置資料:" + " 租戶 = " + pTenantId + ", 產品主機 = " + pUid + ", 層級 = " + cloudMappingType + ", eoc = "
						+ pEocId + ", om = " + intgId + ",  eocLevel=" + pLevel + ",  prodName=" + productName);
				return null;
			}
		});
	}

	@Override
	public void deleteCloudMapping(String pTenantId, String pProductUid, String pLevel,String cloudMappingType,String productName) {
		getHibernateTemplate().execute(new HibernateCallback<EocIntgMapping>() {
			@Override
			public EocIntgMapping doInHibernate(Session pSession) throws HibernateException {
				Query tQ;
					tQ = pSession.createQuery(
							"delete EocIntgMapping where tenantId is :tenantId and productUid is :productUid and eocLevel is :eocLevel and cloudMappingType is :cloudMappingType and productName is :productName");
					tQ.setParameter("tenantId", pTenantId);
					tQ.setParameter("productUid", pProductUid);
					tQ.setParameter("eocLevel", pLevel);
					tQ.setParameter("cloudMappingType", cloudMappingType);
					tQ.setParameter("productName", productName);
					tQ.executeUpdate();
					log.info("刪除運營配置資料:" + " 租戶 = " + pTenantId + ", 產品主機 = " + pProductUid + ", 層級 = " + cloudMappingType +", eocLevel=" + pLevel);
				return null;
			}
		});
	}

	@Override
	public void deleteMappingByTenantId(final String pTenantId) {
		getHibernateTemplate().execute(new HibernateCallback<EocIntgMapping>() {
			@Override
			public EocIntgMapping doInHibernate(Session pSession) throws HibernateException {
				Query tQ;
				tQ = pSession.createQuery("delete EocIntgMapping where tenantId is :tenantId");
				tQ.setParameter("tenantId", pTenantId);
				tQ.executeUpdate();
				log.info("刪除租戶所有運營配置資料:" + " 租戶 = " + pTenantId);
				// 清除此運應清單對應租戶的運營清單快取
				cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_dispatch_cachemap.getCode() + MdcSymbolConstant.COLON + pTenantId+ MdcSymbolConstant.ASTERISK_SYMBOL);
				cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_operation_cachemap.getCode() + MdcSymbolConstant.COLON + pTenantId + MdcSymbolConstant.ASTERISK_SYMBOL);
				cacheService.removeByPattern(CacheMapTypeEnum.om_tenant_cachemap.getCode() + MdcSymbolConstant.ASTERISK_SYMBOL);

				String tKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + MdcSymbolConstant.COLON + pTenantId;
				cacheService.remove(tKey);
				log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "清除快取(租戶的整個產品清單)：" + "key = " + tKey);
				log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "清除快取(租戶的整個產品清單)：" + "tenant = "
						+ pTenantId);
				return null;
			}
		});
	}
}
