package com.digiwin.metadatacache.dao.impl;

import java.util.List;
import java.util.Map;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.digiwin.metadatacache.dao.GlobalParamsDao;
import com.digiwin.metadatacache.model.GlobalParam;

@Service
@Transactional("mdcTransactionManager")
public class GlobalParamsDaoImpl extends GenericDaoImpl<GlobalParam, Long> implements GlobalParamsDao {

	public GlobalParamsDaoImpl() {
		super(GlobalParam.class);
	}

	// 查詢資料
	@SuppressWarnings("unchecked")
	@Override
	public List<GlobalParam> fetch(Map<String, String> pConditions) {
		return getHibernateTemplate().execute(new HibernateCallback<List<GlobalParam>>() {
			@Override
			public List<GlobalParam> doInHibernate(Session pSession) throws HibernateException {
				// Hibernate - Criteria Query 標準查詢
				Criteria tCriteria = pSession.createCriteria(GlobalParam.class);
				tCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
				// 設查詢條件
				// containsKey - boolean containsKey(Object key) 判斷map是否包含指定的key
				// MatchMode.ANYWHERE 等同於 like="%name%"
				if (pConditions.containsKey("tenant_id")) {
					tCriteria.add(Restrictions.eq("tenantId", pConditions.get("tenant_id")));
				}
				return tCriteria.list();
			}
		});
	}
}
