package com.digiwin.metadatacache.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 异常枚举类
 */
public enum ErrorCodeEnum {

	JSON_SYNTAX_EXCEPTION("100","P.ESP-MDC.100.0100"),

	FORMAT_ERROR("101","P.ESP-MDC.100.0101"),

	API_NAME_NOT_EXIT("201","P.ESP-MDC.200.0201"),

	API_METADATA_NOT_FOUND("202","P.ESP-MDC.200.0202"),

	API_VER_NOT_FOUND("203","P.ESP-MDC.200.0203"),

	CUSTOM_API_NO_TENANT_ID("204","P.ESP-MDC.200.0204"),

	TOKEN_NOT_RETRIEVED("205","P.ESP-MDC.200.0205"),

	OMINFO_RETRIEVED_FAILED("206","P.ESP-MDC.200.0206"),

	APP_VER_NOT_FOUND("207","P.ESP-MDC.200.0207"),

	TENANT_ID_NOT_FOUND("208","P.ESP-MDC.200.0208"),

	USER_ROLE_NOT_RETRIEVED("209","P.ESP-MDC.200.0209"),

	TENANT_TYPE_NOT_RETRIEVED("210","P.ESP-MDC.200.0210"),

	EOC_ENTERPRISE_INFO_NOT_RETRIEVED("211","P.ESP-MDC.200.0211"),

	EOC_COMPANY_INFO_NOT_RETRIEVED("212","P.ESP-MDC.200.0212"),

	EOC_SITE_INFO_NOT_RETRIEVED("213","P.ESP-MDC.200.0213"),

    ADD_PRODUCT_INFO_REQUEST_NOT_EXIT("214","P.ESP-MDC.200.0214"),

    ADD_PRODUCT_INFO_NOT_FOUND("215","P.ESP-MDC.200.0215"),

    USER_INFO_NOT_RETRIEVED("216","P.ESP-MDC.200.0216"),

    TENANT_RELATION_ALREADY_EXISTS("217","P.ESP-MDC.200.0217"),

    PARAM_FORMAT_ERROR("218", "P.ESP-MDC.200.0218"),

	PROD_TYPE_NOT_FOUND("301","P.ESP-MDC.300.0301"),

    PARENT_API_RELATION_IS_EXIT("304","P.ESP-MDC.300.0304"),

	UPDATE_EOC_FAILED("310","P.ESP-MDC.300.0310"),

	DELETE_COMPANY_EOC_FAILED("311","P.ESP-MDC.300.0311"),

	UNEXPECTED_ERROR("999","P.ESP-MDC.900.0999"),

	EOC_FAILED("601","P.ESP-MDC.600.0601"),

    MULTIPLE_PRODUCT_ERR("320","P.ESP-MDC.300.0320"),

    KG_FAILED("603","P.ESP-MDC.600.0603"),
    ;

    /**
     * 异常码
     */
    private final String code;

    /**
     * 新定义的异常码
     */
    private final String errorCode;

    /**
     * 异常码映射MAP
     */
    public static final Map<String, ErrorCodeEnum> ERRORCODEENUM_CODE_MAP = new HashMap<>();

    static {
        for (ErrorCodeEnum tEnum : values()) {
            ERRORCODEENUM_CODE_MAP.put(tEnum.getCode(), tEnum);
        }
    }

    ErrorCodeEnum(String code, String errorCode) {
        this.code = code;
        this.errorCode = errorCode;
    }

    public String getCode() {
        return code;
    }

    public String getErrorCode() {
        return errorCode;
    }
}
