package com.digiwin.metadatacache.exception;

import com.digiwin.metadatacache.enums.ValidateStateEnum;

/**
 * 新增关联关系时-父类API绑定关系已存在
 */
public class ParentApiRelationExistException extends BaseException {

	private static final long serialVersionUID = 1L;

	final private static ValidateStateEnum VALIDATE_STATE_ENUM = ValidateStateEnum.PARENT_API_RELATION_IS_EXIT;

	public ParentApiRelationExistException(Class<?> pClazz) {
		super(pClazz, VALIDATE_STATE_ENUM);
	}

	public ParentApiRelationExistException(String pExceptionMsg, Class<?> pClazz) {
		super(pExceptionMsg, pClazz, VALIDATE_STATE_ENUM);
	}

	public ParentApiRelationExistException(Throwable pSrcException, Class<?> pClazz) {
		super(pSrcException, pClazz, VALIDATE_STATE_ENUM);
	}

	public ParentApiRelationExistException(String pExceptionMsg, Throwable pSrcException, Class<?> pClazz) {
		super(pExceptionMsg, pSrcException, pClazz, VALIDATE_STATE_ENUM);
	}
}