package com.digiwin.metadatacache.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 * The persistent class for the standard_api database table.
 *
 */
@Entity
@Table(name = "api")
public class Api implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	@Column(name = "invoked_count")
	private Long invoked_count;

	@Column(name = "name")
	private String name;

	@Column(name = "invoked_type")
	private String invokedType;

	@Column(name = "api_type")
	private String api_type;

	@Column(name = "provider")
	private String provider;

	@Column(name = "url")
	private String url;

	@Column(name = "description_zh_tw")
	private String descriptionZhTw;

	@Column(name = "description_zh_cn")
	private String descriptionZhCn;

	@Column(name = "description_en")
	private String descriptionEn;

	@Column(name = "remark_zh_tw")
	private String remarkZhTw;

	@Column(name = "remark_zh_cn")
	private String remarkZhCn;

	@Column(name = "remark_en")
	private String remarkEn;

	@Column(name = "category")
	private String category;

	@Column(name = "build_time")
	private Calendar buildTime;

	@Column(name = "tenant_id")
	private String tenantId;

	@Column(name = "package_name")
	private String packageName;

	@Column(name = "api_extend")
	private String apiExtend;

	public String getApiExtend() {
		return apiExtend;
	}

	public void setApiExtend(String apiExtend) {
		this.apiExtend = apiExtend;
	}

	public String getPackageName() {
		return packageName;
	}

	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	@OneToMany(mappedBy = "Api", cascade = CascadeType.ALL, fetch = FetchType.EAGER)
	private List<ApiVersion> apiVersions = new ArrayList<>();

	public Api() {
	}

	public Long getId() {
		return this.id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getInvokedType() {
		return invokedType;
	}

	public void setInvokedType(String type) {
		this.invokedType = type;
	}

	public Long getInvoked_count() {
		return invoked_count;
	}

	public void setInvoked_count(Long invoked_count) {
		this.invoked_count = invoked_count;
	}

	public Calendar getBuildTime() {
		return this.buildTime;
	}

	public void setBuildTime(Calendar buildTime) {
		this.buildTime = buildTime;
	}

	public String getDescriptionZhCn() {
		return this.descriptionZhCn;
	}

	public void setDescriptionZhCn(String descriptionZhCn) {
		this.descriptionZhCn = descriptionZhCn;
	}

	public String getDescriptionZhTw() {
		return this.descriptionZhTw;
	}

	public void setDescriptionZhTw(String descriptionZhTw) {
		this.descriptionZhTw = descriptionZhTw;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getRemarkZhCn() {
		return this.remarkZhCn;
	}

	public void setRemarkZhCn(String remarkZhCn) {
		this.remarkZhCn = remarkZhCn;
	}

	public String getRemarkZhTw() {
		return this.remarkZhTw;
	}

	public void setRemarkZhTw(String remarkZhTw) {
		this.remarkZhTw = remarkZhTw;
	}

	public String getDescriptionEn() {
		return descriptionEn;
	}

	public void setDescriptionEn(String descriptionEn) {
		this.descriptionEn = descriptionEn;
	}

	public String getRemarkEn() {
		return remarkEn;
	}

	public void setRemarkEn(String remarkEn) {
		this.remarkEn = remarkEn;
	}

	public String getApi_type() {
		return api_type;
	}

	public void setApi_type(String api_type) {
		this.api_type = api_type;
	}

	public String getProvider() {
		return provider;
	}

	public void setProvider(String provider) {
		this.provider = provider;
	}

	public String getCategory() {
		return category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public ApiVersion addApiVersion(ApiVersion apiVersion) {
		getApiVersions().add(apiVersion);
		apiVersion.setApi(this);
		return apiVersion;
	}

	public List<ApiVersion> getApiVersions() {
		return this.apiVersions;
	}

	public void setApiVersions(List<ApiVersion> apiVersions) {
		this.apiVersions = apiVersions;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

}