package com.digiwin.metadatacache.model;


import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

@Entity
@Table(name = "api_relation")
public class ApiRelation implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键Id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 父类api名称
     */
    @Column(name = "parent_api_name")
    private String parentApiName;

    /**
     * 子类api名称
     */
    @Column(name = "sub_api_name")
    private String subApiName;

    /**
     * 子类api租户Id
     */
    @Column(name = "sub_tenant_id")
    private String subTenantId;

    /**
     * 创建时间
     */
    @Column(name = "build_time")
    private LocalDateTime buildTime;

    /**
     * 创建人
     */
    @Column(name = "create_id")
    private String createId;

    /**
     * 更新时间
     */
    @Column(name = "update_time")
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    @Column(name = "update_id")
    private String updateId;

    /**
     * 删除标识 0:未删除，1:已删除
     */
    @Column(name = "delete_flag")
    private Integer deleteFlag = 0;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getParentApiName() {
        return parentApiName;
    }

    public void setParentApiName(String parentApiName) {
        this.parentApiName = parentApiName;
    }

    public String getSubApiName() {
        return subApiName;
    }

    public void setSubApiName(String subApiName) {
        this.subApiName = subApiName;
    }

    public String getSubTenantId() {
        return subTenantId;
    }

    public void setSubTenantId(String subTenantId) {
        this.subTenantId = subTenantId;
    }

    public LocalDateTime getBuildTime() {
        return buildTime;
    }

    public void setBuildTime(LocalDateTime buildTime) {
        this.buildTime = buildTime;
    }

    public String getCreateId() {
        return createId;
    }

    public void setCreateId(String createId) {
        this.createId = createId;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateId() {
        return updateId;
    }

    public void setUpdateId(String updateId) {
        this.updateId = updateId;
    }

    public Integer getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(Integer deleteFlag) {
        this.deleteFlag = deleteFlag;
    }
}
