package com.digiwin.metadatacache.model;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 查询方案
 */
@Entity
@Data
@Table(name = "asset_data_query")
public class AssetDataQuery implements Serializable {

    /**
     * 主键Id
     */
    @Id
    private Long id;

    /**
     * 查询方案编号
     */
    @Column(name = "code")
    private String code;

    /**
     * 查询方案名称
     */
    @Column(name = "name")
    private String name;

    /**
     * 查询方案内容
     */
    @Column(name = "playground")
    private String playground;

    /**
     * 模型ID
     */
    @Column(name = "model_id")
    private Long modelId;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private LocalDateTime createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private String createBy;

    /**
     * 更新呢时间
     */
    @Column(name = "modified_date")
    private LocalDateTime modifiedDate;

    /**
     * 更改人
     */
    @Column(name = "modified_by")
    private String modifiedBy;
}
