package com.digiwin.metadatacache.model;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 数据标准-标准辞汇
 */
@Entity
@Data
@Table(name = "asset_standard_word_dictionary")
public class AssetStandardWordDictionary implements Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 辞汇名称
     */
    @Column(name = "data_name")
    private String dataName;

    /**
     * 辞汇描述
     */
    @Column(name = "description_zh_tw")
    private String descriptionZhTw;

    /**
     * 辞汇描述
     */
    @Column(name = "description_zh_cn")
    private String descriptionZhCn;

    /**
     * 辞汇描述
     */
    @Column(name = "description_en_us")
    private String descriptionEnUs;

    /**
     * 关联业务类型id
     */
    @Column(name = "relate_business_type_id")
    private Long relateBusinessTypeId;

    /**
     * 关联下拉辞汇id
     */
    @Column(name = "relate_dictionary_id")
    private Long relateDictionaryId;

    /**
     * 相似词
     */
    @Column(name = "likeness_word")
    private String likenessWord;

    /**
     * 标准(Y标准,N非标)
     */
    @Column(name = "standard")
    private String standard;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private LocalDateTime createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private String createBy;

    /**
     * 更新呢时间
     */
    @Column(name = "modified_date")
    private LocalDateTime modifiedDate;

    /**
     * 更改人
     */
    @Column(name = "modified_by")
    private String modifiedBy;
}
