package com.digiwin.metadatacache.model;

import java.io.Serializable;
import java.util.Calendar;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * The persistent class for the standard_api database table.
 * 
 */
@Entity
@Table(name = "product")
public class Product implements Serializable {

	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	private String name;

	private String version;

	@Column(name = "gateway_id")
	private String gatewayId;

	@Column(name = "tenant_id")
	private String tenantId;

	@Column(name = "eai_uid")
	private String eaiUid;

	@Column(name = "build_time")
	private Calendar buildTime;

	@Column(name = "last_update_time")
	private Calendar lastUpdateTime;

	@Column(name = "ip")
	private String ip;

	@Column(name = "apid")
	private String apid;

	@Column(name = "uid")
	private String uid;

	@Column(name = "product_type")
	private String productType;

	@Column(name = "eoc_setting")
	private String eocSetting;

	@Column(name = "eoc_setting_region")
	private String eocSettingRegion;

	@Column(name = "url")
	private String url;

	@Column(name = "setting_eoc_flag")
	private Integer settingEocFlag = 0;

	@Column(name = "app_id")
	private String appId;

	public Product() {
	}

	public Long getId() {
		return this.id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getVersion() {
		return version;
	}

	public String getEaiUid() {
		return eaiUid;
	}

	public void setEaiUid(String eaiUid) {
		this.eaiUid = eaiUid;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public String getGatewayId() {
		return gatewayId;
	}

	public void setGatewayId(String gatewayId) {
		this.gatewayId = gatewayId;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	public Calendar getBuildTime() {
		return buildTime;
	}

	public void setBuildTime(Calendar buildTime) {
		this.buildTime = buildTime;
	}

	public Calendar getLastUpdateTime() {
		return lastUpdateTime;
	}

	public void setLastUpdateTime(Calendar lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}

	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public String getApid() {
		return apid;
	}

	public void setApid(String apid) {
		this.apid = apid;
	}

	public String getUid() {
		return uid;
	}

	public void setUid(String uid) {
		this.uid = uid;
	}

	public String getProductType() {
		return productType;
	}

	public void setProductType(String productType) {
		this.productType = productType;
	}

	public String getEocSetting() {
		return eocSetting;
	}

	public void setEocSetting(String eocSetting) {
		this.eocSetting = eocSetting;
	}

	public String getEocSettingRegion() {
		return eocSettingRegion;
	}

	public void setEocSettingRegion(String eocSettingRegion) {
		this.eocSettingRegion = eocSettingRegion;
	}

	public Integer getSettingEocFlag() {
		return settingEocFlag;
	}

	public void setSettingEocFlag(Integer settingEocFlag) {
		this.settingEocFlag = settingEocFlag;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}
}