package com.digiwin.metadatacache.services;

import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.dao.PrdDatakeyMappingDao;
import com.digiwin.metadatacache.dao.ProductApiDispatchInfoDao;
import com.digiwin.metadatacache.enums.EocLevelEnum;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.PrdDatakeyMapping;
import com.digiwin.metadatacache.model.ProductApiDispatchInfo;
import com.digiwin.metadatacache.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: liunansheng
 * @date: 2024/7/23 13:54
 */
@Service
public class DispatchService {

    @Autowired
    private ProductApiDispatchInfoDao productApiDispatchInfoDao;

    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;

    @Autowired
    private PrdDatakeyMappingDao prdDatakeyMappingDao;

    public boolean isCanDispatch(String tProdName, String tApiName) {
        Map<String, String> tProductApiDispatchCondition = new HashMap<>();
        tProductApiDispatchCondition.put(MdcConstant.PROD_NAME, tProdName);
        tProductApiDispatchCondition.put(MdcConstant.API_NAME, tApiName);
        List<ProductApiDispatchInfo> productApiDispatchInfos = productApiDispatchInfoDao.fetch(tProductApiDispatchCondition);
        if (CollectionUtils.isNotEmpty(productApiDispatchInfos)) {
            return true;
        }
        return false;
    }

    public List<Map<String, Object>> getDispatch(String tTenantId, String tProdName) {
        Map<String, String> pEocIntgMapCondition = new HashMap<>();
        pEocIntgMapCondition.put(MdcConstant.TENANT_ID, tTenantId);
        pEocIntgMapCondition.put(MdcConstant.PRODUCT_NAME, tProdName);
        List<EocIntgMapping> eocIntgMappings = eocIntgMappingDao.fetch(pEocIntgMapCondition);
        if (CollectionUtils.isEmpty(eocIntgMappings)) {
            return null;
        }
        // 先將eoc intg mappings轉換成map
        Map<String, Map<String, Map<String, List<EocIntgMapping>>>> tTotalMap = groupEocMappingByTenantAndProdNameAndUid(eocIntgMappings, tTenantId);
        // 決定dispatch深度
        int dispatchLevel = 0;
        Map<String, String> tCondition = new HashMap<>();
        tCondition.put(MdcConstant.PROD_NAME, tProdName);
        List<PrdDatakeyMapping> tDatakeyMappings = prdDatakeyMappingDao.fetch(tCondition);
        if (CollectionUtils.isNotEmpty(tDatakeyMappings)) {
            for (PrdDatakeyMapping tDatakeyMapping : tDatakeyMappings) {
                if (tDatakeyMapping.getEocLevel().equals(EocLevelEnum.site_id.toString())) {
                    dispatchLevel = 1;
                } else if (tDatakeyMapping.getEocLevel().equals(EocLevelEnum.region_id.toString())) {
                    dispatchLevel = 2;
                }
            }
        }
        List<Map<String, Object>> tDispatchAryNode = new ArrayList<>();
        // 如果沒有找到任何對應關係,則"dispatch":[]

        for (String key : tTotalMap.get(tTenantId).get(tProdName).keySet()) {
            // 每台主機(UID)
            boolean tMappingsNoDatakeyValue = true;
            // 每台主機(UID)上的每個運營單元對應
            for (EocIntgMapping mapping : tTotalMap.get(tTenantId).get(tProdName).get(key)) {
                Map<String, Object> tDispatchItemNode = new HashMap<>();
                if (!StringUtil.isEmptyOrSpace(mapping.getDatakey())) {
                    // 填上service_product物件
                    Map<String, Object> tServiceProductNode = new HashMap<>();
                    tDispatchItemNode.put(MdcConstant.SERVICE_PRODUCT, tServiceProductNode);
                    tServiceProductNode.put(MdcConstant.NAME, mapping.getProducName());
                    tServiceProductNode.put(MdcConstant.UID, mapping.getProductUid());
                    Map<String, Object> tOperationManagerNode = new HashMap<>();
                    if (mapping.getEocLevel().equals(EocLevelEnum.company_id.toString())
                            && dispatchLevel == 0) {
                        // 同一個uid下，有datakey的eoc_intg_mapping才能dispatch
                        tDispatchAryNode.add(tDispatchItemNode);
                        tOperationManagerNode.put(MdcConstant.EOC_COMPANY_ID, mapping.getEocId());
                    } else if (mapping.getEocLevel().equals(EocLevelEnum.site_id.toString())
                            && dispatchLevel == 1) {
                        // 同一個uid下，有datakey的eoc_intg_mapping才能dispatch
                        tDispatchAryNode.add(tDispatchItemNode);
                        if (mapping.getEocIntgMapping() != null) {
                            tOperationManagerNode.put(MdcConstant.EOC_COMPANY_ID,
                                    mapping.getEocIntgMapping().getEocId());
                        }
                        tOperationManagerNode.put(MdcConstant.EOC_SITE_ID, mapping.getEocId());
                    } else if (mapping.getEocLevel().equals(EocLevelEnum.region_id.toString())
                            && dispatchLevel == 2) {
                        // 同一個uid下，有datakey的eoc_intg_mapping才能dispatch
                        tDispatchAryNode.add(tDispatchItemNode);
                        if (mapping.getEocIntgMapping() != null) {
                            if (mapping.getEocIntgMapping().getEocIntgMapping() != null) {
                                tOperationManagerNode.put(MdcConstant.EOC_COMPANY_ID,
                                        mapping.getEocIntgMapping().getEocIntgMapping().getEocId());
                            }
                            tOperationManagerNode.put(MdcConstant.EOC_SITE_ID, mapping.getEocIntgMapping().getEocId());
                        }
                        tOperationManagerNode.put(MdcConstant.EOC_REGION_ID, mapping.getEocId());
                    }
                    tDispatchItemNode.put(MdcConstant.OPERATION_MANAGER, tOperationManagerNode);
                    tMappingsNoDatakeyValue = false;
                }
            }
            // 如果都沒有datakey則dispatch此prod uid一次即可
            if (tMappingsNoDatakeyValue) {
                // 填上service_product物件
                Map<String, Object> tDispatchItemNode = new HashMap<>();
                Map<String, Object> tServiceProductNode = new HashMap<>();
                tDispatchItemNode.put(MdcConstant.SERVICE_PRODUCT, tServiceProductNode);
                tServiceProductNode.put(MdcConstant.NAME,
                        tTotalMap.get(tTenantId).get(tProdName).get(key).get(0).getProducName());
                tServiceProductNode.put(MdcConstant.UID,
                        tTotalMap.get(tTenantId).get(tProdName).get(key).get(0).getProductUid());
                tDispatchAryNode.add(tDispatchItemNode);
            }
        }
        return tDispatchAryNode;
    }

    public List<Map<String, Object>> getDispatchV2(String tTenantId, String tProdName) {
        Map<String, String> pEocIntgMapCondition = new HashMap<>();
        pEocIntgMapCondition.put(MdcConstant.TENANT_ID, tTenantId);
        pEocIntgMapCondition.put(MdcConstant.PRODUCT_NAME, tProdName);
        //v2 查询逻辑
        pEocIntgMapCondition.put(MdcConstant.EOC_LEVEL, MdcConstant.CLOUD_MAPPING_ID);
        List<EocIntgMapping> eocIntgMappings = eocIntgMappingDao.fetch(pEocIntgMapCondition);
        if (CollectionUtils.isEmpty(eocIntgMappings)) {
            return null;
        }
        // 先將eoc intg mappings轉換成map
        Map<String, Map<String, Map<String, List<EocIntgMapping>>>> tTotalMap = groupEocMappingByTenantAndProdNameAndUid(eocIntgMappings, tTenantId);
        // 決定dispatch深度
        int dispatchLevel = 0;
        Map<String, String> tCondition = new HashMap<>();
        tCondition.put(MdcConstant.PROD_NAME, tProdName);
        List<PrdDatakeyMapping> tDatakeyMappings = prdDatakeyMappingDao.fetch(tCondition);
        if (CollectionUtils.isNotEmpty(tDatakeyMappings)) {
            for (PrdDatakeyMapping tDatakeyMapping : tDatakeyMappings) {
                if (tDatakeyMapping.getEocLevel().equals(EocLevelEnum.site_id.toString())) {
                    dispatchLevel = 1;
                } else if (tDatakeyMapping.getEocLevel().equals(EocLevelEnum.region_id.toString())) {
                    dispatchLevel = 2;
                }
            }
        }
        List<Map<String, Object>> tDispatchAryNode = new ArrayList<>();
        // 如果沒有找到任何對應關係,則"dispatch":[]

        for (String key : tTotalMap.get(tTenantId).get(tProdName).keySet()) {
            // 每台主機(UID)
            boolean tMappingsNoDatakeyValue = true;
            // 每台主機(UID)上的每個運營單元對應
            for (EocIntgMapping mapping : tTotalMap.get(tTenantId).get(tProdName).get(key)) {
                Map<String, Object> tDispatchItemNode = new HashMap<>();
                if (!StringUtil.isEmptyOrSpace(mapping.getDatakey())) {
                    // 填上service_product物件
                    Map<String, Object> tServiceProductNode = new HashMap<>();
                    tDispatchItemNode.put(MdcConstant.SERVICE_PRODUCT, tServiceProductNode);
                    tServiceProductNode.put(MdcConstant.NAME, mapping.getProducName());
                    tServiceProductNode.put(MdcConstant.UID, mapping.getProductUid());
                    Map<String, Object> tOperationManagerNode = new HashMap<>();
                    if (mapping.getCloudMappingType().equals(EocLevelEnum.company_id.toString())
                            && dispatchLevel == 0) {
                        // 同一個uid下，有datakey的eoc_intg_mapping才能dispatch
                        tDispatchAryNode.add(tDispatchItemNode);
                        tOperationManagerNode.put(MdcConstant.EOC_MAPPING_ID, mapping.getEocId());
                        tOperationManagerNode.put(MdcConstant.MAPPING_TYPE, mapping.getCloudMappingType());
                    } else if (mapping.getCloudMappingType().equals(EocLevelEnum.site_id.toString())
                            && dispatchLevel == 1) {
                        // 同一個uid下，有datakey的eoc_intg_mapping才能dispatch
                        tDispatchAryNode.add(tDispatchItemNode);
                        tOperationManagerNode.put(MdcConstant.EOC_MAPPING_ID, mapping.getEocId());
                        tOperationManagerNode.put(MdcConstant.MAPPING_TYPE, mapping.getCloudMappingType());
                    } else if (mapping.getCloudMappingType().equals(EocLevelEnum.region_id.toString())
                            && dispatchLevel == 2) {
                        // 同一個uid下，有datakey的eoc_intg_mapping才能dispatch
                        tDispatchAryNode.add(tDispatchItemNode);
                        tOperationManagerNode.put(MdcConstant.EOC_MAPPING_ID, mapping.getEocId());
                        tOperationManagerNode.put(MdcConstant.MAPPING_TYPE, mapping.getCloudMappingType());
                    }
                    tDispatchItemNode.put(MdcConstant.OPERATION_MANAGER, tOperationManagerNode);
                    tMappingsNoDatakeyValue = false;
                }
            }
            // 如果都沒有datakey則dispatch此prod uid一次即可
            if (tMappingsNoDatakeyValue) {
                // 填上service_product物件
                Map<String, Object> tDispatchItemNode = new HashMap<>();
                Map<String, Object> tServiceProductNode = new HashMap<>();
                tDispatchItemNode.put(MdcConstant.SERVICE_PRODUCT, tServiceProductNode);
                tServiceProductNode.put(MdcConstant.NAME,
                        tTotalMap.get(tTenantId).get(tProdName).get(key).get(0).getProducName());
                tServiceProductNode.put(MdcConstant.UID,
                        tTotalMap.get(tTenantId).get(tProdName).get(key).get(0).getProductUid());
                tDispatchAryNode.add(tDispatchItemNode);
            }
        }
        return tDispatchAryNode;
    }

    /**
     * 將運營單元對應依照租戶ID、產品名稱與產品UID分群
     */
    public Map<String, Map<String, Map<String, List<EocIntgMapping>>>> groupEocMappingByTenantAndProdNameAndUid(
            List<EocIntgMapping> pEocIntgMappings, String pTenantId) {
        // 總map
        Map<String, Map<String, Map<String, List<EocIntgMapping>>>> tTotalMap = new HashMap<>();
        for (EocIntgMapping mapping : pEocIntgMappings) {
            // 第一層key: 租戶ID
            Map<String, Map<String, List<EocIntgMapping>>> tProductNameMap = tTotalMap.get(pTenantId);
            if (MapUtils.isEmpty(tProductNameMap)) {
                // 建立一個此租戶的產品名稱 Map
                tProductNameMap = new HashMap<>();
                tTotalMap.put(pTenantId, tProductNameMap);
            }
            // 第二層key: 產品名稱
            Map<String, List<EocIntgMapping>> tProductUidMap = tProductNameMap.get(mapping.getProducName());
            if (MapUtils.isEmpty(tProductUidMap)) {
                // 建立一個此產品名稱的產品UID Map
                tProductUidMap = new HashMap<>();
                tProductNameMap.put(mapping.getProducName(), tProductUidMap);
            }
            // 第三層key: 產品UID
            List<EocIntgMapping> tEocIntgMappingList = tProductUidMap.get(mapping.getProductUid());
            if (CollectionUtils.isEmpty(tEocIntgMappingList)) {
                // 建立產品UID的EOC對應清單
                tEocIntgMappingList = new ArrayList<>();
                tProductUidMap.put(mapping.getProductUid(), tEocIntgMappingList);
            }
            tEocIntgMappingList.add(mapping);
        }
        return tTotalMap;
    }
}
