package com.digiwin.metadatacache.util;

import java.text.SimpleDateFormat;
import java.util.Date;

public class DateUtil {

    /**
     * 时间格式 yyyyMMddHHmmssSSS
     */
    public static final String DATE_FORMAT = "yyyyMMddHHmmssSSS";

    public static final String FORMAT_TO_SECOND = "yyyy-MM-dd HH:mm:ss";

    /**
     * 时间格式转换
     *
     * @param date date
     * @return String
     */
    public static String formatToDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        return df.format(date);
    }

    /**
     * 时间格式转换
     *
     * @param date date
     * @return String
     */
    public static String formatToSecond(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_TO_SECOND);
        return df.format(date);
    }
}
