package com.digiwin.metadatacache.util;

import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.services.EocInfoService;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class EocInfoServiceUtil extends GenericServiceUtil<EocInfoService> {

    private static EocInfoService service;

    @Override
    @Autowired
    public void setService(EocInfoService pService) {
        service = pService;
    }

    public static ObjectNode getEocInfoByTenantId(String pTenantId) throws Exception {
        return service.getEocInfoByTenantId(pTenantId);
    }

    public static ObjectNode getEocInfoByUserToken(String pToken) throws Exception {
        return service.getEocInfoByUserToken(pToken);
    }

    public static ObjectNode getEocInfoV2ByTenantId(String pTenantId) throws Exception {
        return service.getEocInfoV2ByTenantId(pTenantId);
    }

    public static ObjectNode getEocInfoV2ByUserToken(String pToken) throws Exception {
        return service.getEocInfoV2ByUserToken(pToken);
    }

    public static Map<String, String> getEocInfoV2MapByUserToken(String pToken) throws Exception {
        ObjectNode tEocInfoNode = service.getEocInfoV2ByUserToken(pToken);
        return getEocIdMapping(tEocInfoNode);
    }

    public static Map<String, String> getEocInfoV2MapByTenantId(String pTenantId) throws Exception {
        ObjectNode tEocInfoNode = service.getEocInfoV2ByTenantId(pTenantId);
        return getEocIdMapping(tEocInfoNode);
    }

    private static Map<String, String> getEocIdMapping(ObjectNode tEocInfoNode) {
        Map<String, String> eocIdMapping = new HashMap<>();
        ObjectNode tEocDataNode = (ObjectNode) tEocInfoNode.get(MdcConstant.DATA);
        ArrayNode tEocListNode = (ArrayNode) tEocDataNode.get(MdcConstant.LIST);
        tEocListNode.forEach(jsonNode -> eocIdMapping.put(jsonNode.get(MdcConstant.ID).asText(), jsonNode.get(MdcConstant.NAME).asText()));
        return eocIdMapping;
    }

    public static String updateEocEntry(String pSid, String pEocId, String pToken, int pLevel, int pTypeSid,
                                 String pParentSid, int pState) throws Exception {
        return service.updateEocEntry(pSid, pEocId, pToken, pLevel, pTypeSid, pParentSid, pState);
    }

    public static String getEnterPriseSid(String pToken) throws Exception {
        return service.getEnterPriseSid(pToken);
    }

    public static String getCompanySid(String pToken, String pEocId) throws Exception {
        return service.getCompanySid(pToken, pEocId);
    }
}
