/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.ApiVersionDao;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.ApiVersion;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.services.LoadCacheService;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiBaseInfoGetService
extends AbstractApiService {
    @Autowired
    private ApiVersionDao apiVersionDao;
    @Autowired
    protected LoadCacheService loadCacheService;

    public ApiBaseInfoGetService() {
        this.jsonSchemaFileName = "api_base_info_get.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        ObjectNode tDataNode = this.mapper.createObjectNode();
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        String apiName = tRequestJsonNode.get("api_name").asText();
        String tenantId = tRequestJsonNode.get("tenant_id").asText();
        String key = CacheMapTypeEnum.api_base_info_cachemap.getCode() + ":" + apiName;
        ObjectNode data = this.loadCacheService.getData(key, tenantId);
        if (null == data) {
            ApiVersion apiVersion = this.getBaseInfo(apiName, tenantId);
            if (null != apiVersion) {
                tDataNode.put("api_name", apiName);
                tDataNode.put("tenant_id", apiVersion.getApi().getTenantId());
                tDataNode.put("idempotency", apiVersion.isIdempotency());
                tDataNode.put("version", apiVersion.getVersion());
                tDataNode.put("approved_status", apiVersion.getApprovedStatus());
                this.log.info((Object)(key + ": " + tDataNode.toString()));
                this.loadCacheService.saveData(key, tenantId, tDataNode);
                this.log.info((Object)("\u7f13\u5b58\u5b58\u5165: " + key + ":" + tenantId));
            }
        } else {
            this.log.info((Object)("\u7f13\u5b58\u68c0\u7d22\u6210\u529f: " + key + ":" + tenantId));
            tDataNode = data;
        }
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, (JsonNode)tDataNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    protected ApiVersion getBaseInfo(String apiName, String tenantId) {
        List<ApiVersion> apiVersionList = this.apiVersionDao.getBaseInfoByApiNameAndTenantId(apiName, tenantId);
        if (CollectionUtils.isNotEmpty(apiVersionList)) {
            List<ApiVersion> apiVersions = apiVersionList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getApi().getTenantId()) && tenantId.equals(x.getApi().getTenantId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(apiVersions)) {
                return this.getLastedVersion(apiVersions);
            }
            return this.getLastedVersion(apiVersionList);
        }
        return null;
    }
}

