/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.ApiDao;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.Api;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiProviderGetService
extends AbstractApiService {
    @Autowired
    private ApiDao apiDao;

    public ApiProviderGetService() {
        this.jsonSchemaFileName = "api_provider_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        String tApiName = tRequestJsonNode.get("api_name").asText();
        return this.processApiProviderGet(tApiName);
    }

    private Map<String, Object> processApiProviderGet(String pApiName) {
        ObjectNode tDataNode = this.mapper.createObjectNode();
        tDataNode.put("api_name", pApiName);
        ArrayNode tProviderArrayNode = this.mapper.createArrayNode();
        tDataNode.set("provider", (JsonNode)tProviderArrayNode);
        Api tApi = this.apiDao.getByName(pApiName);
        if (tApi != null) {
            String[] tProvidersSplitAry = null;
            String tProviders = tApi.getProvider();
            if (!StringUtil.isEmptyOrSpace(tProviders)) {
                tProvidersSplitAry = tProviders.split(",");
            }
            if (tProvidersSplitAry != null && tProvidersSplitAry.length != 0) {
                for (String tProvider : tProvidersSplitAry) {
                    tProviderArrayNode.add(tProvider);
                }
            }
        }
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, (JsonNode)tDataNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

