/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.ApiDao;
import com.digiwin.metadatacache.dao.ApiRelationDao;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.exception.ApiNameNotExistException;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.exception.ParentApiRelationExistException;
import com.digiwin.metadatacache.exception.TokenNotRetrievedException;
import com.digiwin.metadatacache.model.ApiRelation;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.services.LocalCacheService;
import com.digiwin.metadatacache.util.IamVerifyServiceUtil;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.LocalDateTime;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiRelationSaveService
extends AbstractApiService {
    @Autowired
    private ApiRelationDao apiRelationDao;
    @Autowired
    private LocalCacheService localCacheService;
    @Autowired
    private ApiDao apiDao;

    public ApiRelationSaveService() {
        this.jsonSchemaFileName = "api_relation_save.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        String tToken = (String)DWServiceContext.getContext().getRequestHeader().get("token");
        if (null == tToken) {
            throw new TokenNotRetrievedException(this.getClass());
        }
        String userName = IamVerifyServiceUtil.getUserName(tToken);
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        ArrayNode tApiArrayNode = (ArrayNode)tRequestJsonNode.get("api_info");
        if (tApiArrayNode.isArray()) {
            for (JsonNode tApi : tApiArrayNode) {
                boolean parentApiJudge;
                String parentApiName = tApi.get("parent_api_name").asText();
                String subApiName = tApi.get("sub_api_name").asText();
                String tenantId = null;
                if (null != tApi.get("sub_tenant_id") && !StringUtil.isEmptyOrSpace(tApi.get("sub_tenant_id").asText())) {
                    tenantId = tApi.get("sub_tenant_id").asText();
                }
                if (!(parentApiJudge = this.apiDao.judgeApi(parentApiName, tenantId, true).booleanValue())) {
                    throw new ApiNameNotExistException("\u7236\u7c7bAPI" + parentApiName + "\u4e0d\u5b58\u5728", this.getClass());
                }
                boolean subApiJudge = this.apiDao.judgeApi(subApiName, tenantId, false);
                if (!subApiJudge) {
                    throw new ApiNameNotExistException("\u5b50\u7c7bAPI" + subApiName + "\u4e0d\u5b58\u5728", this.getClass());
                }
                ApiRelation parentApiRelation = this.apiRelationDao.judgeIsSub(parentApiName, tenantId);
                if (null != parentApiRelation) {
                    throw new ParentApiRelationExistException("\u7236\u7c7bAPI" + parentApiName + "\u4f5c\u4e3a\u5b50\u7c7b\u5173\u8054\u5173\u7cfb\u5df2\u5b58\u5728", this.getClass());
                }
                ApiRelation subApiRelation = this.apiRelationDao.judgeIsParent(subApiName, tenantId);
                if (null != subApiRelation) {
                    throw new ParentApiRelationExistException("\u5b50\u7c7bAPI" + subApiName + "\u4f5c\u4e3a\u7236\u7c7b\u5173\u8054\u5173\u7cfb\u5df2\u5b58\u5728", this.getClass());
                }
                this.saveApiRelation(parentApiName, subApiName, tenantId, userName);
            }
        }
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    public void saveApiRelation(String parentApiName, String subApiName, String tenantId, String userName) {
        ApiRelation apiRelation = this.apiRelationDao.getRelationBySubInfo(subApiName, tenantId);
        this.localCacheService.remove(CacheMapTypeEnum.api_relation_idempotency_cachemap, subApiName);
        if (null == apiRelation) {
            apiRelation = new ApiRelation();
            apiRelation.setParentApiName(parentApiName);
            apiRelation.setSubApiName(subApiName);
            apiRelation.setSubTenantId(tenantId);
            apiRelation.setBuildTime(LocalDateTime.now());
            apiRelation.setCreateId(userName);
            this.apiRelationDao.save(apiRelation);
        } else {
            apiRelation.setUpdateTime(LocalDateTime.now());
            apiRelation.setUpdateId(userName);
            apiRelation.setParentApiName(parentApiName);
            this.apiRelationDao.saveOrupdate(apiRelation);
        }
    }
}

