/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.AppSupportVersionDao;
import com.digiwin.metadatacache.exception.AppVerNotFoundException;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.AppSupportVersion;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppSupportListGetService
extends AbstractApiService {
    @Autowired
    private AppSupportVersionDao appSupportVersionDao;

    public AppSupportListGetService() {
        this.jsonSchemaFileName = "app_support_List_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        List<AppSupportVersion> tAppSupportVersionList;
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        String tTenantId = tRequestJsonNode.get("tenant_id").asText();
        String tAppId = null;
        if (tRequestJsonNode.get("appid") != null) {
            tAppId = tRequestJsonNode.get("appid").asText();
        }
        HashMap<String, String> tConditions = new HashMap<String, String>();
        tConditions.put("tenant_id", tTenantId);
        if (tAppId != null) {
            tConditions.put("appid", tAppId);
        }
        if ((tAppSupportVersionList = this.appSupportVersionDao.fetch(tConditions)) == null || tAppSupportVersionList.isEmpty()) {
            throw new AppVerNotFoundException(this.getClass());
        }
        ObjectNode tDataNode = this.mapper.createObjectNode();
        tDataNode.put("tenant_id", tTenantId);
        ArrayNode tVersionAryNode = this.mapper.createArrayNode();
        for (AppSupportVersion tAppSupportVersion : tAppSupportVersionList) {
            ObjectNode tAppVerNode = this.mapper.createObjectNode();
            tAppVerNode.put("appid", tAppSupportVersion.getAppId().trim());
            tAppVerNode.put("version", tAppSupportVersion.getAppVersion().trim());
            tVersionAryNode.add((JsonNode)tAppVerNode);
        }
        tDataNode.set("app_ver", (JsonNode)tVersionAryNode);
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, (JsonNode)tDataNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

