/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.AppSupportVersionDao;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.exception.ParamFormatErrorException;
import com.digiwin.metadatacache.model.AppSupportVersion;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppSupportVersionAddService
extends AbstractApiService {
    @Autowired
    private AppSupportVersionDao appSupportVersionDao;

    public AppSupportVersionAddService() {
        this.jsonSchemaFileName = "app_support_version_add_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        ArrayNode tTenantIdArr = (ArrayNode)tRequestJsonNode.get("tenant_id");
        ArrayNode tAppVerArr = (ArrayNode)tRequestJsonNode.get("app_ver");
        for (JsonNode tTenantIdJsonNode : tTenantIdArr) {
            String tTenantId = tTenantIdJsonNode.asText();
            if (StringUtil.isEmptyOrSpace(tTenantId)) {
                throw new ParamFormatErrorException("\u79df\u6237Id\u4e0d\u53ef\u4e3a\u7a7a!", this.getClass());
            }
            for (JsonNode tAppVerJsonNode : tAppVerArr) {
                String tAppId = tAppVerJsonNode.get("appid").asText();
                String tVersion = tAppVerJsonNode.get("version").asText();
                if (StringUtil.isEmptyOrSpace(tAppId)) {
                    throw new ParamFormatErrorException("appId\u4e0d\u53ef\u4e3a\u7a7a!", this.getClass());
                }
                if (StringUtil.isEmptyOrSpace(tVersion)) {
                    throw new ParamFormatErrorException("app\u7248\u672c\u4e0d\u53ef\u4e3a\u7a7a!", this.getClass());
                }
                HashMap<String, String> tConditions = new HashMap<String, String>();
                tConditions.put("tenant_id", tTenantId);
                tConditions.put("appid", tAppId);
                List<AppSupportVersion> tAppSupportVersionList = this.appSupportVersionDao.fetch(tConditions);
                if (tAppSupportVersionList == null || tAppSupportVersionList.isEmpty()) {
                    AppSupportVersion tpAppSupportVersion = new AppSupportVersion();
                    tpAppSupportVersion.setTenantId(tTenantId);
                    tpAppSupportVersion.setAppId(tAppId);
                    tpAppSupportVersion.setAppVersion(tVersion);
                    this.appSupportVersionDao.add(tpAppSupportVersion);
                    continue;
                }
                for (AppSupportVersion tpAppSupportVersion : tAppSupportVersionList) {
                    tpAppSupportVersion.setAppVersion(tVersion);
                    this.appSupportVersionDao.update(tpAppSupportVersion);
                }
            }
        }
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

