/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.services.ElasticsearchService;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssetListGetService
extends AbstractApiService {
    @Autowired
    private ElasticsearchService elasticsearchService;

    public AssetListGetService() {
        this.jsonSchemaFileName = "asset_list_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        HashMap<String, String> mapCondition = new HashMap<String, String>();
        mapCondition.put("from", "0");
        mapCondition.put("size", "50");
        if (null != tRequestJsonNode.get("from") && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("from").asText())) {
            mapCondition.put("from", tRequestJsonNode.get("from").asText());
        }
        if (null != tRequestJsonNode.get("size") && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("size").asText())) {
            mapCondition.put("size", tRequestJsonNode.get("size").asText());
        }
        if (null != tRequestJsonNode.get("property_source") && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("property_source").asText())) {
            mapCondition.put("property_source", tRequestJsonNode.get("property_source").asText());
        }
        if (null != tRequestJsonNode.get("owner_product") && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("owner_product").asText())) {
            mapCondition.put("owner_product", tRequestJsonNode.get("owner_product").asText());
        }
        if (null != tRequestJsonNode.get("property_type") && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("property_type").asText())) {
            mapCondition.put("property_type", tRequestJsonNode.get("property_type").asText());
        }
        if (null != tRequestJsonNode.get("code") && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("code").asText())) {
            mapCondition.put("code", tRequestJsonNode.get("code").asText());
        }
        if (null != tRequestJsonNode.get("name") && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("name").asText())) {
            mapCondition.put("name", tRequestJsonNode.get("name").asText());
        }
        if (null != tRequestJsonNode.get("property_content") && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("property_content").asText())) {
            mapCondition.put("content", tRequestJsonNode.get("property_content").asText());
        }
        if (null != tRequestJsonNode.get("property_comment") && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("property_comment").asText())) {
            mapCondition.put("property_comment", tRequestJsonNode.get("property_comment").asText());
        }
        ObjectNode objectNode = this.elasticsearchService.searchAssetDataDoc(mapCondition);
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, (JsonNode)objectNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

